#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05ece27afeadee37fdaa61ddd4712866e4964bc0', '135.148.100.196', 1728918156, '__ci_last_regenerate|i:1728918156;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3947b585809ac87840daefcab160964f68d829cf', '176.240.247.83', 1728991096, '__ci_last_regenerate|i:1728991066;name|s:5:\"berat\";email|s:20:\"beratapo12@gmail.com\";role|s:1:\"1\";currently_logged_in|i:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('76fcceef73da9eae86669c3b47c92a9ba903914b', '176.240.247.83', 1728943057, '__ci_last_regenerate|i:1728943057;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('80fb88490c91706f3c99a9464ca44af21deeae94', '176.240.247.83', 1728942763, '__ci_last_regenerate|i:1728942610;name|s:5:\"berat\";email|s:20:\"beratapo12@gmail.com\";role|s:1:\"1\";currently_logged_in|i:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ff18047c0c3acf398fa8d1574649ac7595e3ac11', '205.210.31.132', 1728916127, '__ci_last_regenerate|i:1728916127;');


#
# TABLE STRUCTURE FOR: comments
#

DROP TABLE IF EXISTS `comments`;

CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL,
  `content_type` int(11) NOT NULL COMMENT '1=Movie, 2=WebSeries',
  `comment` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: config
#

DROP TABLE IF EXISTS `config`;

CREATE TABLE `config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `logo` text NOT NULL,
  `package_name` text NOT NULL COMMENT 'com.dooo.android',
  `api_key` mediumtext DEFAULT NULL COMMENT 'ADu4MiTh16BztQyI',
  `license_code` text NOT NULL COMMENT 'f242a233-22e0-40aa-b5ed-28d18be694cf',
  `license_user` text NOT NULL COMMENT 'syndic4te',
  `license_access_token` text NOT NULL COMMENT 'f242a233-22e0-40aa-b5ed-28d18be694cf',
  `license_token_type` text NOT NULL,
  `login_mandatory` int(11) NOT NULL COMMENT '0=No, 1=Yes',
  `maintenance` int(11) NOT NULL COMMENT '0=No, 1=Yes',
  `image_slider_type` int(11) NOT NULL COMMENT '0=Movie, 1=Web Series, 2=Custom, 3=Disable',
  `movie_image_slider_max_visible` int(11) NOT NULL DEFAULT 5,
  `webseries_image_slider_max_visible` int(11) NOT NULL DEFAULT 5,
  `onesignal_api_key` text NOT NULL,
  `onesignal_appid` text NOT NULL,
  `ad_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=No Ads, 1 =AdMob, 2=Startapp, 3=Facebook, 4=AdColony, 5=UnityAds, 6=CustomAds',
  `Admob_Publisher_ID` text NOT NULL,
  `Admob_APP_ID` text NOT NULL,
  `adMob_Native` text NOT NULL,
  `adMob_Banner` text NOT NULL,
  `adMob_Interstitial` text NOT NULL,
  `adMob_AppOpenAd` text NOT NULL,
  `StartApp_App_ID` text NOT NULL,
  `facebook_app_id` text NOT NULL,
  `facebook_banner_ads_placement_id` text NOT NULL,
  `facebook_interstitial_ads_placement_id` text NOT NULL,
  `Latest_APK_Version_Name` text NOT NULL,
  `Latest_APK_Version_Code` text NOT NULL,
  `APK_File_URL` text NOT NULL,
  `Whats_new_on_latest_APK` text NOT NULL,
  `Update_Skipable` int(11) NOT NULL DEFAULT 0 COMMENT '0=No, 1=Yes',
  `Update_Type` int(11) NOT NULL DEFAULT 0 COMMENT '0=In App, 1 = External Brawser, 2 = Playstore',
  `googleplayAppUpdateType` int(11) NOT NULL DEFAULT 0 COMMENT '0 = FLEXIBLE, 1 = IMMEDIATE',
  `Contact_Email` text NOT NULL,
  `SMTP_Host` text NOT NULL,
  `SMTP_Username` text NOT NULL,
  `SMTP_Password` text NOT NULL,
  `SMTP_Port` text NOT NULL,
  `SMTP_crypto` enum('none','ssl','tls') NOT NULL,
  `Dashboard_Version` text NOT NULL,
  `Dashboard_Version_Code` int(11) NOT NULL,
  `shuffle_contents` int(11) NOT NULL DEFAULT 0 COMMENT '0=No, 1=Yes',
  `Home_Rand_Max_Movie_Show` int(11) NOT NULL DEFAULT 0,
  `Home_Rand_Max_Series_Show` int(11) NOT NULL DEFAULT 0,
  `Home_Recent_Max_Movie_Show` int(11) NOT NULL DEFAULT 0,
  `Home_Recent_Max_Series_Show` int(11) NOT NULL DEFAULT 0,
  `Show_Message` int(11) NOT NULL DEFAULT 0 COMMENT '0=No, 1=Yes',
  `message_animation_url` text NOT NULL,
  `Message_Title` text NOT NULL,
  `Message` text NOT NULL,
  `all_live_tv_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=Free, 2=Paid',
  `all_movies_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=Free, 2=Paid',
  `all_series_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=Free, 2=Paid',
  `LiveTV_Visiable_in_Home` int(11) NOT NULL DEFAULT 1 COMMENT '0=No, 1=Yes',
  `TermsAndConditions` longtext NOT NULL,
  `PrivecyPolicy` longtext NOT NULL,
  `tmdb_language` text NOT NULL,
  `admin_panel_language` text NOT NULL,
  `genre_visible_in_home` int(11) NOT NULL DEFAULT 1 COMMENT '0=No, 1=Yes',
  `AdColony_app_id` text NOT NULL,
  `AdColony_banner_zone_id` text NOT NULL,
  `AdColony_interstitial_zone_id` text NOT NULL,
  `unity_game_id` text NOT NULL,
  `unity_banner_id` text NOT NULL,
  `unity_interstitial_id` text NOT NULL,
  `custom_banner_url` text NOT NULL,
  `custom_banner_click_url_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=nothing 1=External Brawser 2=Internal Brawser',
  `custom_banner_click_url` text NOT NULL,
  `custom_interstitial_url` text NOT NULL,
  `custom_interstitial_click_url_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=nothing 1=External Brawser 2=Internal Brawser',
  `custom_interstitial_click_url` text NOT NULL,
  `applovin_sdk_key` text NOT NULL,
  `applovin_apiKey` text NOT NULL,
  `applovin_Banner_ID` text NOT NULL,
  `applovin_Interstitial_ID` text NOT NULL,
  `ironSource_app_key` text NOT NULL,
  `movie_comments` int(11) NOT NULL COMMENT '0=Off, 1=On',
  `webseries_comments` int(11) NOT NULL COMMENT '0=Off, 1=On',
  `google_login` int(11) NOT NULL COMMENT '0=Disabled, 1=Enabled',
  `onscreen_effect` int(11) NOT NULL COMMENT '0=Nothing, 1=Snow',
  `razorpay_status` int(11) NOT NULL COMMENT '0=Disabled, 1=Enabled',
  `razorpay_key_id` text NOT NULL,
  `razorpay_key_secret` text NOT NULL,
  `paypal_status` int(11) NOT NULL COMMENT '0=Disabled, 1=Enabled',
  `paypal_type` int(11) NOT NULL,
  `paypal_clint_id` text NOT NULL,
  `paypal_secret_key` text NOT NULL,
  `content_item_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=v2',
  `live_tv_content_item_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=v2',
  `webSeriesEpisodeitemType` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=v2',
  `telegram_token` text NOT NULL,
  `telegram_chat_id` text NOT NULL,
  `splash_screen_type` int(11) NOT NULL DEFAULT 0 COMMENT '	0=Default, 1=Image, 2=Lottie, 3=Custom',
  `splash_bg_color` text NOT NULL,
  `splash_image_url` text NOT NULL,
  `splash_lottie_url` text NOT NULL,
  `cron_key` text NOT NULL,
  `cron_status` int(11) NOT NULL DEFAULT 0 COMMENT '0=Disabled, 1=Enabled',
  `auto_notification_status` int(11) NOT NULL DEFAULT 0 COMMENT '	0=Disabled, 1=Enabled',
  `auto_notification_schedule` int(11) NOT NULL DEFAULT 0,
  `db_backup_status` int(11) NOT NULL DEFAULT 0 COMMENT '	0=Disabled, 1=Enabled',
  `db_backup_schedule` int(11) NOT NULL DEFAULT 0,
  `safeModeVersions` text NOT NULL,
  `safeMode` int(11) NOT NULL DEFAULT 0,
  `primeryThemeColor` text NOT NULL,
  `blocked_regions` text NOT NULL,
  `pinLockStatus` int(11) NOT NULL,
  `pinLockPin` text NOT NULL,
  `flutterwave_status` int(11) NOT NULL,
  `flutterwave_public_key` text NOT NULL,
  `flutterwave_secret_key` text NOT NULL,
  `flutterwave_encryption_key` text NOT NULL,
  `onboarding_status` int(11) NOT NULL,
  `movieDefaultStreamLinkType` int(11) NOT NULL,
  `movieDefaultStreamLinkStatus` int(11) NOT NULL,
  `live_tv_genre_visible_in_home` int(11) NOT NULL DEFAULT 0,
  `login_otp_status` int(11) NOT NULL,
  `signup_otp_status` int(11) NOT NULL,
  `force_single_device` int(11) NOT NULL DEFAULT 0,
  `payment_gateway_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Payment Gateways, 1=Custom Gateways',
  `home_bottom_floting_menu_status` int(11) NOT NULL DEFAULT 0,
  `uddoktapay_status` int(11) NOT NULL,
  `uddoktapay_api_key` text NOT NULL,
  `uddoktapay_base_url` text NOT NULL,
  `bKash_status` int(11) NOT NULL,
  `bKash_app_key` text NOT NULL,
  `bKash_app_secret` text NOT NULL,
  `bKash_username` text NOT NULL,
  `bKash_password` text NOT NULL,
  `bKash_payment_type` int(11) NOT NULL COMMENT '0=Sandbox, 1=Live',
  `embed_error_code` text NOT NULL,
  `download_manager` int(11) NOT NULL DEFAULT 0 COMMENT '0=dooo download manager, 1=adm download manager',
  `player_intro` text NOT NULL,
  `image_proxy_status` int(11) NOT NULL DEFAULT 0,
  `image_storage_provider` int(11) NOT NULL COMMENT '0=default, 1=imgbb',
  `imgbb_api_key` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `config` (`id`, `name`, `logo`, `package_name`, `api_key`, `license_code`, `license_user`, `license_access_token`, `license_token_type`, `login_mandatory`, `maintenance`, `image_slider_type`, `movie_image_slider_max_visible`, `webseries_image_slider_max_visible`, `onesignal_api_key`, `onesignal_appid`, `ad_type`, `Admob_Publisher_ID`, `Admob_APP_ID`, `adMob_Native`, `adMob_Banner`, `adMob_Interstitial`, `adMob_AppOpenAd`, `StartApp_App_ID`, `facebook_app_id`, `facebook_banner_ads_placement_id`, `facebook_interstitial_ads_placement_id`, `Latest_APK_Version_Name`, `Latest_APK_Version_Code`, `APK_File_URL`, `Whats_new_on_latest_APK`, `Update_Skipable`, `Update_Type`, `googleplayAppUpdateType`, `Contact_Email`, `SMTP_Host`, `SMTP_Username`, `SMTP_Password`, `SMTP_Port`, `SMTP_crypto`, `Dashboard_Version`, `Dashboard_Version_Code`, `shuffle_contents`, `Home_Rand_Max_Movie_Show`, `Home_Rand_Max_Series_Show`, `Home_Recent_Max_Movie_Show`, `Home_Recent_Max_Series_Show`, `Show_Message`, `message_animation_url`, `Message_Title`, `Message`, `all_live_tv_type`, `all_movies_type`, `all_series_type`, `LiveTV_Visiable_in_Home`, `TermsAndConditions`, `PrivecyPolicy`, `tmdb_language`, `admin_panel_language`, `genre_visible_in_home`, `AdColony_app_id`, `AdColony_banner_zone_id`, `AdColony_interstitial_zone_id`, `unity_game_id`, `unity_banner_id`, `unity_interstitial_id`, `custom_banner_url`, `custom_banner_click_url_type`, `custom_banner_click_url`, `custom_interstitial_url`, `custom_interstitial_click_url_type`, `custom_interstitial_click_url`, `applovin_sdk_key`, `applovin_apiKey`, `applovin_Banner_ID`, `applovin_Interstitial_ID`, `ironSource_app_key`, `movie_comments`, `webseries_comments`, `google_login`, `onscreen_effect`, `razorpay_status`, `razorpay_key_id`, `razorpay_key_secret`, `paypal_status`, `paypal_type`, `paypal_clint_id`, `paypal_secret_key`, `content_item_type`, `live_tv_content_item_type`, `webSeriesEpisodeitemType`, `telegram_token`, `telegram_chat_id`, `splash_screen_type`, `splash_bg_color`, `splash_image_url`, `splash_lottie_url`, `cron_key`, `cron_status`, `auto_notification_status`, `auto_notification_schedule`, `db_backup_status`, `db_backup_schedule`, `safeModeVersions`, `safeMode`, `primeryThemeColor`, `blocked_regions`, `pinLockStatus`, `pinLockPin`, `flutterwave_status`, `flutterwave_public_key`, `flutterwave_secret_key`, `flutterwave_encryption_key`, `onboarding_status`, `movieDefaultStreamLinkType`, `movieDefaultStreamLinkStatus`, `live_tv_genre_visible_in_home`, `login_otp_status`, `signup_otp_status`, `force_single_device`, `payment_gateway_type`, `home_bottom_floting_menu_status`, `uddoktapay_status`, `uddoktapay_api_key`, `uddoktapay_base_url`, `bKash_status`, `bKash_app_key`, `bKash_app_secret`, `bKash_username`, `bKash_password`, `bKash_payment_type`, `embed_error_code`, `download_manager`, `player_intro`, `image_proxy_status`, `image_storage_provider`, `imgbb_api_key`) VALUES (1, 'diziproo', '', 'com.dooo.android', 'mFrwVyfkNs9tu8YZ', 'f242a233-22e0-40aa-b5ed-28d18be694cf', 'syndic4te', '1', '1', 1, 0, 0, 5, 5, '8b18c028-563b-4faf-9aa7-50f2bc8210d9', 'YjhhODE5ODktYmNhZC00MGJkLWI5ZmYtNTFjNDBmZWM3OGM3', 0, '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 0, 0, '', '', '', '', '', '', '', 0, 1, 90000, 90000, 90000, 90000, 0, '', '', '', 1, 1, 1, 1, '', '', 'tr-TR', '', 1, '', '', '', '', '', '', '', 0, '', '', 0, '', '', '', '', '', '', 1, 1, 0, 0, 0, '', '', 0, 0, '', '', 1, 1, 1, '7540492253:AAEPDKW0YdZitn-b6WiXF96KFC-U6TByFt0', '@diziproapp', 0, 'black', '', '', '', 0, 0, 0, 0, 0, '', 0, 'black', 'AF,AL,DZ,AS,AO,BS,BA', 0, '', 0, '', '', '', 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, '', '', 0, '', '', '', '', 0, '&lt;!DOCTYPE html&gt;&lt;html&gt;    &lt;head&gt;    &lt;link href=\"https://fonts.googleapis.com/css2?family=Nunito+Sans:wght@600;900&amp;display=swap\" rel=\"stylesheet\"&gt;    &lt;script src=\"https://kit.fontawesome.com/4b9ba14b0f.js\" crossorigin=\"anonymous\"&gt;&lt;/script&gt;    &lt;style&gt;body {  background-color: #95c2de;}.mainbox {  background-color: #95c2de;  margin: auto;  height: 400px;  width: 600px;  position: relative;}  .err {    color: #ffffff;    font-family: \'Nunito Sans\', sans-serif;    font-size: 8rem;    position:absolute;    left: 28%;    top: 8%;  }.far {  position: absolute;  font-size: 6.5rem;  left: 45%;  top: 15%;  color: #ffffff;} .err2 {    color: #ffffff;    font-family: \'Nunito Sans\', sans-serif;    font-size: 8rem;    position:absolute;    left: 65%;    top: 8%;  }.msg {    text-align: center;    font-family: \'Nunito Sans\', sans-serif;    font-size: 1.3rem;    position:absolute;    left: 16%;    top: 45%;    width: 75%;  }a {  text-decoration: none;  color: white;}a:hover {  text-decoration: underline;}    &lt;/style&gt;  &lt;/head&gt;  &lt;body&gt;    &lt;div class=\"mainbox\"&gt;      &lt;div class=\"err\"&gt;4&lt;/div&gt;      &lt;i class=\"far fa-question-circle fa-spin\"&gt;&lt;/i&gt;      &lt;div class=\"err2\"&gt;4&lt;/div&gt;      &lt;div class=\"msg\"&gt;Maybe this Content moved? Got deleted? Is hiding out in quarantine? Never existed in the first place?&lt;p&gt;Let\'s go Back and try from there.&lt;/p&gt;&lt;/div&gt;        &lt;/div&gt;      &lt;/body&gt;      &lt;/html&gt;', 0, '', 0, 0, '');


#
# TABLE STRUCTURE FOR: content_network_log
#

DROP TABLE IF EXISTS `content_network_log`;

CREATE TABLE `content_network_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `network_id` int(11) NOT NULL,
  `content_type` int(11) NOT NULL COMMENT '1=Movie, 2=WebSeries',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (1, 1, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (3, 3, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (4, 4, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (6, 2, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (7, 0, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (8, 5, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (9, 1, 1, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (10, 0, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (11, 6, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (13, 7, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (14, 8, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (16, 9, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (18, 2, 1, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (21, 4, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (23, 3, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (24, 10, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (25, 11, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (26, 12, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (27, 13, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (28, 5, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (29, 14, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (30, 6, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (31, 7, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (34, 15, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (35, 16, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (36, 0, 1, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (37, 0, 1, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (40, 9, 1, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (41, 17, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (42, 18, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (43, 19, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (44, 20, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (46, 21, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (47, 22, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (48, 23, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (49, 24, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (50, 25, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (51, 0, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (52, 10, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (53, 8, 1, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (54, 26, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (55, 27, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (56, 28, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (57, 29, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (58, 30, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (59, 31, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (60, 32, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (61, 33, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (62, 34, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (63, 35, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (65, 36, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (66, 37, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (67, 37, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (68, 38, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (69, 38, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (70, 39, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (71, 40, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (72, 40, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (73, 41, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (74, 41, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (75, 42, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (76, 42, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (77, 43, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (78, 43, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (79, 44, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (80, 44, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (81, 45, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (82, 46, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (84, 47, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (85, 47, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (86, 48, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (87, 49, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (88, 11, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (89, 12, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (90, 13, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (91, 50, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (93, 14, 2, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (94, 15, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (95, 51, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (96, 52, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (97, 53, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (98, 54, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (99, 55, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (101, 57, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (102, 56, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (103, 0, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (105, 59, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (107, 58, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (108, 60, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (109, 16, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (110, 61, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (111, 62, 2, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (112, 63, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (113, 64, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (117, 65, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (118, 66, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (120, 67, 1, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (121, 68, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (122, 69, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (126, 17, 0, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (127, 70, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (128, 71, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (129, 72, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (132, 18, 2, 2);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (133, 73, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (134, 74, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (135, 75, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (136, 76, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (137, 77, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (138, 78, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (139, 79, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (140, 80, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (141, 81, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (142, 82, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (143, 83, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (144, 84, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (145, 85, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (146, 86, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (147, 87, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (148, 0, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (149, 88, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (152, 89, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (153, 90, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (154, 91, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (155, 92, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (156, 93, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (157, 94, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (158, 95, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (159, 96, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (160, 97, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (161, 98, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (162, 99, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (163, 100, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (164, 101, 0, 1);
INSERT INTO `content_network_log` (`id`, `content_id`, `network_id`, `content_type`) VALUES (165, 102, 0, 1);


#
# TABLE STRUCTURE FOR: coupon
#

DROP TABLE IF EXISTS `coupon`;

CREATE TABLE `coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `coupon_code` text NOT NULL,
  `time` int(11) NOT NULL COMMENT 'Days',
  `amount` int(11) NOT NULL,
  `subscription_type` int(11) NOT NULL DEFAULT 0 COMMENT '1=Remove Ads, 2=Play Premium, 3=Download Premium	',
  `status` int(11) NOT NULL COMMENT '0=Expired, 1=Valid',
  `max_use` int(11) NOT NULL DEFAULT 1,
  `used` int(11) NOT NULL DEFAULT 0,
  `used_by` text NOT NULL,
  `expire_date` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `coupon` (`id`, `name`, `coupon_code`, `time`, `amount`, `subscription_type`, `status`, `max_use`, `used`, `used_by`, `expire_date`) VALUES (1, 'TR DUPLAJ', 'diziproo-jL0oJ6RS', 30, 50, 123, 1, 5, 0, '', '2024-09-20');
INSERT INTO `coupon` (`id`, `name`, `coupon_code`, `time`, `amount`, `subscription_type`, `status`, `max_use`, `used`, `used_by`, `expire_date`) VALUES (2, '', 'diziproo', 30, 30, 123, 1, 2, 1, '2', '2024-09-20');


#
# TABLE STRUCTURE FOR: custom_payment_requests
#

DROP TABLE IF EXISTS `custom_payment_requests`;

CREATE TABLE `custom_payment_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `payment_type` varchar(255) NOT NULL,
  `payment_details` varchar(255) NOT NULL,
  `subscription_name` varchar(255) NOT NULL,
  `subscription_type` int(11) NOT NULL,
  `subscription_time` int(11) NOT NULL,
  `subscription_amount` int(11) NOT NULL,
  `subscription_currency` int(11) NOT NULL COMMENT '0=INR,1=USD',
  `uploaded_image` text NOT NULL,
  `request_status` int(11) NOT NULL DEFAULT 0 COMMENT '0=pending, 1=approved, 2=declined',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: custom_payment_type
#

DROP TABLE IF EXISTS `custom_payment_type`;

CREATE TABLE `custom_payment_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `payment_details` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: custom_tag_log
#

DROP TABLE IF EXISTS `custom_tag_log`;

CREATE TABLE `custom_tag_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `custom_tags_id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL,
  `content_type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (1, 1, 6, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (2, 1, 7, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (3, 1, 8, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (4, 1, 15, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (5, 1, 16, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (6, 1, 0, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (7, 1, 9, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (8, 1, 17, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (9, 1, 18, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (10, 1, 19, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (11, 1, 20, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (12, 1, 10, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (13, 1, 22, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (14, 1, 24, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (15, 1, 28, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (16, 1, 47, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (17, 1, 48, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (18, 1, 57, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (19, 1, 59, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (20, 1, 58, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (21, 1, 60, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (22, 1, 61, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (23, 1, 62, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (24, 1, 63, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (26, 2, 65, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (27, 2, 66, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (28, 3, 67, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (29, 3, 68, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (30, 3, 69, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (31, 1, 70, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (32, 1, 17, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (33, 1, 72, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (34, 1, 18, 2);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (35, 1, 75, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (36, 1, 76, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (37, 1, 77, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (38, 1, 78, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (39, 2, 79, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (40, 1, 80, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (41, 1, 81, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (42, 1, 84, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (43, 1, 87, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (44, 1, 89, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (45, 1, 90, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (46, 1, 91, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (47, 1, 92, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (48, 1, 93, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (49, 1, 94, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (50, 1, 95, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (51, 1, 96, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (52, 1, 97, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (53, 1, 98, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (54, 1, 101, 1);
INSERT INTO `custom_tag_log` (`id`, `custom_tags_id`, `content_id`, `content_type`) VALUES (55, 1, 102, 1);


#
# TABLE STRUCTURE FOR: custom_tags
#

DROP TABLE IF EXISTS `custom_tags`;

CREATE TABLE `custom_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `background_color` text NOT NULL,
  `text_color` text NOT NULL,
  `created_at` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `custom_tags` (`id`, `name`, `background_color`, `text_color`, `created_at`, `updated_at`) VALUES (1, 'TR DUPLAJ', '#ff0000', '#ffffff', 1726346010, 1726346010);
INSERT INTO `custom_tags` (`id`, `name`, `background_color`, `text_color`, `created_at`, `updated_at`) VALUES (2, 'XBET', '#ff0000', '#ffffff', 1726346033, 1726346033);
INSERT INTO `custom_tags` (`id`, `name`, `background_color`, `text_color`, `created_at`, `updated_at`) VALUES (3, 'Yerli', '#ff0000', '#ffffff', 1728215647, 1728215665);


#
# TABLE STRUCTURE FOR: devices
#

DROP TABLE IF EXISTS `devices`;

CREATE TABLE `devices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `devices` (`id`, `device`) VALUES (1, 'cbec3a82ce3b5767');
INSERT INTO `devices` (`id`, `device`) VALUES (2, '849e5f91960b3aa4');


#
# TABLE STRUCTURE FOR: devices_log
#

DROP TABLE IF EXISTS `devices_log`;

CREATE TABLE `devices_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` int(11) NOT NULL,
  `open_date` text NOT NULL,
  `open_time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (1, 1, '09-10-2024', '05:03:47 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (2, 1, '09-10-2024', '06:57:03 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (3, 1, '09-10-2024', '07:07:31 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (4, 1, '09-10-2024', '07:10:21 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (5, 1, '09-10-2024', '07:43:16 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (6, 1, '09-10-2024', '07:43:57 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (7, 1, '09-10-2024', '08:02:58 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (8, 1, '09-11-2024', '08:53:26 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (9, 1, '09-11-2024', '11:56:47 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (10, 1, '09-11-2024', '11:59:57 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (11, 1, '09-11-2024', '05:29:03 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (12, 1, '09-11-2024', '05:33:20 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (13, 1, '09-11-2024', '05:37:36 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (14, 1, '09-11-2024', '05:38:19 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (15, 1, '09-11-2024', '06:04:14 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (16, 1, '09-11-2024', '06:09:03 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (17, 1, '09-11-2024', '06:21:14 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (18, 1, '09-11-2024', '06:28:42 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (19, 1, '09-11-2024', '06:43:38 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (20, 1, '09-11-2024', '07:03:09 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (21, 1, '09-11-2024', '07:16:48 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (22, 1, '09-11-2024', '07:19:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (23, 1, '09-11-2024', '07:21:40 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (24, 1, '09-11-2024', '07:24:30 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (25, 1, '09-11-2024', '07:25:44 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (26, 1, '09-11-2024', '07:27:45 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (27, 1, '09-11-2024', '07:32:26 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (28, 1, '09-11-2024', '07:34:13 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (29, 1, '09-11-2024', '07:44:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (30, 1, '09-11-2024', '07:47:57 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (31, 1, '09-11-2024', '07:49:59 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (32, 1, '09-11-2024', '08:00:08 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (33, 1, '09-11-2024', '08:34:07 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (34, 1, '09-11-2024', '08:39:14 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (35, 1, '09-12-2024', '03:08:40 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (36, 1, '09-12-2024', '07:33:45 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (37, 1, '09-12-2024', '08:09:14 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (38, 1, '09-13-2024', '03:05:37 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (39, 1, '09-13-2024', '05:46:39 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (40, 1, '09-13-2024', '05:57:43 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (41, 1, '09-13-2024', '06:54:29 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (42, 1, '09-13-2024', '08:47:47 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (43, 1, '09-14-2024', '10:16:56 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (44, 1, '09-14-2024', '10:30:56 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (45, 1, '09-14-2024', '07:10:43 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (46, 1, '09-14-2024', '07:17:59 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (47, 1, '09-14-2024', '07:26:06 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (48, 1, '09-14-2024', '07:29:23 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (49, 1, '09-14-2024', '07:32:28 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (50, 1, '09-14-2024', '07:51:18 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (51, 1, '09-14-2024', '07:52:31 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (52, 1, '09-14-2024', '07:54:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (53, 1, '09-14-2024', '07:55:24 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (54, 1, '09-14-2024', '07:56:02 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (55, 1, '09-14-2024', '07:58:04 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (56, 1, '09-14-2024', '07:59:52 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (57, 1, '09-14-2024', '08:27:28 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (58, 1, '09-14-2024', '08:37:36 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (59, 1, '09-14-2024', '08:44:12 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (60, 1, '09-14-2024', '08:45:55 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (61, 1, '09-15-2024', '11:42:15 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (62, 1, '09-15-2024', '11:51:50 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (63, 1, '09-15-2024', '11:59:28 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (64, 1, '09-15-2024', '12:09:12 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (65, 1, '09-15-2024', '12:10:38 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (66, 1, '09-15-2024', '05:25:20 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (67, 1, '09-15-2024', '05:29:16 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (68, 1, '09-15-2024', '06:47:33 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (69, 1, '09-15-2024', '06:50:13 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (70, 1, '09-15-2024', '07:32:24 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (71, 1, '09-15-2024', '07:41:12 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (72, 1, '09-16-2024', '11:57:25 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (73, 1, '09-16-2024', '02:05:30 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (74, 1, '09-16-2024', '02:20:49 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (75, 1, '09-17-2024', '12:20:09 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (76, 1, '09-17-2024', '12:20:50 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (77, 1, '09-17-2024', '08:57:01 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (78, 1, '09-17-2024', '10:00:00 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (79, 1, '09-18-2024', '10:24:52 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (80, 1, '09-18-2024', '10:30:19 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (81, 1, '09-18-2024', '10:32:01 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (82, 1, '09-18-2024', '05:51:02 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (83, 1, '09-18-2024', '05:53:10 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (84, 1, '09-18-2024', '05:55:09 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (85, 1, '09-18-2024', '05:56:10 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (86, 1, '09-18-2024', '06:52:32 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (87, 1, '09-19-2024', '11:34:31 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (88, 1, '09-19-2024', '11:43:18 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (89, 1, '09-19-2024', '11:55:20 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (90, 1, '09-19-2024', '02:37:45 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (91, 1, '09-19-2024', '02:40:35 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (92, 1, '09-19-2024', '02:42:16 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (93, 1, '09-19-2024', '02:46:13 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (94, 1, '09-19-2024', '04:31:40 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (95, 1, '09-19-2024', '10:03:38 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (96, 1, '09-19-2024', '11:05:58 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (97, 1, '09-20-2024', '11:54:38 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (98, 1, '09-20-2024', '12:02:30 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (99, 1, '09-20-2024', '12:03:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (100, 1, '09-20-2024', '12:11:32 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (101, 1, '09-20-2024', '12:26:37 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (102, 1, '09-20-2024', '12:30:33 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (103, 1, '09-20-2024', '09:04:40 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (104, 1, '09-20-2024', '10:35:04 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (105, 1, '09-20-2024', '10:47:04 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (106, 1, '09-20-2024', '11:21:47 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (107, 1, '09-20-2024', '11:23:01 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (108, 1, '09-20-2024', '11:26:29 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (109, 1, '09-21-2024', '11:06:18 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (110, 1, '09-21-2024', '11:53:56 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (111, 1, '09-21-2024', '01:00:29 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (112, 1, '09-21-2024', '01:01:30 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (113, 1, '09-21-2024', '01:17:44 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (114, 1, '09-26-2024', '06:04:07 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (115, 1, '09-26-2024', '06:39:06 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (116, 1, '09-29-2024', '02:39:20 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (117, 1, '09-29-2024', '03:09:09 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (118, 1, '09-29-2024', '06:27:36 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (119, 1, '09-29-2024', '06:34:32 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (120, 1, '09-29-2024', '06:47:01 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (121, 1, '09-29-2024', '06:50:19 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (122, 1, '09-29-2024', '07:32:23 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (123, 1, '09-30-2024', '05:49:33 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (124, 1, '09-30-2024', '06:45:28 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (125, 2, '10-04-2024', '03:32:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (126, 2, '10-04-2024', '04:43:42 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (127, 2, '10-04-2024', '05:17:51 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (128, 2, '10-04-2024', '05:20:31 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (129, 2, '10-04-2024', '06:29:23 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (130, 2, '10-04-2024', '07:18:54 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (131, 2, '10-04-2024', '07:26:56 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (132, 2, '10-04-2024', '07:28:08 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (133, 2, '10-04-2024', '07:56:47 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (134, 2, '10-04-2024', '08:37:26 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (135, 2, '10-04-2024', '08:58:55 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (136, 2, '10-04-2024', '09:18:50 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (137, 2, '10-04-2024', '09:22:15 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (138, 2, '10-05-2024', '09:18:59 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (139, 2, '10-05-2024', '09:22:02 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (140, 2, '10-05-2024', '12:58:32 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (141, 2, '10-05-2024', '01:02:51 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (142, 2, '10-05-2024', '01:05:26 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (143, 2, '10-05-2024', '08:31:37 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (144, 2, '10-05-2024', '08:38:05 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (145, 2, '10-05-2024', '08:40:45 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (146, 2, '10-05-2024', '09:01:20 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (147, 2, '10-05-2024', '10:04:43 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (148, 2, '10-05-2024', '10:07:08 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (149, 2, '10-05-2024', '10:17:10 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (150, 2, '10-05-2024', '10:18:59 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (151, 2, '10-05-2024', '10:27:39 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (152, 2, '10-05-2024', '10:45:12 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (153, 2, '10-06-2024', '10:56:52 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (154, 2, '10-06-2024', '10:59:06 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (155, 2, '10-06-2024', '11:45:41 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (156, 2, '10-06-2024', '11:49:02 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (157, 2, '10-06-2024', '12:01:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (158, 2, '10-06-2024', '12:09:21 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (159, 2, '10-06-2024', '12:10:33 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (160, 2, '10-06-2024', '12:47:53 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (161, 2, '10-06-2024', '12:49:39 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (162, 2, '10-06-2024', '12:55:17 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (163, 2, '10-06-2024', '01:00:23 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (164, 2, '10-06-2024', '01:04:13 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (165, 2, '10-06-2024', '01:12:54 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (166, 2, '10-06-2024', '01:15:51 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (167, 2, '10-06-2024', '01:18:40 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (168, 2, '10-06-2024', '01:46:47 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (169, 2, '10-06-2024', '07:49:57 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (170, 2, '10-06-2024', '07:57:25 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (171, 2, '10-06-2024', '08:01:38 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (172, 2, '10-06-2024', '08:16:28 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (173, 2, '10-06-2024', '08:25:12 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (174, 2, '10-06-2024', '08:26:13 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (175, 2, '10-06-2024', '08:49:45 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (176, 2, '10-06-2024', '10:04:31 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (177, 2, '10-07-2024', '11:05:47 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (178, 2, '10-07-2024', '11:06:26 am');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (179, 2, '10-07-2024', '06:17:38 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (180, 2, '10-07-2024', '06:31:56 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (181, 2, '10-07-2024', '09:06:21 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (182, 2, '10-07-2024', '10:55:41 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (183, 2, '10-08-2024', '07:07:32 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (184, 2, '10-08-2024', '07:10:30 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (185, 2, '10-10-2024', '01:08:37 pm');
INSERT INTO `devices_log` (`id`, `device_id`, `open_date`, `open_time`) VALUES (186, 2, '10-10-2024', '01:16:48 pm');


#
# TABLE STRUCTURE FOR: disposable_emails
#

DROP TABLE IF EXISTS `disposable_emails`;

CREATE TABLE `disposable_emails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emails` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: episode_download_links
#

DROP TABLE IF EXISTS `episode_download_links`;

CREATE TABLE `episode_download_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `size` text NOT NULL,
  `quality` text NOT NULL,
  `link_order` int(11) NOT NULL,
  `episode_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `type` text NOT NULL,
  `download_type` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: episode_play_links
#

DROP TABLE IF EXISTS `episode_play_links`;

CREATE TABLE `episode_play_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `size` text NOT NULL,
  `quality` text NOT NULL,
  `link_order` int(11) NOT NULL,
  `episode_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `type` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '	0=Not Released, 1=Released',
  `skip_available` int(11) NOT NULL COMMENT '	0=No, 1=Yes',
  `intro_start` text NOT NULL,
  `intro_end` text NOT NULL,
  `end_credits_marker` text NOT NULL,
  `link_type` int(11) NOT NULL COMMENT '0=NotPremium, 1=Premium',
  `drm_uuid` text NOT NULL COMMENT 'WIDEVINE,PLAYREADY,CLEARKEY	',
  `drm_license_uri` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (1, 'TR', '', '1080p', 1, 3, 'https://playerwish.com/e/gxjjxoq8l856', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (2, 'TR', '', '1090p', 1, 1, 'https://playerwish.com/e/h5r3r5qhvan9', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (3, 'TR', '', '720p', 1, 12, 'https://storage.diziyou.co/episodes/93701_tr/720p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (4, 'TR', '', '720p', 1, 10, 'https://storage.diziyou.co/episodes/93702_tr/720p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (5, '', '', '', 1, 16, 'https://playerwish.com/e/hmnvo94puacx', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (6, '', '', '', 0, 18, 'https://playerwish.com/e/6n5sa7vyxbud', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (7, '', '', '', 1, 32, 'https://playerwish.com/e/x4za7ot3acb8', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (8, '', '', '', 1, 24, 'https://playerwish.com/e/07j85h58pqy3', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (9, '1', '', '', 1, 34, 'https://playerwish.com/e/oqs63z0g5fub', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (10, '3.bolum', '', '', 3, 5, 'https://playerwish.com/e/gyfwiwsvbfcq', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (11, '4', '', '', 4, 4, 'https://playerwish.com/e/22kjt11n578u', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (12, '5', '', '', 5, 2, 'https://playerwish.com/e/23vbmbtycu4n', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (13, '2x1', '', '', 1, 35, 'https://playerwish.com/e/ezjlbp84i8o3', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (14, '2x2', '', '', 2, 36, 'https://playerwish.com/e/6wuajkabhs51', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (15, '1x1', '', '', 1, 40, 'https://playerwish.com/e/buvejxfksjoy', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (16, 'DUAL', '', '', 1, 49, 'https://playerwish.com/e/k7519h5fjk85', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (17, 'S01E02', '', '', 0, 47, 'https://playerwish.com/e/g4n8jxg3e91p', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (18, 'S01E03', '', '', 3, 42, 'https://playerwish.com/e/06bk0pp5io1s', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (19, ' XBET', '', '', 2, 51, 'https://playerwish.com/e/covjl613e9wk', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (20, '3.bolum', '', '', 1, 52, 'https://playerwish.com/e/2styojzp565i', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (21, '4', '', '', 1, 53, 'https://playerwish.com/e/j2c9jx21011l', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (23, '5', '', '', 0, 54, 'https://playerwish.com/e/xqugbk4k0z54', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (24, 'TR Duplaj', '', '', 1, 56, 'https://storage.diziyou.co/episodes/13351_tr/720p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (25, 'TR DUPLAJ', '', '', 1, 57, 'https://storage.diziyou.co/episodes/13352_tr/720p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (26, 'TR DUPLAJ', '', '', 1, 60, 'https://storage.diziyou.co/episodes/13353_tr/720p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (27, 'TR DUPLAJ', '', '', 1, 59, 'https://storage.diziyou.co/episodes/13354_tr/720p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (29, '', '', '', 0, 80, 'https://www.youtube.com/watch?v=uDGqZIB5Ed8&t=25s', 'Youtube', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (30, 'Dizipro', '', '', 0, 17, 'https://playerwish.com/e/jq26k1c08hed', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (31, 'EN', '', '1080p', 1, 91, 'https://www.mp4upload.com/embed-gsu3qy09z7ma.html', 'Embed', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (32, '', '', '', 0, 96, 'https://hydra.unbelievable35.shop/initial-d/1/1/480.mp4', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (33, 'Diziproo', '', '', 0, 128, 'https://r3.5dk.org/storage/media/0f837ec02c1fc8d6d50c1d3815a1929b-720.mp4/gomindex.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (34, 'Diziproo', '', '', 0, 130, 'https://r1.5dk.org/storage/media/60b1ff8713bd62556f76d23afb1dcdaf-720.mp4/gomindex.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (35, 'Diziproo', '', '', 0, 123, 'https://r3.5dk.org/storage/media/4c2d0f0b6b156d726f2c0a3415e3be05-720.mp4/gomindex.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (36, '', '', '', 0, 138, '8?t=tz2ghO2S232HWCNP1ceIiadmLnPR70qrDYZZdFpubLk&s=1727635711&e=43200&f=125582&srv=x1&i=0.0&sp=5000&p1=bialystok&p2=bialystok', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (39, 'TR', '', '', 0, 140, 'https://marseille.cdn77.host/hls2/02/00002/dd54ujse14ii_n/index-v1-a2.m3u8?t=Mz4-YTYwBkVUEQR5hCk_8hal4Gue0WKjGCa8VfazJOA&s=1728218421&e=43200&f=10046&srv=x2&i=0.0&sp=5000&fr=dd54ujse14ii&p1=marseille&p2=marseille', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (40, 'DUAL', '', '', 0, 156, 'https://hlswish.com/zpvvx5zloobk', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (41, 'DUAL', '', '', 0, 150, 'https://hlswish.com/tiav6sy06v7h', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (42, 'Dual', '', '', 0, 152, 'https://hlswish.com/2dswdc3mfy63', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (43, 'DUAL', '', '', 0, 149, 'https://hlswish.com/kc7citis2zx2', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (44, 'Dual', '', '', 0, 157, 'https://hlswish.com/yvvx6sebj859', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (45, 'Dual', '', '', 0, 154, 'https://hlswish.com/1rsfo95xw6ia', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (46, 'Dual', '', '', 0, 155, 'https://hlswish.com/i9cvo7bc4s91', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (47, 'Dual', '', '', 0, 151, 'https://hlswish.com/xwgxcxc39uin', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (48, 'Dual', '', '', 0, 153, 'https://hlswish.com/b4bvqkfpbk3p', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (49, '', '', '', 0, 163, 'https://hlswish.com/7cr2h96mbzuq', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (50, '', '', '', 0, 158, 'https://hlswish.com/adibte7vgcbg', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `episode_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `episode_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (51, '', '', '', 0, 159, 'https://hlswish.com/74zjhf8qvjdf', 'Mp4', 1, 0, '', '', '0', 0, '', '');


#
# TABLE STRUCTURE FOR: favourite
#

DROP TABLE IF EXISTS `favourite`;

CREATE TABLE `favourite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` text NOT NULL,
  `content_type` mediumtext NOT NULL,
  `content_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (1, 'cbec3a82ce3b5767', 'Movie', 1);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (2, 'cbec3a82ce3b5767', 'Movie', 4);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (3, 'cbec3a82ce3b5767', 'Movie', 3);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (4, '2', 'Movie', 15);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (5, '3', 'Movie', 57);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (6, '3', 'Movie', 58);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (7, '3', 'Movie', 65);
INSERT INTO `favourite` (`id`, `user_id`, `content_type`, `content_id`) VALUES (8, '3', 'WebSeries', 18);


#
# TABLE STRUCTURE FOR: genres
#

DROP TABLE IF EXISTS `genres`;

CREATE TABLE `genres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `icon` text NOT NULL,
  `description` longtext NOT NULL,
  `featured` int(11) NOT NULL COMMENT '0=NotFeatured, 1=Featured',
  `status` int(11) NOT NULL COMMENT '	0=NotPublished, 1=Published',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (1, 'Action', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (2, 'Crime', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (3, 'Aksiyon', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (4, 'Dram', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (5, 'Romantik', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (6, 'Animasyon', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (7, 'Komedi', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (8, 'Aile', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (9, 'Macera', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (10, 'Tarih', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (11, 'SavaÅŸ', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (12, 'Aksiyon & Macera', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (13, 'SuÃ§', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (14, 'Bilim-Kurgu', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (15, 'Bilim Kurgu & Fantazi', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (16, 'Ã‡ocuklar', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (17, 'Gerilim', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (18, 'Talk', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (19, 'MÃ¼zik', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (20, 'Fantastik', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (21, 'Adventure', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (22, 'Fantasy', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (23, 'Gizem', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (24, 'Korku', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (25, 'Suç', '', '', 0, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (26, 'aile-filmleri', '', '', 1, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (27, 'Hint', '', 'Hint filmler', 1, 1);
INSERT INTO `genres` (`id`, `name`, `icon`, `description`, `featured`, `status`) VALUES (28, 'Fantastik Dörtlü Serisi', '', 'Fantastik Dörtlü Serisi', 1, 1);


#
# TABLE STRUCTURE FOR: google_drive_accounts
#

DROP TABLE IF EXISTS `google_drive_accounts`;

CREATE TABLE `google_drive_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` text NOT NULL,
  `client_id` text NOT NULL,
  `client_secret` text NOT NULL,
  `refresh_token` text NOT NULL,
  `access_token` text NOT NULL,
  `expires_in` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` int(11) NOT NULL,
  `updated_at` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: image_slider
#

DROP TABLE IF EXISTS `image_slider`;

CREATE TABLE `image_slider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `banner` text NOT NULL,
  `content_type` int(11) NOT NULL COMMENT '0=Movie,1=WebSeries,2=WebView,3=External Browser',
  `content_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '	0=UnPublished, 1=Published',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: live_tv_channels
#

DROP TABLE IF EXISTS `live_tv_channels`;

CREATE TABLE `live_tv_channels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `banner` text NOT NULL,
  `stream_type` text NOT NULL,
  `url` text NOT NULL,
  `content_type` int(11) NOT NULL DEFAULT 3 COMMENT '	1=Movie, 2=WebSeries, 3=LiveTV',
  `type` int(11) NOT NULL DEFAULT 0 COMMENT '	0=NotPremium, 1=Premium',
  `status` int(11) NOT NULL DEFAULT 1 COMMENT '0=No, 1=Yes',
  `featured` int(11) NOT NULL DEFAULT 0 COMMENT '0=No, 1=Yes',
  `user_agent` text NOT NULL,
  `referer` text NOT NULL,
  `cookie` text NOT NULL,
  `headers` longtext NOT NULL,
  `drm_uuid` text NOT NULL COMMENT 'WIDEVINE,PLAYREADY,CLEARKEY	',
  `drm_license_uri` text NOT NULL,
  `genres` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (2, 'TRT 2', 'https://cms-tabii-public-image.tabii.com/int/w300/23848_1-0-465-262.jpeg', 'M3u8', 'https://tv-trt2.medya.trt.com.tr/master_720.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (3, '24 TV', 'https://i.imgur.com/8FO41es.png', 'M3u8', 'https://kanal24.blutv.com/blutv_kanal24_live/live.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (4, '360 TV', 'https://i.imgur.com/agn47sQ.png', 'M3u8', 'https://turkmedya-live.ercdn.net/tv360/tv360.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (5, 'Star TV', 'https://tvakisi.com/public/resimler/kanallar/star-tv-886.webp', 'M3u8', 'https://dogus-live.daioncdn.net/startv/startv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (6, 'TRT 1', 'https://cms-tabii-public-image.tabii.com/int/webp/w300/q84/23846_1-0-465-262.jpeg', 'M3u8', 'https://tv-trt1.medya.trt.com.tr/master_720.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (7, 'TRT BELGESEL', 'https://cms-tabii-public-image.tabii.com/int/webp/w300/q84/23850_1-0-465-262.jpeg', 'M3u8', 'https://tv-trtbelgesel.medya.trt.com.tr/master_720.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (10, 'TRT 1', 'http://assets.tvcdn.net/1045ea2f-2453-451d-a55f-ba17539641dd.png', 'Dash', 'https://trt.daioncdn.net/trt-1/master_1080p.m3u8?&sid=6spb9obm204r&app=ed3904e8-737b-4a5e-856a-1b0d7a0a94e2&ce=2', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel,Haber');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (11, 'Kanal D', 'http://assets.tvcdn.net/a06096dc-fd5e-4103-bfb4-83e612df23ec.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/kanal-d.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (12, 'Atv', 'http://assets.tvcdn.net/89a47b4b-5d20-4248-9f4c-a3d2756072dd.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/atv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (13, 'Blutv play 1', 'https://blutv-images.mncdn.com/q/t/i/bluv2/100/70x70/6295d4b4866ac31658881736', 'M3u8', 'https://play1.blutv.com/blutv_play1/smil:blutv_play1.smil/chunklist_b3128000_DVR.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (14, 'Now TV', 'http://assets.tvcdn.net/80eb8816-1855-41f5-9002-7a05cc93fe4f.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/now-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (15, 'Show TV', 'http://assets.tvcdn.net/9d873881-bb5e-40f0-88db-8c47aa215e5a.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/show-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (16, 'Beyaz TV', 'http://assets.tvcdn.net/60d7aaf4-817b-46be-bbab-68f8b30de8fb.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/beyaz-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (17, 'Kanal 7', 'http://assets.tvcdn.net/1125734c-3525-4390-b8ed-c50380c70e4d.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/kanal-7.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (18, 'TV8', 'http://assets.tvcdn.net/f91342d2-bcae-4ee0-a6f8-76a8d32b891b.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/tv8.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (19, 'Star TV', 'http://assets.tvcdn.net/0c5204fb-e613-4084-b300-8cdcc46309f9.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/star-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (20, '360 TV', 'http://assets.tvcdn.net/e1c3f150-4f79-4ac4-a893-4cc1144eb2d5.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/360-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (21, 'TV 100', 'http://assets.tvcdn.net/d7741078-ccce-47d8-ba1c-a041b659bad6.png', 'M3u8', 'http://stream.tvcdn.net/ulusal/tv-100.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (22, 'TRT Turk', 'http://assets.tvcdn.net/fbaaa75c-0a2d-4ed6-b498-d32a59ddb899.png', 'M3u8', 'http://stream.tvcdn.net/ulusal-yurt-disi/trt-turk.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (23, 'TRT Avaz', 'http://assets.tvcdn.net/53dd1d5f-aa72-4bea-91d0-8c2d00783367.png', 'M3u8', 'http://stream.tvcdn.net/ulusal-yurt-disi/trt-avaz.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (24, 'ATV Avrupa', 'http://assets.tvcdn.net/6d19cf7f-9057-4055-9aa8-532fdd0bdab5.png', 'M3u8', 'http://stream.tvcdn.net/ulusal-yurt-disi/atv-avrupa.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (25, 'Euro D', 'https://film.dizipro3.gen.tr/assets/images/Dooo_poster_placeholder.png', 'M3u8', 'http://stream.tvcdn.net/ulusal-yurt-disi/euro-d.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (26, 'TGRT EU', 'http://assets.tvcdn.net/01032651-eac6-48ea-b6ef-78acf8e95daa.png', 'M3u8', 'http://stream.tvcdn.net/ulusal-yurt-disi/tgrt-eu.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (27, 'Show Turk', 'http://assets.tvcdn.net/d4d340ec-891e-4601-9776-e979a750b7e3.png', 'M3u8', 'http://stream.tvcdn.net/ulusal-yurt-disi/show-turk.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', '');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (29, 'A Haber', 'http://assets.tvcdn.net/06e7abd9-0fbb-441f-af63-b895513d3aaa.png', 'M3u8', 'http://stream.tvcdn.net/haber/a-haber.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Spor');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (31, 'TGRT Haber', 'http://assets.tvcdn.net/a4303694-1faa-4436-aa0f-c5f3ca2b157a.png', 'M3u8', 'http://stream.tvcdn.net/haber/tgrt-haber.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Haber');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (32, 'TRT Haber', 'http://assets.tvcdn.net/ecbd3154-e8e7-44d7-bcbd-a9bcac9df4de.png', 'M3u8', 'http://stream.tvcdn.net/haber/trt-haber.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Haber');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (33, 'A Haber', 'http://assets.tvcdn.net/06e7abd9-0fbb-441f-af63-b895513d3aaa.png', 'M3u8', 'http://stream.tvcdn.net/haber/a-haber.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Haber');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (34, 'CNN Turk', 'http://assets.tvcdn.net/db0e3f2f-3191-4af2-9cde-5345eb7543e4.png', 'M3u8', 'http://stream.tvcdn.net/haber/cnn-turk.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Haber');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (36, 'BeIN Sports 1 Hd', 'https://justsporthd20.xyz/channel_logo/bein1.png', 'M3u8', 'https://empty-cell-3d19.esraaslsls.workers.dev/https://tayland.canlimachd10.site/hls/bein-sports-1.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Spor,BeIN Sports');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (37, 'TRT Ã‡ocuk', 'https://cdn-i.pr.trt.com.tr/trttv/w750/h750/q100/13060701.png', 'M3u8', 'https://tv-trtcocuk.medya.trt.com.tr/master_720.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (38, 'TRT Diyanet Ã‡ocuk', 'http://assets.tvcdn.net/dba05bf2-9d24-4d20-bc6c-f54a2b60ef7f.png', 'M3u8', 'http://stream.tvcdn.net/cocuk-egitim/trt-diyanet-cocuk.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (39, 'Cartoon Network', 'https://i.ibb.co/X5yPXkD/cartoon-network.png', 'M3u8', 'http://stream.tvcdn.net/cocuk-egitim/cartoon-network.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (40, 'MinikaGo', 'https://i.ibb.co/2ZwxWr0/minika-go.png', 'M3u8', 'http://stream.tvcdn.net/cocuk-egitim/minika-go.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (41, 'Minika Ã‡ocuk', 'https://i.ibb.co/S794c6W/minika-cocuk.png', 'M3u8', 'http://stream.tvcdn.net/cocuk-egitim/minika-cocuk.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (42, 'Cartoonito TV', 'https://blutv-images.mncdn.com/q/t/i/bluv2/100/500x500/64f57b42866ac307e484249e', 'M3u8', 'https://cartoonito.blutv.com/blutv_cartoonito/smil:cartoonito.smil/playlist.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (43, 'Zarok TV', 'https://upload.wikimedia.org/wikipedia/commons/e/ee/1_ZarokTVLogonet5.png', 'M3u8', 'https://zindikurmanci.zaroktv.com.tr/hls/stream.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (44, 'beIN SPORTS Haber', 'https://www.tvyayinakisi.com/wp-content/uploads/2020/05/bein-sports-haber-logo.jpg.webp', 'M3u8', 'http://stream.tvcdn.net/spor/bein-sports-haber.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Spor,BeIN Sports');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (45, 'Adult Swim Home Movies', 'data:image/png;base64,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', 'M3u8', 'https://adultswim-vodlive.cdn.turner.com/live/test-2/stream_de.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (47, 'Adult Swim Channel 5 (1080p) EN', 'https://i.imgur.com/G9TyeCN.png', 'M3u8', 'https://adultswim-vodlive.cdn.turner.com/live/channel-5/stream_de.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (48, 'S SPORT 1', 'https://cdn.ssportplus.com/1/3165/4upTfT87RjGX/4upTfT87RjGX.jpg', 'M3u8', 'https://empty-cell-3d19.esraaslsls.workers.dev/https://tayland.canlimachd10.site/hls/s-sport.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Spor,BeIN Sports');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (49, 'SPORT \' HD', 'https://cdn.ssportplus.com/1/3165/b09Kd3Vb00ud/b09Kd3Vb00ud.png', 'M3u8', 'https://cinque.3c44f92c0de36be1.shop/p/www.canlimaclar1741.sbs/3451/f.cf-worker-db4b460c40abc3a7.workers.dev/chunklist_hd.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Spor');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (50, 'Blutv play 2', 'https://blutv-images.mncdn.com/q/t/i/bluv2/100/70x70/6295d42d866ac31658881732', 'M3u8', 'https://play2.blutv.com/blutv_play2/smil:blutv_play2.smil/playlist.m3u8?DVR', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel,FİLM');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (51, 'Beyaz YV', 'https://blutv-images.mncdn.com/q/t/i/bluv2/100/70x70/5c63c27a866ac30cbc2ad836', 'Dash', 'https://beyaztv.daioncdn.net/beyaztv/beyaztv_480p.m3u8?&sid=6r43hwrzzatb&app=fcd5c66b-da9d-44ba-a410-4f34805c397d&ce=3', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel,Spor,Haber,BeIN Sports');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (52, 'TÄ°VÄ° 6', 'https://i.ibb.co/sRNHKjS/tivi622.png', 'M3u8', 'https://live.artidijitalmedya.com/artidijital_tivi6/tivi6/playlist.m3u', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (53, 'Sinema TV 1', 'http://assets.tvcdn.net/d471fb03-10ce-47e0-bc25-e2b3f5feba98.png', 'M3u8', 'http://stream.tvcdn.net/diger-eglence/sinema-tv-1.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (54, 'Sinema TV 2', 'http://assets.tvcdn.net/d471fb03-10ce-47e0-bc25-e2b3f5feba98.png', 'M3u8', 'http://stream.tvcdn.net/diger-eglence/sinema-tv-2.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (55, 'Dizi Film TV', 'http://assets.tvcdn.net/2b0e5b6e-3c75-4d34-b392-90330b629bbb.png', 'M3u8', 'http://stream.tvcdn.net/eglence/dizi-film-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Ã‡izgiFilm');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (56, 'TRT World', 'https://cms-tabii-public-image.tabii.com/int/w300/23864_1-0-465-262.jpeg', 'M3u8', 'https://tv-trtworld.medya.trt.com.tr/master_1080.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel,Haber');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (57, 'Belgesel TV', 'http://assets.tvcdn.net/6982e864-f429-4e6e-b3ba-d064ae84ff13.png', 'M3u8', 'http://stream.tvcdn.net/eglence/belgesel-tv.m3u8', 3, 0, 1, 1, '', '', '', '[]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (58, 'Hollywood 6', 'https://images.summitmedia-digital.com/spotph/images/files/2012/01/1326757737-Hollywood-Films_370.jpg', 'M3u8', 'http://aldirect.hls.huya.com/huyalive/29169025-2686220018-11537227127170531328-2847699120-10057-A-1524041208-1_1200.m3u8', 3, 0, 1, 1, '', '', '', '[{\"header\":\"Hollywood Movies 6\"}]', '', '', 'Genel');
INSERT INTO `live_tv_channels` (`id`, `name`, `banner`, `stream_type`, `url`, `content_type`, `type`, `status`, `featured`, `user_agent`, `referer`, `cookie`, `headers`, `drm_uuid`, `drm_license_uri`, `genres`) VALUES (59, 'Adult-Time 01', 'http://95.214.234.141:4565/images/oTAfZEvCK-L0PmQhKyuoB8DEX0LIGi01jv1_TzIJ3OcqvL2F1HZ6hmji9aRcw2Jnh-825NKNje91lhhMOcSusu4tk350QykdSlTdj2Akc0w.jpg', 'Mp4', 'http://050518.pro:8000/movie/ada3fu13p/LYqJjGFw/56459.mp4', 3, 0, 1, 1, '', '', '', '[]', '', '', '');


#
# TABLE STRUCTURE FOR: live_tv_genres
#

DROP TABLE IF EXISTS `live_tv_genres`;

CREATE TABLE `live_tv_genres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '0=NotPublished, 1=Published',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (1, 'Genel', 1);
INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (2, 'Spor', 1);
INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (3, 'Haber', 1);
INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (4, 'BeIN Sports', 1);
INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (5, 'Ã‡izgiFilm', 1);
INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (6, 'Ã–zel', 1);
INSERT INTO `live_tv_genres` (`id`, `name`, `status`) VALUES (7, 'FİLM', 1);


#
# TABLE STRUCTURE FOR: mail_templates
#

DROP TABLE IF EXISTS `mail_templates`;

CREATE TABLE `mail_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` text NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: mail_token_details
#

DROP TABLE IF EXISTS `mail_token_details`;

CREATE TABLE `mail_token_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(4) NOT NULL,
  `token` text NOT NULL,
  `mail` text NOT NULL,
  `type` text NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0 COMMENT '0=Not Used, 1=Used',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: movie_download_links
#

DROP TABLE IF EXISTS `movie_download_links`;

CREATE TABLE `movie_download_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `size` text NOT NULL,
  `quality` text NOT NULL,
  `link_order` int(11) NOT NULL,
  `movie_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `type` text NOT NULL,
  `download_type` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '0=Not Released, 1=Released',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `movie_download_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `download_type`, `status`) VALUES (1, 'Multiquality', '', '', 1, 50, 'https://vidtube.pro/d/p4z09cfj7tjk.html', 'vidtube', 'Internal', 1);


#
# TABLE STRUCTURE FOR: movie_play_links
#

DROP TABLE IF EXISTS `movie_play_links`;

CREATE TABLE `movie_play_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `size` text NOT NULL,
  `quality` text NOT NULL,
  `link_order` int(11) NOT NULL,
  `movie_id` int(11) NOT NULL,
  `url` text NOT NULL,
  `type` text NOT NULL,
  `status` int(11) NOT NULL COMMENT '0=Not Released, 1=Released',
  `skip_available` int(11) NOT NULL DEFAULT 0 COMMENT '0=No, 1=Yes',
  `intro_start` text NOT NULL,
  `intro_end` text NOT NULL,
  `end_credits_marker` text NOT NULL,
  `link_type` int(11) NOT NULL COMMENT '0=NotPremium, 1=Premium',
  `drm_uuid` text NOT NULL COMMENT 'WIDEVINE,PLAYREADY,CLEARKEY',
  `drm_license_uri` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (1, '1', '1', '1', 1, 1, 'https://playerwish.com/e/c7rh1jbbg551', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (3, 'DUAL', '', '1080p', 0, 3, 'https://playerwish.com/e/07x34mse8ape', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (6, 'TR DUPLAJ', '', '1080p', 1, 4, 'https://playerwish.com/e/0qxkj0wwjfhs', 'Streamwish', 1, 1, '00:00:00', '00:03:40', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (9, 'dual', '', '1080p', 1, 2, 'https://playerwish.com/e/lrb2ca2jyzmf', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (10, 'TR', '', '1080p', 1, 5, 'https://playerwish.com/e/opze261vimf5', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (11, 'XBET', '', '', 0, 6, 'https://ok.ru/videoembed/7389588949753', 'OKru', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (12, 'TR DUPLAJ', '', '1080P', 1, 7, 'https://sg2.rovideo.buzz/v/d/tt8041270/tr/1080.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (15, 'TR', '', '4k', 1, 9, 'https://www.youtube.com/watch?v=jGsxSs2cp4U', 'Youtube', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (16, 'DUAL', '', '', 1, 10, 'https://playerwish.com/e/rwetmp0ymeyr', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (17, 'DUAL', '', '', 1, 11, 'https://playerwish.com/e/a5kke4uqkvj8', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (18, 'DUAL', '', '', 0, 12, 'https://playerwish.com/e/v811zepgx6yx', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (19, 'DUAL', '', '1080p', 1, 13, 'https://playerwish.com/e/dmm72kqx1vvl', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (20, '', '', '', 0, 14, 'https://playerwish.com/e/c7rh1jbbg551', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (21, 'TR DUPLAJ', '', '', 1, 15, 'https://uzunmuhalefet.serv00.net/nowtv.php?serie=Mutlu-Aile-Tablosu&episode=1&.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (22, 'TR DUPLAJ', '', '', 1, 16, 'https://uzunmuhalefet.serv00.net/nowtv.php?serie=Yalanci-Sevgilim&episode=1&.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (23, 'Dual', '', '', 0, 17, 'https://playerwish.com/e/q30xzo1kbdgi', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (24, 'Dual', '', '', 1, 18, 'https://playerwish.com/e/hpizm797pz7e', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (25, 'DUAL', '', '', 1, 19, 'https://playerwish.com/f/e82j83hgjfch', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (26, 'DUAL', '', '', 1, 20, 'https://playerwish.com/e/ozgqegmpdfrx', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (27, 'DUAL', '', '', 0, 21, 'https://p2.photofunny.org/v/f7hg5eaybcqy/1080.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (28, 'Dizipro', '', '', 1, 22, 'https://playerwish.com/e/fwkr4w75jlfw', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (29, '', '', '', 0, 23, 'https://playerwish.com/e/gb6013c0h2w6', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (30, 'DUAL', '', '', 1, 24, 'https://playerwish.com/e/mlk0tpuks71r', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (32, 'DUAL', '', '', 0, 26, 'https://playerwish.com/e/nrkdp5xpwp7m', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (33, 'DUAL', '', '', 0, 27, 'https://playerwish.com/e/st4q6vebxudc', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (34, 'DUAL', '', '', 0, 29, 'https://playerwish.com/e/ilqvj3hcfhv7', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (35, 'DUAL', '', '', 0, 30, 'https://playerwish.com/e/6n48k1xkknrl', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (36, 'DUAL', '', '', 0, 31, 'https://playerwish.com/i07w4hfd1qwh', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (38, 'TR DUPLAJ', '', '', 2, 6, 'https://playerwish.com/e/st4q6vebxudc', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (40, 'DUAL', '', '', 0, 34, 'https://playerwish.com/e/tmebc21pvsr6', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (41, 'DUAL', '', '', 0, 35, 'https://playerwish.com/e/lha4sdyvp1yt', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (42, 'DUAL', '', '', 0, 36, 'https://playerwish.com/e/ee0leqaecj3a', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (43, 'DUAL', '', '', 0, 37, 'https://playerwish.com/e/eydvimdwk61t', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (44, 'DUAL', '', '', 0, 38, 'https://playerwish.com/e/n5lahigsbidx', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (45, 'DUAL', '', '', 0, 39, 'https://playerwish.com/e/3062qxzeohtp', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (46, 'DUAL', '', '', 0, 40, 'https://playerwish.com/e/4af1ec9lny1d', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (47, 'TR DUPLAJ', '', '', 0, 41, 'https://playerwish.com/e/5vaej39x2iui', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (48, 'DUAL', '', '', 0, 42, 'https://playerwish.com/e/a5knw65wkmgw', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (49, 'DUAL', '', '', 0, 43, 'https://playerwish.com/e/f3zsbfcl68g1', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (50, 'DUAL', '', '', 0, 44, 'https://playerwish.com/e/ct12xe9anq9m', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (51, 'DUAL', '', '', 0, 45, 'https://playerwish.com/e/pjnsjmd9mjet', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (52, 'DUAL', '', '', 0, 46, 'https://playerwish.com/e/a5q2mhd2fi3h', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (53, 'DUAL', '', '', 0, 47, 'https://playerwish.com/e/77bfyveckfuk', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (54, 'DUAL', '', '', 0, 48, 'https://playerwish.com/e/ezh8ywz3d9in', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (55, 'DUAL', '', '', 0, 49, 'https://playerwish.com/e/spd988xjz0cz', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (56, 'Multiquality', '', '', 1, 50, 'https://vidtube.pro/d/p4z09cfj7tjk.html', 'vidtube', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (57, '', '', '', 0, 51, 'https://playerwish.com/e/vgjeb8tcljpl', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (58, '', '', '', 0, 52, 'https://playerwish.com/e/pdeb3af8bj7v', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (59, '', '', '', 0, 53, 'https://playerwish.com/e/tovm823qzowu', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (60, 'Dual', '', '', 0, 57, 'https://playerwish.com/e/wyx3uxzie1ye', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (61, '', '', '', 0, 58, 'https://playerwish.com/e/r4x1j9acakka', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (62, 'DUAl', '', '', 0, 59, 'https://playerwish.com/e/8jpxpdj6rkk1', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (63, 'Dual', '', '', 0, 62, 'https://playerwish.com/e/oxqbx64nbo43', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (64, '', '', '', 0, 63, 'https://ap.dizipro3.gen.tr/HarryPotterveFelsefeTa%C5%9F%C4%B1.mp4', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (65, '', '', '', 0, 64, 'https://ap.dizipro3.gen.tr/HarryPotterveMelezPrens.mp4', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (66, '', '', '', 0, 65, 'https://cdn554.acrossvis.pw/3707/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (67, '', '', '', 0, 66, 'https://cdn789.becamevis.pw/3701/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (68, '', '', '', 0, 67, 'https://cdn789.becamevis.pw/2174/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (69, '', '', '', 0, 68, 'https://cdn776.acropolisvis.pw/2881/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (70, '', '', '', 0, 69, 'https://cdn765.blindingvis.pw/1764/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (72, '', '', '', 0, 71, 'https://ok.ru/videoembed/8031551228586', 'OKru', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (73, '', '', '', 0, 72, 'https://ap.dizipro3.gen.tr/Shazam%21%20Fury%20of%20the%20Gods.mp4', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (74, 'TR', '', '', 0, 73, 'https://cdn789.becamevis.pw/3633/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (75, 'TR', '', '', 0, 74, 'https://cdn776.acropolisvis.pw/875/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (76, 'TR', '', '', 0, 74, 'https://cdn776.acropolisvis.pw/875/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (77, 'Dual', '', '', 0, 75, 'https://hlswish.com/djqy7i4q057t', 'Streamwish', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (78, '', '', '', 0, 76, 'https://hlswish.com/m7qgxubqptc3', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (79, 'TR', '', '', 0, 77, 'https://cdn767.carcassvis.pw/175/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (80, 'TR', '', '', 0, 78, 'https://ok.ru/videoembed/32860277500', 'OKru', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (81, '', '', '', 0, 79, 'https://cdn767.carcassvis.pw/3662/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (82, '', '', '', 0, 80, 'https://cdn767.carcassvis.pw/817/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (83, '', '', '', 0, 81, 'https://cdn765.blindingvis.pw/280/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (84, '', '', '', 0, 83, 'https://cdn789.becamevis.pw/740/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (85, '', '', '', 0, 84, 'https://cdn789.becamevis.pw/1121/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (87, '', '', '', 0, 87, 'https://cdn767.carcassvis.pw/1125/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (89, '', '', '', 0, 85, 'https://cdn554.acrossvis.pw/1123/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (90, '', '', '', 0, 88, 'https://y1.5dk.org/storage/media/36a573a42657a49ade01531024321dde-720.mp4/gomindex.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (91, '', '', '', 0, 89, 'https://cdn765.blindingvis.pw/1533/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (92, '', '', '', 0, 90, 'https://cdn554.acrossvis.pw/1535/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (93, '', '', '', 0, 91, 'https://cdn767.carcassvis.pw/1537/1080p.m3u8', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (94, '', '', '', 0, 92, 'https://cdn776.acropolisvis.pw/1538/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (95, '', '', '', 0, 93, 'https://cdn776.acropolisvis.pw/1539/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (96, '', '', '', 0, 94, 'https://cdn767.carcassvis.pw/1540/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (97, '', '', '', 0, 95, 'https://cdn789.becamevis.pw/1542/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (98, '', '', '', 0, 96, 'https://cdn767.carcassvis.pw/1544/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (99, '', '', '', 0, 97, 'https://cdn789.becamevis.pw/1546/1080p.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (100, '', '', '', 0, 98, 'https://sv1.rovideo.buzz/v/d/tt1979320/tr/1080.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (101, '', '', '', 0, 99, 'https://rovideo.xyz/008/tt0085333.1080p.tr.m3u8', 'Mp4', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (102, '', '', '', 0, 100, 'https://ok.ru/videoembed/37536271095', 'OKru', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (103, '', '', '', 0, 101, 'https://sv2.rovideo.buzz/v/d/tt7634968/tr/1080.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');
INSERT INTO `movie_play_links` (`id`, `name`, `size`, `quality`, `link_order`, `movie_id`, `url`, `type`, `status`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `link_type`, `drm_uuid`, `drm_license_uri`) VALUES (104, '', '', '', 0, 102, 'https://rovideo.xyz/503/tt5034838.2160p.tr.m3u8', 'M3u8', 1, 0, '', '', '0', 0, '', '');


#
# TABLE STRUCTURE FOR: movies
#

DROP TABLE IF EXISTS `movies`;

CREATE TABLE `movies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `TMDB_ID` int(11) NOT NULL,
  `name` text NOT NULL,
  `description` longtext NOT NULL,
  `genres` mediumtext NOT NULL,
  `release_date` mediumtext NOT NULL,
  `runtime` mediumtext NOT NULL,
  `poster` mediumtext NOT NULL,
  `banner` mediumtext NOT NULL,
  `youtube_trailer` mediumtext NOT NULL,
  `downloadable` int(11) NOT NULL COMMENT '0=Not Downloadable, 1=Downloadable',
  `type` int(11) NOT NULL COMMENT '0=NotPremium, 1=Premium',
  `status` int(11) NOT NULL COMMENT '0=UnPublished, 1=Published',
  `content_type` int(11) NOT NULL DEFAULT 1 COMMENT '1=Movie, 2=WebSeries',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (1, 1160018, 'Kill', 'When an army commando finds out his true love is engaged against her will, he boards a New Dehli-bound train in a daring quest to derail the arranged marriage. But when a gang of knife-wielding thieves begin to terrorize innocent passengers on his train, the commando takes them on himself in a death-defying kill-spree to save those around him â€” turning what should have been a typical commute into an adrenaline-fueled thrill ride.When an army commando finds out his true love is engaged against her will, he boards a New Dehli-bound train in a daring quest to derail the arranged marriage. But when a gang of knife-wielding thieves begin to terrorize innocent passengers on his train, the commando takes them on himself in a death-defying kill-spree to save those around him â€” turning what should have been a typical commute into an adrenaline-fueled thrill ride.', 'Action,Crime', '2024-07-03', '105min', 'https://image.tmdb.org//t/p/original/m2zXTuNPkywdYLyWlVyJZW2QOJH.jpg', 'https://image.tmdb.org//t/p/original/okVLmXL5y18dfN2R4ufMZEGaeCd.jpg', 'https://www.youtube.com/watch?v=cVyNeDYu9Kk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (2, 1281826, 'HÄ±z PeÅŸinde', '<font style=\"vertical-align: inherit;\"><font style=\"vertical-align: inherit;\">Ordudan ihraÃ§ edilen bir asker SuperSport motosiklet yarÄ±ÅŸlarÄ±na katÄ±lma hayalini gerÃ§ekleÅŸtirmesine yardÄ±m etmesi iÃ§in kendisinden uzaklaÅŸmÄ±ÅŸ olan kardeÅŸleri peÅŸinde dÃ¼ÅŸer.</font></font>', 'Aksiyon,Dram,Romantik', '2024-08-07', '107 dk', 'https://image.tmdb.org//t/p/original/2bhvtlcX8VNgHahBpkSEZ6Kwisp.jpg', 'https://image.tmdb.org//t/p/original/QflfyU07MiQXSqTUCmG9Xfq0Ws.jpg', 'https://www.youtube.com/watch?v=vGpbT392Itg', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (3, 748783, 'Garfield', 'Garfield\'Ä±n uzun sÃ¼redir kayÄ±p olan babasÄ± sokak kedisi Vic ile beklenmedik bir buluÅŸma, Garfield ve sadÄ±k kÃ¶pek arkadaÅŸÄ± Odie\'yi kusursuz ve ÅŸÄ±martÄ±lmÄ±ÅŸ hayatlarÄ±ndan uzaklaÅŸtÄ±rÄ±r. Bu olaÄŸanÃ¼stÃ¼ kesiÅŸme, ikiliyi Vic\'in iÃ§inde bulunduÄŸu komik ve yÃ¼ksek riskli bir soygun planÄ±na sÃ¼rÃ¼kler. Garfield ve Odie, alÄ±ÅŸtÄ±klarÄ± konfor bÃ¶lgesinden Ã§Ä±karak, Vic\'in renkli ve tehlikeli dÃ¼nyasÄ±na adÄ±m atmak zorunda kalÄ±r.Garfield\'Ä±n uzun sÃ¼redir kayÄ±p olan babasÄ± sokak kedisi Vic ile beklenmedik bir buluÅŸma, Garfield ve sadÄ±k kÃ¶pek arkadaÅŸÄ± Odie\'yi kusursuz ve ÅŸÄ±martÄ±lmÄ±ÅŸ hayatlarÄ±ndan uzaklaÅŸtÄ±rÄ±r. Bu olaÄŸanÃ¼stÃ¼ kesiÅŸme, ikiliyi Vic\'in iÃ§inde bulunduÄŸu komik ve yÃ¼ksek riskli bir soygun planÄ±na sÃ¼rÃ¼kler. Garfield ve Odie, alÄ±ÅŸtÄ±klarÄ± konfor bÃ¶lgesinden Ã§Ä±karak, Vic\'in renkli ve tehlikeli dÃ¼nyasÄ±na adÄ±m atmak zorunda kalÄ±r.', 'Aksiyon,Animasyon,Komedi,Aile,Macera', '2024-04-30', '101min', 'https://image.tmdb.org//t/p/original/sf6i8gcZX69q7W3ErgJjAXucsSN.jpg', 'https://image.tmdb.org//t/p/original/1wP1phHo2CROOqzv7Azs0MT5esU.jpg', 'https://www.youtube.com/watch?v=IeFWNtMo1Fs', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (4, 1037402, 'Mahalleden ArkadaÅŸlar', '90â€™lÄ± yÄ±llarda geÃ§en nostalji dolu sÄ±cak bir aile filmi olan Mahalleden ArkadaÅŸlar, kÃ¼Ã§Ã¼k bir mahallede yaÅŸayan SelÃ§uk adÄ±ndaki bir Ã§ocuÄŸun hayatÄ±na odaklanÄ±yor. Ä°dolÃ¼ olarak gÃ¶rdÃ¼ÄŸÃ¼ Ä°smetâ€™in gÃ¶zÃ¼ne girip, Ã§etesine katÄ±lmak isteyen SelÃ§uk, bu amaÃ§la yakÄ±n arkadaÅŸlarÄ±yla birlikte bir Ã§ete kurar. Mahallenin altÄ±nÄ± Ã¼stÃ¼ne getiren SelÃ§uk ve arkadaÅŸlarÄ± bu sÃ¼reÃ§te kendilerini tÃ¼rlÃ¼ maceralarÄ±n iÃ§inde bulur.90â€™lÄ± yÄ±llarda geÃ§en nostalji dolu sÄ±cak bir aile filmi olan Mahalleden ArkadaÅŸlar, kÃ¼Ã§Ã¼k bir mahallede yaÅŸayan SelÃ§uk adÄ±ndaki bir Ã§ocuÄŸun hayatÄ±na odaklanÄ±yor. Ä°dolÃ¼ olarak gÃ¶rdÃ¼ÄŸÃ¼ Ä°smetâ€™in gÃ¶zÃ¼ne girip, Ã§etesine katÄ±lmak isteyen SelÃ§uk, bu amaÃ§la yakÄ±n arkadaÅŸlarÄ±yla birlikte bir Ã§ete kurar. Mahallenin altÄ±nÄ± Ã¼stÃ¼ne getiren SelÃ§uk ve arkadaÅŸlarÄ± bu sÃ¼reÃ§te kendilerini tÃ¼rlÃ¼ maceralarÄ±n iÃ§inde bulur.', 'Komedi', '2022-11-04', '91min', 'https://image.tmdb.org//t/p/original/s0ZUf0PCUphLCVgVYK96FQNp9fP.jpg', 'https://image.tmdb.org//t/p/original/5Bo73Do2Yb6Y3nAMdtz1Int8fWf.jpg', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (5, 1184606, 'AtatÃ¼rk 1881 - 1919', 'TÃ¼rkiye Cumhuriyeti\'nin kurucusu ve ilk CumhurbaÅŸkanÄ±, 20. yÃ¼zyÄ±lÄ±n Ã¶nemli isimlerinden Mustafa Kemal AtatÃ¼rk\'Ã¼n hayat hikayesi. Ä°ki bÃ¶lÃ¼m olarak izleyiciyle buluÅŸan AtatÃ¼rk filminin ilk kÄ±smÄ±nda, Mustafa Kemal\'in Ã§ocukluk yÄ±llarÄ±ndan MillÃ® MÃ¼cadele\'ye giden hikÃ¢yesi anlatÄ±lÄ±yor.TÃ¼rkiye Cumhuriyeti\'nin kurucusu ve ilk CumhurbaÅŸkanÄ±, 20. yÃ¼zyÄ±lÄ±n Ã¶nemli isimlerinden Mustafa Kemal AtatÃ¼rk\'Ã¼n hayat hikayesi. Ä°ki bÃ¶lÃ¼m olarak izleyiciyle buluÅŸan AtatÃ¼rk filminin ilk kÄ±smÄ±nda, Mustafa Kemal\'in Ã§ocukluk yÄ±llarÄ±ndan MillÃ® MÃ¼cadele\'ye giden hikÃ¢yesi anlatÄ±lÄ±yor.', 'Dram,Tarih,SavaÅŸ', '2023-11-03', '132min', 'https://image.tmdb.org//t/p/original/k6hXQwMaFMdqdqfutl2JWsg9yZk.jpg', 'https://image.tmdb.org//t/p/original/sgsquhBJlASgtb7RCrXbvafotYr.jpg', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (6, 533535, 'Deadpool & Wolverine', 'Wade Wilsonâ€™un ahlaki aÃ§Ä±dan esnek bir paralÄ± asker olarak geÃ§irdiÄŸi gÃ¼nler ve Deadpool kimliÄŸi Ã§ok gerilerde kalmÄ±ÅŸ, artÄ±k sadece sivil hayatta varlÄ±k gÃ¶stermeye Ã§abalamaktadÄ±r. Ancak  sakin dÃ¼nyasÄ± bÃ¼yÃ¼k bir tehlike tehdidiyle karÅŸÄ± karÅŸÄ±ya kalÄ±nca Wade isteksizce harekete geÃ§mek zorunda kalÄ±r. Bu sorun karÅŸÄ±sÄ±nda, en az kendisi kadar isteksiz birini, Wolverineâ€™i yardÄ±m etmesi iÃ§in ikna etmeye Ã§alÄ±ÅŸÄ±r.Wade Wilsonâ€™un ahlaki aÃ§Ä±dan esnek bir paralÄ± asker olarak geÃ§irdiÄŸi gÃ¼nler ve Deadpool kimliÄŸi Ã§ok gerilerde kalmÄ±ÅŸ, artÄ±k sadece sivil hayatta varlÄ±k gÃ¶stermeye Ã§abalamaktadÄ±r. Ancak  sakin dÃ¼nyasÄ± bÃ¼yÃ¼k bir tehlike tehdidiyle karÅŸÄ± karÅŸÄ±ya kalÄ±nca Wade isteksizce harekete geÃ§mek zorunda kalÄ±r. Bu sorun karÅŸÄ±sÄ±nda, en az kendisi kadar isteksiz birini, Wolverineâ€™i yardÄ±m etmesi iÃ§in ikna etmeye Ã§alÄ±ÅŸÄ±r.', 'Aksiyon,Komedi,Aksiyon & Macera,Bilim-Kurgu', '2024-07-24', '128min', 'https://image.tmdb.org//t/p/original/fVr2X3jnoeLuZ2v0L1O8MOdOiSz.jpg', 'https://image.tmdb.org//t/p/original/yDHYTfA3R0jFYba16jBB1ef8oIt.jpg', 'https://www.youtube.com/watch?v=73_1biulkYk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (7, 0, 'Jurassic World: HÃ¢kimiyet', 'Dominion, Nublarâ€™Ä±n yok edilmesinin dÃ¶rt yÄ±l sonrasÄ±nda geÃ§iyor. Dinozorlar artÄ±k tÃ¼m dÃ¼nyada insanlarla birlikte yaÅŸÄ±yor ve avlanÄ±yor. Bu hassas denge, geleceÄŸi yeniden ÅŸekillendirecek ve insanlarÄ±n artÄ±k tarihin en korkunÃ§ yaratÄ±klarÄ±yla paylaÅŸtÄ±klarÄ± gezegeni uÃ§ yÄ±rtÄ±cÄ±lara bÄ±rakÄ±p bÄ±rakmayacaklarÄ±nÄ± belirleyecek.', 'Aksiyon,Macera,Aksiyon & Macera,Bilim-Kurgu', '2022-06-01', '147min', 'https://image.tmdb.org//t/p/original/x6tTeF2cSwinSXBLqRwy7Byiqy1.jpg', 'https://image.tmdb.org//t/p/original/698FjyzLdpgXmUSr63LaRwblTmx.jpg', 'https://www.youtube.com/watch?v=UtxAPXT4174', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (9, 364394, 'Hayalet DayÄ±', 'BaÅŸlarÄ±nÄ± sokacak bir ev arayan Ozan ve Caner uzun ve zorlu arayÄ±ÅŸlarÄ± sonucunda tam da istedikleri gibi bir ev bulurlar. OlaÄŸanÃ¼stÃ¼ bir fiyata bulduklarÄ± ev aslÄ±nda gerÃ§ekten de olaÄŸanÃ¼stÃ¼ Ã§Ä±kÄ±nca eÄŸlenceli olaylar peÅŸlerini bÄ±rakmaz. TuttuklarÄ± eski konaÄŸÄ±n vefat eden ev sahibi maalesef arafta kalmÄ±ÅŸtÄ±r ve onu sadece Caner ile Ozan gÃ¶rebilmektedir. Bu yaÅŸlÄ± ruhun Ã¶teki tarafa huzurla geÃ§mesine yardÄ±m etmek artÄ±k bu iki gencin gÃ¶revidir. Evde rahat bir nefes alabilmek iÃ§in baÅŸladÄ±klarÄ± bu gÃ¶rev onlarÄ± Ã§ok komik ve bir o kadar duygusal olaylarÄ±n iÃ§ine sÃ¼rÃ¼kler.BaÅŸlarÄ±nÄ± sokacak bir ev arayan Ozan ve Caner uzun ve zorlu arayÄ±ÅŸlarÄ± sonucunda tam da istedikleri gibi bir ev bulurlar. OlaÄŸanÃ¼stÃ¼ bir fiyata bulduklarÄ± ev aslÄ±nda gerÃ§ekten de olaÄŸanÃ¼stÃ¼ Ã§Ä±kÄ±nca eÄŸlenceli olaylar peÅŸlerini bÄ±rakmaz. TuttuklarÄ± eski konaÄŸÄ±n vefat eden ev sahibi maalesef arafta kalmÄ±ÅŸtÄ±r ve onu sadece Caner ile Ozan gÃ¶rebilmektedir. Bu yaÅŸlÄ± ruhun Ã¶teki tarafa huzurla geÃ§mesine yardÄ±m etmek artÄ±k bu iki gencin gÃ¶revidir. Evde rahat bir nefes alabilmek iÃ§in baÅŸladÄ±klarÄ± bu gÃ¶rev onlarÄ± Ã§ok komik ve bir o kadar duygusal olaylarÄ±n iÃ§ine sÃ¼rÃ¼kler.', '', '2015-05-29', '98min', 'https://image.tmdb.org//t/p/original/4N4srJb0gA6bhmDuP2jYJY7IzLk.jpg', 'https://image.tmdb.org//t/p/original/yDweA3PYT3EuZ26aFsuPpxtdC4y.jpg', 'https://www.youtube.com/watch?v=qf26CrNWr_E', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (10, 38700, 'Bad Boys: Her Zaman Ã‡Ä±lgÄ±n', 'Miami polis departmanÄ±nda birer efsane olarak nam salmÄ±ÅŸ dedektif Marcus Burnett daha sakin bir hayat iÃ§in emeklilik yolunda ilerlerken dedektif Mike Lowery orta yaÅŸ kriziyle boÄŸuÅŸmaktadÄ±r. Eskinin hÄ±zlÄ± ve hareketli gÃ¼nleri bir parÃ§a sakinleÅŸmiÅŸtir. Ta ki, geÃ§miÅŸten gelen bir intikam onlarÄ± arayÄ±p bulana kadar!Miami polis departmanÄ±nda birer efsane olarak nam salmÄ±ÅŸ dedektif Marcus Burnett daha sakin bir hayat iÃ§in emeklilik yolunda ilerlerken dedektif Mike Lowery orta yaÅŸ kriziyle boÄŸuÅŸmaktadÄ±r. Eskinin hÄ±zlÄ± ve hareketli gÃ¼nleri bir parÃ§a sakinleÅŸmiÅŸtir. Ta ki, geÃ§miÅŸten gelen bir intikam onlarÄ± arayÄ±p bulana kadar!', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2020-01-15', '123min', 'https://image.tmdb.org//t/p/original/zJ5y3Uv7H3IHQvnU77O4RI4u0ME.jpg', 'https://image.tmdb.org//t/p/original/3N316jUSdhvPyYTW29G4v9ebbcS.jpg', 'https://www.youtube.com/watch?v=jKCj3XuPG8M', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (11, 9737, 'Ã‡Ä±lgÄ±n Ä°kili', 'Marcus Burnett ve Mike Lowrey, Miami polis teÅŸkilatÄ±nda narkotik biriminde Ã§alÄ±ÅŸan iki dedektiftir. Marcus ailesine Ã§ok baÄŸlÄ± ve emekliliÄŸin bir an Ã¶nce gelmesini isteyen, tehlikeyi hiÃ§ sevmeyen bir dedektiftir. Mike ise oldukÃ§a Ã§apkÄ±n, tehlikeyi seven ve ayrÄ±ca ailesinden ona miras kalan para ile rahat bir hayat sÃ¼ren bir dedektiftir. Fakat bir gece Ã§ok ustaca bir planla 100 milyon dolarlÄ±k el konulan eroin polis deposundan Ã§alÄ±nÄ±r. Ä°kilinin araÅŸtÄ±rmalarÄ± sÄ±rasÄ±nda bir polis tanÄ±ÄŸÄ± Ã¶ldÃ¼rÃ¼lÃ¼r. Katiller tek gÃ¶rgÃ¼ tanÄ±ÄŸÄ±nÄ± ise kaÃ§Ä±rÄ±r. Ä°ki ortaÄŸÄ±n gÃ¶rgÃ¼ tanÄ±ÄŸÄ±nÄ± kurtarmalarÄ± ve narkotik biriminin kapatÄ±lmamasÄ± iÃ§in Ã§alÄ±nan uyuÅŸturucularÄ± 72 saat iÃ§inde geri almalarÄ± gerekmektedir.Marcus Burnett ve Mike Lowrey, Miami polis teÅŸkilatÄ±nda narkotik biriminde Ã§alÄ±ÅŸan iki dedektiftir. Marcus ailesine Ã§ok baÄŸlÄ± ve emekliliÄŸin bir an Ã¶nce gelmesini isteyen, tehlikeyi hiÃ§ sevmeyen bir dedektiftir. Mike ise oldukÃ§a Ã§apkÄ±n, tehlikeyi seven ve ayrÄ±ca ailesinden ona miras kalan para ile rahat bir hayat sÃ¼ren bir dedektiftir. Fakat bir gece Ã§ok ustaca bir planla 100 milyon dolarlÄ±k el konulan eroin polis deposundan Ã§alÄ±nÄ±r. Ä°kilinin araÅŸtÄ±rmalarÄ± sÄ±rasÄ±nda bir polis tanÄ±ÄŸÄ± Ã¶ldÃ¼rÃ¼lÃ¼r. Katiller tek gÃ¶rgÃ¼ tanÄ±ÄŸÄ±nÄ± ise kaÃ§Ä±rÄ±r. Ä°ki ortaÄŸÄ±n gÃ¶rgÃ¼ tanÄ±ÄŸÄ±nÄ± kurtarmalarÄ± ve narkotik biriminin kapatÄ±lmamasÄ± iÃ§in Ã§alÄ±nan uyuÅŸturucularÄ± 72 saat iÃ§inde geri almalarÄ± gerekmektedir.', 'Aksiyon,Komedi,Aksiyon & Macera,SuÃ§,Gerilim', '1995-04-07', '119min', 'https://image.tmdb.org//t/p/original/jDWJ706mKN3QtB0pMH8ZBWD7LU7.jpg', 'https://image.tmdb.org//t/p/original/r4TxCaZvQ2bLFoXRLHGfii6b3tJ.jpg', 'https://www.youtube.com/watch?v=jqBLf1EjAPE', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (12, 8961, 'Ã‡Ä±lgÄ±n Ä°kili 2', 'Narkotik dedektifleri Mike Lowrey ve Marcus Burnett, Miamiâ€™deki uyuÅŸturucu trafiÄŸini araÅŸtÄ±rmak Ã¼zere gÃ¶revlendirilirler. Ä°kilinin araÅŸtÄ±rmasÄ± onlarÄ± ÅŸehrin uyuÅŸturucu trafiÄŸini kontrol etmek isteyen ve bu nedenle kanlÄ± bir Ã§ete savaÅŸÄ± baÅŸlatan Johnny Tapiaâ€™ya gÃ¶tÃ¼rÃ¼r. Bu arada Mikeâ€™Ä±n, Marcusâ€™un kÄ±z kardeÅŸi Sydâ€™e ilgi duymaya baÅŸlamasÄ±, bu ikilinin arkadaÅŸlÄ±ÄŸÄ±nÄ± ve iÅŸ iliÅŸkilerini tehdit etmeye baÅŸlar. EÄŸer Ã¶zel hayatlarÄ±yla profesyonel hayatlarÄ±nÄ± birbirinden ayÄ±ramazlarsa hem Ã¼zerinde Ã§alÄ±ÅŸtÄ±klarÄ± davayÄ± hem de Sydâ€™in hayatÄ±nÄ± tehlikeye atacaklardÄ±r.Narkotik dedektifleri Mike Lowrey ve Marcus Burnett, Miamiâ€™deki uyuÅŸturucu trafiÄŸini araÅŸtÄ±rmak Ã¼zere gÃ¶revlendirilirler. Ä°kilinin araÅŸtÄ±rmasÄ± onlarÄ± ÅŸehrin uyuÅŸturucu trafiÄŸini kontrol etmek isteyen ve bu nedenle kanlÄ± bir Ã§ete savaÅŸÄ± baÅŸlatan Johnny Tapiaâ€™ya gÃ¶tÃ¼rÃ¼r. Bu arada Mikeâ€™Ä±n, Marcusâ€™un kÄ±z kardeÅŸi Sydâ€™e ilgi duymaya baÅŸlamasÄ±, bu ikilinin arkadaÅŸlÄ±ÄŸÄ±nÄ± ve iÅŸ iliÅŸkilerini tehdit etmeye baÅŸlar. EÄŸer Ã¶zel hayatlarÄ±yla profesyonel hayatlarÄ±nÄ± birbirinden ayÄ±ramazlarsa hem Ã¼zerinde Ã§alÄ±ÅŸtÄ±klarÄ± davayÄ± hem de Sydâ€™in hayatÄ±nÄ± tehlikeye atacaklardÄ±r.', 'Aksiyon,Komedi,Aksiyon & Macera,SuÃ§', '2003-07-18', '147min', 'https://image.tmdb.org//t/p/original/vowKequv08ONN3n38RzAu8FhlfR.jpg', 'https://image.tmdb.org//t/p/original/gxSVZCUlDd8upT1G2wdrUdz2hxG.jpg', 'https://www.youtube.com/watch?v=g6vcdR30W1A', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (13, 1139817, 'ë¬´ë„ì‹¤ë¬´ê´€', '', 'Aksiyon,Komedi,Aksiyon & Macera,SuÃ§', '2024-09-12', '108min', 'https://image.tmdb.org//t/p/original/iuwUEZYNOHzhoNoRj6mcXd2xbYr.jpg', 'https://image.tmdb.org//t/p/original/wSZbtiFIK1fkKZdSRtn2kz2Ttfd.jpg', 'https://www.youtube.com/watch?v=WNkGz6aKFvk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (14, 80982, 'Ata Demirer: Tek KiÅŸilik Dev Kadro', 'Ata Demirer, gÃ¼nlÃ¼k hayata dair izlenimlerini, Ã¼nlÃ¼ sanatÃ§Ä±lardan Ã§eÅŸitli meslek erbaplarÄ±na kadar farklÄ± kiÅŸilerin Ã¶zgÃ¼n tiplemelerini, karakter komedisi ile canlandÄ±rarak anlattÄ±ÄŸÄ± gÃ¶sterisini keyifle izleyeceksiniz.Ata Demirer, gÃ¼nlÃ¼k hayata dair izlenimlerini, Ã¼nlÃ¼ sanatÃ§Ä±lardan Ã§eÅŸitli meslek erbaplarÄ±na kadar farklÄ± kiÅŸilerin Ã¶zgÃ¼n tiplemelerini, karakter komedisi ile canlandÄ±rarak anlattÄ±ÄŸÄ± gÃ¶sterisini keyifle izleyeceksiniz.', 'Komedi', '2005-04-11', '104min', 'https://image.tmdb.org//t/p/original/1IMguYUe3VYBFTYO45jvYieHEzQ.jpg', 'https://image.tmdb.org//t/p/original/gXzPLF5n4UM8j5kwStY92yI71Hb.jpg', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (15, 923741, 'Mutlu Aile Tablosu', 'HiÃ§bir iÅŸte tutunamayan RÄ±fatâ€™Ä±n onu sabÄ±rla bekleyen Nalanâ€™la kavuÅŸmasÄ±, bir anda ortaya Ã§Ä±kan mirasla daha da Ã§Ä±kmaza girer. SÃ¼rpriz miras sayesinde nihayet mutlu bir aile tablosu oluÅŸturabileceklerini dÃ¼ÅŸÃ¼nen RÄ±fat ve Nalan, mirasÄ±n ne olduÄŸunu Ã¶ÄŸrendiklerinde artÄ±k geri dÃ¶nÃ¼ÅŸÃ¼ olmayan bir maceraya gireceklerdir.HiÃ§bir iÅŸte tutunamayan RÄ±fatâ€™Ä±n onu sabÄ±rla bekleyen Nalanâ€™la kavuÅŸmasÄ±, bir anda ortaya Ã§Ä±kan mirasla daha da Ã§Ä±kmaza girer. SÃ¼rpriz miras sayesinde nihayet mutlu bir aile tablosu oluÅŸturabileceklerini dÃ¼ÅŸÃ¼nen RÄ±fat ve Nalan, mirasÄ±n ne olduÄŸunu Ã¶ÄŸrendiklerinde artÄ±k geri dÃ¶nÃ¼ÅŸÃ¼ olmayan bir maceraya gireceklerdir.', 'Komedi,Aile', '2022-01-05', '0min', 'https://image.tmdb.org//t/p/original/cuzlSwZFD82UgFfZPUevXt5nWPO.jpg', 'https://image.tmdb.org//t/p/original/hI4wTiuwx6JkhrV6GU6WUdqKZyK.jpg', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (16, 922295, 'YalancÄ± Sevgilim', 'Sami Akyanak (Salih GÃ¼ney) yetmiÅŸleri devirmiÅŸ eski bir YeÅŸilÃ§am oyuncusudur. Uzun sÃ¼redir kendisine iÅŸ teklifleri gelmemesinden dolayÄ± unutulduÄŸunu dÃ¼ÅŸÃ¼nmeye baÅŸlar ve iÃ§ine kapanarak, adeta kendisini eve hapseder. Bu durum karÅŸÄ±sÄ±nda mahallemizin cici kÄ±zÄ± Belgin (Arbil Tabur) bir gÃ¼n Sami beyin kapÄ±sÄ±nÄ± Ã§alar ve evleneceÄŸi haberini verir fakat damat tarafÄ±na varlÄ±klÄ± bir ailenin kÄ±zÄ± olduÄŸu yalanÄ±nÄ± sÃ¶ylediÄŸini, kimsesi olmadÄ±ÄŸÄ±ndan dolayÄ± istemeye geldiklerinde varlÄ±klÄ± dedesini onun oynamasÄ±nÄ± rica eder. Ã–nceleri Sami bey, bu teklife ÅŸiddetle karÅŸÄ± Ã§Ä±kar ama kÄ±zÄ± gibi sevdiÄŸi Belginâ€™in Ä±srarlarÄ±na daha fazla dayanamaz. ArtÄ±k Belginâ€™in oyunu baÅŸlamÄ±ÅŸtÄ±r. SÄ±ra Sami beyin tanÄ±madÄ±ÄŸÄ± bir damat adayÄ± ve bir kÃ¶ÅŸk bulmaya gelmiÅŸtir.Sami Akyanak (Salih GÃ¼ney) yetmiÅŸleri devirmiÅŸ eski bir YeÅŸilÃ§am oyuncusudur. Uzun sÃ¼redir kendisine iÅŸ teklifleri gelmemesinden dolayÄ± unutulduÄŸunu dÃ¼ÅŸÃ¼nmeye baÅŸlar ve iÃ§ine kapanarak, adeta kendisini eve hapseder. Bu durum karÅŸÄ±sÄ±nda mahallemizin cici kÄ±zÄ± Belgin (Arbil Tabur) bir gÃ¼n Sami beyin kapÄ±sÄ±nÄ± Ã§alar ve evleneceÄŸi haberini verir fakat damat tarafÄ±na varlÄ±klÄ± bir ailenin kÄ±zÄ± olduÄŸu yalanÄ±nÄ± sÃ¶ylediÄŸini, kimsesi olmadÄ±ÄŸÄ±ndan dolayÄ± istemeye geldiklerinde varlÄ±klÄ± dedesini onun oynamasÄ±nÄ± rica eder. Ã–nceleri Sami bey, bu teklife ÅŸiddetle karÅŸÄ± Ã§Ä±kar ama kÄ±zÄ± gibi sevdiÄŸi Belginâ€™in Ä±srarlarÄ±na daha fazla dayanamaz. ArtÄ±k Belginâ€™in oyunu baÅŸlamÄ±ÅŸtÄ±r. SÄ±ra Sami beyin tanÄ±madÄ±ÄŸÄ± bir damat adayÄ± ve bir kÃ¶ÅŸk bulmaya gelmiÅŸtir.', 'Romantik,Komedi', '2021-12-30', '135min', 'https://image.tmdb.org//t/p/original/vPUJWKMlAi56q2B5En60R7wQKdN.jpg', 'https://image.tmdb.org//t/p/original', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (17, 702936, 'Keskin NiÅŸancÄ±: SuikastÃ§Ä±nÄ±n Sonu', 'Efsanevi keskin niÅŸancÄ± Thomas Beckett ve oÄŸlu Ã–zel Ops Sniper Brandon Beckett; CIA, Rus ParalÄ± Askerleri ve efsanevi keskin atÄ±cÄ±lara rakip olan becerileri sahip, ayrÄ±ca yakuza tarafÄ±ndan eÄŸitilmiÅŸ bir suikastÃ§Ä±dan kaÃ§Ä±yorlar.Efsanevi keskin niÅŸancÄ± Thomas Beckett ve oÄŸlu Ã–zel Ops Sniper Brandon Beckett; CIA, Rus ParalÄ± Askerleri ve efsanevi keskin atÄ±cÄ±lara rakip olan becerileri sahip, ayrÄ±ca yakuza tarafÄ±ndan eÄŸitilmiÅŸ bir suikastÃ§Ä±dan kaÃ§Ä±yorlar.', 'Aksiyon,Aksiyon & Macera', '2020-06-15', '90min', 'https://image.tmdb.org//t/p/original/8ZVEYQEF10GKaWqW35wIiBNVums.jpg', 'https://image.tmdb.org//t/p/original/fvSY1KXxu9oJZvtfoTmJFjFWJgw.jpg', 'https://www.youtube.com/watch?v=Ub9EikTkrTk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (18, 58767, 'Keskin NiÅŸancÄ±: Ã–lÃ¼mcÃ¼l Hedef', 'Afrika Ã¼lkelerinden Kongo\'da isyancÄ±lara karÅŸÄ± Kongo askerlerini; BM Ã§atÄ±sÄ± altÄ±nda eÄŸiten bir grup deniz piyadesine Jean Van Brunt adÄ±nda BelÃ§ikalÄ± Ã§iftlik sahibini; sÄ±nÄ±rÄ±n olaylÄ± tarafÄ±ndan Ã§Ä±karÄ±p getirmeleri istenir. Bu denizcilerden biri Thomas Beckett\'in oÄŸlu Ã‡avuÅŸ Beckettir. GÃ¶rev sÄ±rasÄ±nda keskin niÅŸancÄ± saldÄ±rÄ±sÄ±na uÄŸrayan ekipten yalnÄ±zca Ã‡avuÅŸ Becket kurtulur. Becket keskin niÅŸancÄ±yÄ± bulup arkadaÅŸlarÄ±nÄ±n intikamÄ±nÄ± almak iÃ§in harekete geÃ§er.Afrika Ã¼lkelerinden Kongo\'da isyancÄ±lara karÅŸÄ± Kongo askerlerini; BM Ã§atÄ±sÄ± altÄ±nda eÄŸiten bir grup deniz piyadesine Jean Van Brunt adÄ±nda BelÃ§ikalÄ± Ã§iftlik sahibini; sÄ±nÄ±rÄ±n olaylÄ± tarafÄ±ndan Ã§Ä±karÄ±p getirmeleri istenir. Bu denizcilerden biri Thomas Beckett\'in oÄŸlu Ã‡avuÅŸ Beckettir. GÃ¶rev sÄ±rasÄ±nda keskin niÅŸancÄ± saldÄ±rÄ±sÄ±na uÄŸrayan ekipten yalnÄ±zca Ã‡avuÅŸ Becket kurtulur. Becket keskin niÅŸancÄ±yÄ± bulup arkadaÅŸlarÄ±nÄ±n intikamÄ±nÄ± almak iÃ§in harekete geÃ§er.', 'Aksiyon,Dram,SavaÅŸ,Aksiyon & Macera,Gerilim', '2011-04-26', '91min', 'https://image.tmdb.org//t/p/original/iIuPquao5cMq6ZgG1zyoeOfJs3H.jpg', 'https://image.tmdb.org//t/p/original/7AE2LdB4QTVY6R2nTromUWQFx7n.jpg', 'https://www.youtube.com/watch?v=b47y89OUTrw', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (19, 464889, 'Keskin NiÅŸancÄ± 7', 'Aksiyon sahnelerinin Ã¶n planda olduÄŸu yapÄ±mda, KolombiyalÄ± uyuÅŸturucu satÄ±cÄ±sÄ± Jesus Morales ve Åžeytan lakaplÄ± keskin niÅŸancÄ±nÄ±n tehlikeli ortaklÄ±ÄŸÄ±nÄ± izliyoruz.Aksiyon sahnelerinin Ã¶n planda olduÄŸu yapÄ±mda, KolombiyalÄ± uyuÅŸturucu satÄ±cÄ±sÄ± Jesus Morales ve Åžeytan lakaplÄ± keskin niÅŸancÄ±nÄ±n tehlikeli ortaklÄ±ÄŸÄ±nÄ± izliyoruz.', 'Aksiyon,Aksiyon & Macera', '2017-10-03', '93min', 'https://image.tmdb.org//t/p/original/pi16aubY3qFKJWAh4npvm03ERkH.jpg', 'https://image.tmdb.org//t/p/original/yD4FojKumGSeA0Z8m49VZ8GKUuJ.jpg', 'https://www.youtube.com/watch?v=ZKBlKsx4N38', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (20, 1217192, 'Arap Kadri', 'Film, Ã¼nlÃ¼ mizah dergisi GÄ±rgÄ±r\'Ä±n usta karikatÃ¼ristlerinden Tekin Aral\'Ä±n yarattÄ±ÄŸÄ± Arap Kadri ve Tarzan karakterlerinin hikÃ¢yesini anlatÄ±yor. Arap Kadriâ€™nin en Ã¶nemli Ã¶zelliÄŸi Ã¶zgÃ¼rlÃ¼ÄŸÃ¼ne son derece dÃ¼ÅŸkÃ¼n olmasÄ±dÄ±r. Ormanda yaÅŸar, pek kural tanÄ±maz. Arap Kadri, ormana gelince de dÃ¼zenli yaÅŸamaya Ã§alÄ±ÅŸan canlÄ±larÄ± gÃ¶rÃ¼nce, bu dÃ¼zene Ã§omak sokar. Tarzan ile aralarÄ±ndaki Ã§atÄ±ÅŸmanÄ±n en temel sebebi de buradan kaynaklanÄ±r.Film, Ã¼nlÃ¼ mizah dergisi GÄ±rgÄ±r\'Ä±n usta karikatÃ¼ristlerinden Tekin Aral\'Ä±n yarattÄ±ÄŸÄ± Arap Kadri ve Tarzan karakterlerinin hikÃ¢yesini anlatÄ±yor. Arap Kadriâ€™nin en Ã¶nemli Ã¶zelliÄŸi Ã¶zgÃ¼rlÃ¼ÄŸÃ¼ne son derece dÃ¼ÅŸkÃ¼n olmasÄ±dÄ±r. Ormanda yaÅŸar, pek kural tanÄ±maz. Arap Kadri, ormana gelince de dÃ¼zenli yaÅŸamaya Ã§alÄ±ÅŸan canlÄ±larÄ± gÃ¶rÃ¼nce, bu dÃ¼zene Ã§omak sokar. Tarzan ile aralarÄ±ndaki Ã§atÄ±ÅŸmanÄ±n en temel sebebi de buradan kaynaklanÄ±r.', 'Komedi,Macera,Aksiyon & Macera', '2024-04-19', '105min', 'https://image.tmdb.org//t/p/original/4JnfCypNLU2zQFWqp96elodAA20.jpg', 'https://image.tmdb.org//t/p/original/h0tUL2cfraSIw1jkqegTEZmnm62.jpg', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (21, 77338, 'Can Dostum', 'Zengin bir iÅŸ adamÄ± ve aristokrat olan Philippe, yamaÃ§ paraÅŸÃ¼tÃ¼ yaparken geÃ§irdiÄŸi kaza sonrasÄ± felÃ§ olur ve boynundan aÅŸaÄŸÄ±sÄ±nÄ± kullanamaz hale gelir. Driss ise hapishaneden henÃ¼z yeni Ã§Ä±kmÄ±ÅŸ bir iÅŸsizdir. Philippe 7 gÃ¼n 24 saat boyunca bakÄ±mÄ±nÄ± Ã¼stlenmesi iÃ§in Driss\'i evine yatÄ±lÄ± yardÄ±mcÄ± olarak alÄ±nca ikisinin de dÃ¼nyasÄ± deÄŸiÅŸecektir. Normal ÅŸartlar altÄ±nda hiÃ§bir zaman yan yana gelmeyecek bu ikili iyisiyle kÃ¶tÃ¼sÃ¼yle hayatÄ±n tadÄ±nÄ± beraber Ã§Ä±karmaya baÅŸlarlar.Zengin bir iÅŸ adamÄ± ve aristokrat olan Philippe, yamaÃ§ paraÅŸÃ¼tÃ¼ yaparken geÃ§irdiÄŸi kaza sonrasÄ± felÃ§ olur ve boynundan aÅŸaÄŸÄ±sÄ±nÄ± kullanamaz hale gelir. Driss ise hapishaneden henÃ¼z yeni Ã§Ä±kmÄ±ÅŸ bir iÅŸsizdir. Philippe 7 gÃ¼n 24 saat boyunca bakÄ±mÄ±nÄ± Ã¼stlenmesi iÃ§in Driss\'i evine yatÄ±lÄ± yardÄ±mcÄ± olarak alÄ±nca ikisinin de dÃ¼nyasÄ± deÄŸiÅŸecektir. Normal ÅŸartlar altÄ±nda hiÃ§bir zaman yan yana gelmeyecek bu ikili iyisiyle kÃ¶tÃ¼sÃ¼yle hayatÄ±n tadÄ±nÄ± beraber Ã§Ä±karmaya baÅŸlarlar.', 'Dram,Komedi', '2011-11-02', '112min', 'https://image.tmdb.org//t/p/original/tiyHlhIS4Tm6HK8XdwRZX4cc4tS.jpg', 'https://image.tmdb.org//t/p/original/bGksau9GGu0uJ8DJQ8DYc9JW5LM.jpg', 'https://www.youtube.com/watch?v=dvdJ--DV0Uo', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (22, 781696, 'Ata Demirer Gazinosu', 'Ata Demirerâ€™in Gazinosuâ€™nda, Demirer hem stand-up yapÄ±yor hem â€˜tek kiÅŸilik gazinoâ€™ oluyor! BaÅŸarÄ±lÄ± komedyen, TÃ¼rk Sanat MÃ¼ziÄŸiâ€™nden operaya, halk mÃ¼ziÄŸinden popa ve arabeske kadar geniÅŸ bir repertuara sahip. Demirerâ€™e sahnede TaÅŸkÄ±n Sabah yÃ¶netiminde bir orkestra ve zaman zaman dansÃ§Ä±lar eÅŸlik ediyor. Seyircinin hasretle beklediÄŸi mizah dolu hikayeler de ÅŸarkÄ± aralarÄ±nda sahnede yerini alÄ±yor. Ata Demirer kendine has Ã¼slubuyla bir yandan ÅŸakalarÄ±yla seyirciye kahkahalar attÄ±rÄ±yor, bir yandan da ÅŸarkÄ±larÄ±yla, tiyatro sahnesine hoÅŸ bir seda getiriyor.Ata Demirerâ€™in Gazinosuâ€™nda, Demirer hem stand-up yapÄ±yor hem â€˜tek kiÅŸilik gazinoâ€™ oluyor! BaÅŸarÄ±lÄ± komedyen, TÃ¼rk Sanat MÃ¼ziÄŸiâ€™nden operaya, halk mÃ¼ziÄŸinden popa ve arabeske kadar geniÅŸ bir repertuara sahip. Demirerâ€™e sahnede TaÅŸkÄ±n Sabah yÃ¶netiminde bir orkestra ve zaman zaman dansÃ§Ä±lar eÅŸlik ediyor. Seyircinin hasretle beklediÄŸi mizah dolu hikayeler de ÅŸarkÄ± aralarÄ±nda sahnede yerini alÄ±yor. Ata Demirer kendine has Ã¼slubuyla bir yandan ÅŸakalarÄ±yla seyirciye kahkahalar attÄ±rÄ±yor, bir yandan da ÅŸarkÄ±larÄ±yla, tiyatro sahnesine hoÅŸ bir seda getiriyor.', 'Komedi,MÃ¼zik', '2020-12-31', '131min', 'https://image.tmdb.org//t/p/original/jsWrAyr7Hd8kNBmIEusNmqTOMrm.jpg', 'https://image.tmdb.org//t/p/original/8V8k1zAyY4HN9HC0tNHmnC0sPEl.jpg', '', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (23, 998846, 'Back to Black', 'Camden\'deki ilk gÃ¼nlerinden dÃ¼nya Ã§apÄ±nda ÅŸÃ¶hrete ulaÅŸtÄ±ÄŸÄ± Back to Black albÃ¼mÃ¼ne kadar Amy Winehouse\'un yÃ¼kseliÅŸi anlatÄ±lÄ±yor. Amy\'nin gÃ¶zÃ¼nden, kiÅŸisel ÅŸarkÄ± sÃ¶zlerinden esinlenerek yapÄ±lan film, sanatÃ§Ä±nÄ±n katmanlÄ± hayatÄ±nÄ± ve efsanevi albÃ¼mÃ¼n merkezindeki fÄ±rtÄ±nalÄ± aÅŸk hikayesini keÅŸfediyor.Camden\'deki ilk gÃ¼nlerinden dÃ¼nya Ã§apÄ±nda ÅŸÃ¶hrete ulaÅŸtÄ±ÄŸÄ± Back to Black albÃ¼mÃ¼ne kadar Amy Winehouse\'un yÃ¼kseliÅŸi anlatÄ±lÄ±yor. Amy\'nin gÃ¶zÃ¼nden, kiÅŸisel ÅŸarkÄ± sÃ¶zlerinden esinlenerek yapÄ±lan film, sanatÃ§Ä±nÄ±n katmanlÄ± hayatÄ±nÄ± ve efsanevi albÃ¼mÃ¼n merkezindeki fÄ±rtÄ±nalÄ± aÅŸk hikayesini keÅŸfediyor.', 'Dram,Tarih,MÃ¼zik', '2024-04-11', '122min', 'https://image.tmdb.org//t/p/original/xHQEeUT3Ac4fTY72UeNrI75xLtE.jpg', 'https://image.tmdb.org//t/p/original/a1m4DAmySexNaaGnjEVA2MKNUCo.jpg', 'https://www.youtube.com/watch?v=HwxM2l9pHOY', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (24, 8966, 'AlacakaranlÄ±k', '17 yaÅŸÄ±ndaki Isabella, babasÄ± Charlie ile birlikte yaÅŸamak Ã¼zere kÃ¼Ã§Ã¼k bir kasaba olan Forksâ€™a taÅŸÄ±nÄ±r. Burada 108 yaÅŸÄ±nda bir vampir olup, 17 yaÅŸÄ±nda gÃ¶rÃ¼nen sÄ±nÄ±f arkadaÅŸÄ± Edward ile tanÄ±ÅŸÄ±r. Edwardâ€™Ä±n romantizmden uzak durmaya Ã§alÄ±ÅŸmasÄ±na raÄŸmen birbirlerine aÅŸÄ±k olurlar. Kasabaya Ã¼Ã§ gÃ¶Ã§ebe vampir geldiÄŸinde Edwardâ€™Ä±n ailesi, hayatÄ± tehlikeye giren Isaellaâ€™yÄ± kurtarmak iÃ§in Ã§alÄ±ÅŸÄ±rlar.17 yaÅŸÄ±ndaki Isabella, babasÄ± Charlie ile birlikte yaÅŸamak Ã¼zere kÃ¼Ã§Ã¼k bir kasaba olan Forksâ€™a taÅŸÄ±nÄ±r. Burada 108 yaÅŸÄ±nda bir vampir olup, 17 yaÅŸÄ±nda gÃ¶rÃ¼nen sÄ±nÄ±f arkadaÅŸÄ± Edward ile tanÄ±ÅŸÄ±r. Edwardâ€™Ä±n romantizmden uzak durmaya Ã§alÄ±ÅŸmasÄ±na raÄŸmen birbirlerine aÅŸÄ±k olurlar. Kasabaya Ã¼Ã§ gÃ¶Ã§ebe vampir geldiÄŸinde Edwardâ€™Ä±n ailesi, hayatÄ± tehlikeye giren Isaellaâ€™yÄ± kurtarmak iÃ§in Ã§alÄ±ÅŸÄ±rlar.', 'Dram,Romantik,Fantastik', '2008-11-20', '121min', 'https://image.tmdb.org//t/p/original/daNvGuP0Vwl3RQl5xILSGwrTHv9.jpg', 'https://image.tmdb.org//t/p/original/7eK8FJr4fqq3J5W2xvlr2GVaep2.jpg', 'https://www.youtube.com/watch?v=7tQk8pKnnVY', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (26, 447200, 'GÃ¶kdelen', 'Will Sawyer, eski bir FBI Rehine Kurtarma Ekibi lideridir. Fakat artÄ±k gÃ¶kdelenlerin gÃ¼venliÄŸini deÄŸerlendirmektedir. Ã‡inâ€™deki gÃ¶revi sÄ±rasÄ±nda dÃ¼nyanÄ±n en uzun ve en gÃ¼venli binasÄ± ateÅŸler iÃ§inde kalÄ±nca tÃ¼m suÃ§ onun Ã¼zerine atÄ±lÄ±r. Bu olay Ã¼zerine artÄ±k aranan bir adam olan Will, yangÄ±nÄ±n sorumlularÄ±nÄ± bularak adÄ±nÄ± temizlemeli ve binanÄ±n iÃ§inde sÄ±kÄ±ÅŸÄ±p kalmÄ±ÅŸ olan ailesini ateÅŸ hattÄ±ndan kurtarmalÄ±dÄ±r.Will Sawyer, eski bir FBI Rehine Kurtarma Ekibi lideridir. Fakat artÄ±k gÃ¶kdelenlerin gÃ¼venliÄŸini deÄŸerlendirmektedir. Ã‡inâ€™deki gÃ¶revi sÄ±rasÄ±nda dÃ¼nyanÄ±n en uzun ve en gÃ¼venli binasÄ± ateÅŸler iÃ§inde kalÄ±nca tÃ¼m suÃ§ onun Ã¼zerine atÄ±lÄ±r. Bu olay Ã¼zerine artÄ±k aranan bir adam olan Will, yangÄ±nÄ±n sorumlularÄ±nÄ± bularak adÄ±nÄ± temizlemeli ve binanÄ±n iÃ§inde sÄ±kÄ±ÅŸÄ±p kalmÄ±ÅŸ olan ailesini ateÅŸ hattÄ±ndan kurtarmalÄ±dÄ±r.', 'Aksiyon,Macera,Aksiyon & Macera,Gerilim', '2018-07-11', '102min', 'https://image.tmdb.org//t/p/original/AvVi4VgZoDRQZcExSTWWasIEUVI.jpg', 'https://image.tmdb.org//t/p/original/pfzC0MVhIiyRMRukp1jSMDYSzJW.jpg', 'https://www.youtube.com/watch?v=t9QePUT-Yt8', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (27, 634649, 'Ã–rÃ¼mcek-Adam: Eve DÃ¶nÃ¼ÅŸ Yok', 'Ã–rÃ¼mcek Adam\'Ä±n sinema tarihinde ilk kez, dost canlÄ±sÄ± mahalle kahramanÄ±mÄ±z maskesizdir ve artÄ±k normal hayatÄ±yla sÃ¼per kahraman olmanÄ±n yÃ¼ksek risklerini birbirinden ayÄ±ramÄ±yordur. Doctor Strange\'den yardÄ±m istediÄŸinde, riskler daha da tehlikeli hale gelir ve onu Ã–rÃ¼mcek Adam olmanÄ±n gerÃ§ekte ne anlama geldiÄŸini keÅŸfetmeye zorlar.Ã–rÃ¼mcek Adam\'Ä±n sinema tarihinde ilk kez, dost canlÄ±sÄ± mahalle kahramanÄ±mÄ±z maskesizdir ve artÄ±k normal hayatÄ±yla sÃ¼per kahraman olmanÄ±n yÃ¼ksek risklerini birbirinden ayÄ±ramÄ±yordur. Doctor Strange\'den yardÄ±m istediÄŸinde, riskler daha da tehlikeli hale gelir ve onu Ã–rÃ¼mcek Adam olmanÄ±n gerÃ§ekte ne anlama geldiÄŸini keÅŸfetmeye zorlar.', 'Aksiyon,Macera,Aksiyon & Macera,Bilim-Kurgu', '2021-12-15', '148min', 'https://image.tmdb.org//t/p/original/armAY3JkCDVZKaV4djNWcUdFndD.jpg', 'https://image.tmdb.org//t/p/original/zD5v1E4joAzFvmAEytt7fM3ivyT.jpg', 'https://www.youtube.com/watch?v=WgU7P6o-GkM', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (28, 974262, 'Yeni Nesil: KÄ±zÄ±l\'Ä±n YÃ¼kseliÅŸi', 'Kupa KraliÃ§esi Auradon\'da bir darbe baÅŸlattÄ±ktan sonra asi kÄ±zÄ± KÄ±zÄ±l ve KÃ¼lkedisi\'nin mÃ¼kemmeliyetÃ§i kÄ±zÄ± Chloe gÃ¼Ã§lerini birleÅŸtirir ve KÄ±zÄ±l\'Ä±n annesini kÃ¶tÃ¼ yola sokan travmatik olayÄ± geri almaya Ã§alÄ±ÅŸmak iÃ§in zamanda geriye giderler.Kupa KraliÃ§esi Auradon\'da bir darbe baÅŸlattÄ±ktan sonra asi kÄ±zÄ± KÄ±zÄ±l ve KÃ¼lkedisi\'nin mÃ¼kemmeliyetÃ§i kÄ±zÄ± Chloe gÃ¼Ã§lerini birleÅŸtirir ve KÄ±zÄ±l\'Ä±n annesini kÃ¶tÃ¼ yola sokan travmatik olayÄ± geri almaya Ã§alÄ±ÅŸmak iÃ§in zamanda geriye giderler.', 'Komedi,Aile,Macera,Aksiyon & Macera,Fantastik', '2024-07-11', '92min', 'https://image.tmdb.org//t/p/original/1pUnVz4E17F6DPKcOQ9VQfkUYel.jpg', 'https://image.tmdb.org//t/p/original/dn3gbDpXPSwC6saMJOHkCiFA9jn.jpg', 'https://www.youtube.com/watch?v=1cHDHsmXjxM', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (29, 9799, 'HÄ±zlÄ± ve Ã–fkeli', 'Los Angeles sokaklarÄ±nda geceleri yasa dÄ±ÅŸÄ± yarÄ±ÅŸlara katÄ±lan Dominic Toretto, bir dizi soygunun ÅŸÃ¼phelisidir. Polis teÅŸkilatÄ±nÄ±n baÅŸarÄ±lÄ± polislerinden Brian O\'Conner da Toretto\'yu yakalamak iÃ§in onun sokak yarÄ±ÅŸÄ± Ã§etesine katÄ±lÄ±r. Ancak zamanla Ã§ete Ã¼yeleri ile samimi hale gelirken diÄŸer yandan Toretto\'nun kÄ±z kardeÅŸine aÅŸÄ±k olur. ArtÄ±k Los Angeles polis memuru Brian O\'Conner sadakatinin kime olduÄŸuna karar vermelidir.Los Angeles sokaklarÄ±nda geceleri yasa dÄ±ÅŸÄ± yarÄ±ÅŸlara katÄ±lan Dominic Toretto, bir dizi soygunun ÅŸÃ¼phelisidir. Polis teÅŸkilatÄ±nÄ±n baÅŸarÄ±lÄ± polislerinden Brian O\'Conner da Toretto\'yu yakalamak iÃ§in onun sokak yarÄ±ÅŸÄ± Ã§etesine katÄ±lÄ±r. Ancak zamanla Ã§ete Ã¼yeleri ile samimi hale gelirken diÄŸer yandan Toretto\'nun kÄ±z kardeÅŸine aÅŸÄ±k olur. ArtÄ±k Los Angeles polis memuru Brian O\'Conner sadakatinin kime olduÄŸuna karar vermelidir.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2001-06-22', '106min', 'https://image.tmdb.org//t/p/original/zA9pwvMF3oebsypZkDVHBmlzxwf.jpg', 'https://image.tmdb.org//t/p/original/jY9ef5nqY4xIIMu3yzW3qamUCoi.jpg', 'https://www.youtube.com/watch?v=ZsJz2TJAPjw', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (30, 584, 'Daha HÄ±zlÄ± Daha Ã–fkeli', 'Emekliye ayrÄ±lan Brian Oâ€™Connor, kendisini baÅŸtan Ã§Ä±karan sokak yarÄ±ÅŸlarÄ± ve yeraltÄ± dÃ¼nyasÄ±nÄ±n kirli iÅŸlerine bulaÅŸmadan duramaz. Eski dostu Roman Pearce ile birlikte takÄ±m kuran Oâ€™Connor, kirli para naklini gerÃ§ekleÅŸtirme operasyonu ile Miamiâ€™li tÃ¼ccar Carter Veroneâ€™u yakalamanÄ±n peÅŸindedir. Bu sÄ±rada el altÄ±ndan Ã§alÄ±ÅŸan casus Monica Fuentes ile iÅŸbirliÄŸi yapar.Emekliye ayrÄ±lan Brian Oâ€™Connor, kendisini baÅŸtan Ã§Ä±karan sokak yarÄ±ÅŸlarÄ± ve yeraltÄ± dÃ¼nyasÄ±nÄ±n kirli iÅŸlerine bulaÅŸmadan duramaz. Eski dostu Roman Pearce ile birlikte takÄ±m kuran Oâ€™Connor, kirli para naklini gerÃ§ekleÅŸtirme operasyonu ile Miamiâ€™li tÃ¼ccar Carter Veroneâ€™u yakalamanÄ±n peÅŸindedir. Bu sÄ±rada el altÄ±ndan Ã§alÄ±ÅŸan casus Monica Fuentes ile iÅŸbirliÄŸi yapar.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2003-06-05', '108min', 'https://image.tmdb.org//t/p/original/y2lQw2jAEFTVVvxMHQPbmRAJ2pP.jpg', 'https://image.tmdb.org//t/p/original/xWf5Mjtv2HfIB9FyPYbbaSDdfCW.jpg', 'https://www.youtube.com/watch?v=sWofeRh_53g', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (31, 9615, 'HÄ±zlÄ± ve Ã–fkeli 3: Tokyo YarÄ±ÅŸÄ±', 'Sean Boswell, yaÅŸadÄ±ÄŸÄ± topluma yabancÄ±laÅŸmÄ±ÅŸ bir sokak yarÄ±ÅŸÃ§Ä±sÄ±dÄ±r. YarÄ±ÅŸlara katÄ±lmak, Sean iÃ§in mutsuz ev ortamÄ±ndan geÃ§ici kaÃ§Ä±ÅŸ saÄŸlar ve Ã§evresinde yapay bir dÃ¼nya oluÅŸturur. YakÄ±nlarÄ±, onu Tokyoâ€™da yaÅŸayan babasÄ±nÄ±n yanÄ±na gÃ¶nderirler. ArkadaÅŸÄ± Twinkie sayesinde aradÄ±ÄŸÄ± heyecan ve aksiyonu bulmasÄ± uzun sÃ¼rmeyecektir.Sean Boswell, yaÅŸadÄ±ÄŸÄ± topluma yabancÄ±laÅŸmÄ±ÅŸ bir sokak yarÄ±ÅŸÃ§Ä±sÄ±dÄ±r. YarÄ±ÅŸlara katÄ±lmak, Sean iÃ§in mutsuz ev ortamÄ±ndan geÃ§ici kaÃ§Ä±ÅŸ saÄŸlar ve Ã§evresinde yapay bir dÃ¼nya oluÅŸturur. YakÄ±nlarÄ±, onu Tokyoâ€™da yaÅŸayan babasÄ±nÄ±n yanÄ±na gÃ¶nderirler. ArkadaÅŸÄ± Twinkie sayesinde aradÄ±ÄŸÄ± heyecan ve aksiyonu bulmasÄ± uzun sÃ¼rmeyecektir.', 'Aksiyon,Dram,Aksiyon & Macera,SuÃ§,Gerilim', '2006-06-03', '104min', 'https://image.tmdb.org//t/p/original/8BzPXKmWXXKB34LC4Sh5pSMBqiL.jpg', 'https://image.tmdb.org//t/p/original/dMARcKLrv0T7kVJ4iQR3vqTTdtT.jpg', 'https://www.youtube.com/watch?v=p8HQ2JLlc4E', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (34, 8920, 'Garfield', 'Garfieldâ€™Ä±n sahibi Jon, eve ikinci bir evcil hayvan almaya karar vererek, sevimli fakat aptal Odieâ€™yi getirir. Garfieldâ€™Ä±n sakin dÃ¼nyasÄ±nÄ± kabusa Ã§eviren Odieâ€™yle arasÄ±nda ciddi bir rekabet baÅŸlar. Bir gÃ¼n Odie, kÃ¶tÃ¼ niyetli kÃ¶pek eÄŸitimcisi tarafÄ±ndan kaÃ§Ä±rÄ±lÄ±nca, Garfield ilk defa sorumluluk duygusuyla tanÄ±ÅŸarak yeni dostunu kurtarmak iÃ§in kollarÄ± sÄ±var.Garfieldâ€™Ä±n sahibi Jon, eve ikinci bir evcil hayvan almaya karar vererek, sevimli fakat aptal Odieâ€™yi getirir. Garfieldâ€™Ä±n sakin dÃ¼nyasÄ±nÄ± kabusa Ã§eviren Odieâ€™yle arasÄ±nda ciddi bir rekabet baÅŸlar. Bir gÃ¼n Odie, kÃ¶tÃ¼ niyetli kÃ¶pek eÄŸitimcisi tarafÄ±ndan kaÃ§Ä±rÄ±lÄ±nca, Garfield ilk defa sorumluluk duygusuyla tanÄ±ÅŸarak yeni dostunu kurtarmak iÃ§in kollarÄ± sÄ±var.', 'Animasyon,Komedi,Aile', '2004-06-10', '80min', 'https://image.tmdb.org//t/p/original/vqwTSWNLyH55g8kBT61s2DgNYEp.jpg', 'https://image.tmdb.org//t/p/original/6SSEa1OfqrHGg7XTLNTxbyyioRB.jpg', 'https://www.youtube.com/watch?v=5g1SLGRM6qU', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (35, 9513, 'Garfield 2', 'Tembel ve obur kedimiz Garfield, bu kez de, sahibi Jon Arbuckle\'la Londra yollarÄ±nda. Jon, sevgilisi Liz Wilson\'a sÃ¼priz evlenme teklifinde bulunmak iÃ§in yanÄ±na Garfield\'i de alarak Londra\'ya gider. Fakat sevimli kedimizi bu ÅŸehirde bÃ¼yÃ¼k sÃ¼prizler beklemektedir.Yeni Ã¶len sahibesi Lady Eleanor`dan miras aldÄ±ÄŸÄ± Carlyle Åžatosu\'nun sahibi olan ve tÄ±pkÄ± Garfield\'e benzeyen kraliyet kedisi Prens ile Garfield, bir yanlÄ±ÅŸlÄ±k sonucu yer deÄŸiÅŸtirirler. Bu yanlÄ±ÅŸlÄ±k Garfield\'e, lezzetli yemekleri, rahat yataklarÄ± ve bitmeyen bir konforu ifade ettiÄŸi iÃ§in ilk baÅŸlarda herÅŸey Ã§ok gÃ¼zeldir. Ama gelin gÃ¶rÃ¼n ki, gerÃ§ekte kraliyet kedisi olmak hiÃ§ de kolay ve rahat bir durum deÄŸildir. Garfield\'in bunu anlamasÄ± ise Ã§ok uzun sÃ¼rmeyecektir.Tembel ve obur kedimiz Garfield, bu kez de, sahibi Jon Arbuckle\'la Londra yollarÄ±nda. Jon, sevgilisi Liz Wilson\'a sÃ¼priz evlenme teklifinde bulunmak iÃ§in yanÄ±na Garfield\'i de alarak Londra\'ya gider. Fakat sevimli kedimizi bu ÅŸehirde bÃ¼yÃ¼k sÃ¼prizler beklemektedir.Yeni Ã¶len sahibesi Lady Eleanor`dan miras aldÄ±ÄŸÄ± Carlyle Åžatosu\'nun sahibi olan ve tÄ±pkÄ± Garfield\'e benzeyen kraliyet kedisi Prens ile Garfield, bir yanlÄ±ÅŸlÄ±k sonucu yer deÄŸiÅŸtirirler. Bu yanlÄ±ÅŸlÄ±k Garfield\'e, lezzetli yemekleri, rahat yataklarÄ± ve bitmeyen bir konforu ifade ettiÄŸi iÃ§in ilk baÅŸlarda herÅŸey Ã§ok gÃ¼zeldir. Ama gelin gÃ¶rÃ¼n ki, gerÃ§ekte kraliyet kedisi olmak hiÃ§ de kolay ve rahat bir durum deÄŸildir. Garfield\'in bunu anlamasÄ± ise Ã§ok uzun sÃ¼rmeyecektir.', 'Dram,Animasyon,Komedi,Aile,Macera,Aksiyon & Macera,Fantastik', '2006-06-15', '80min', 'https://image.tmdb.org//t/p/original/oZtHIjGfL3EHpW99wSIbbex13AJ.jpg', 'https://image.tmdb.org//t/p/original/lrUeu7XMNaKJn6v8ps0DHqUE11L.jpg', 'https://www.youtube.com/watch?v=BLTnQko_Lz4', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (36, 748783, 'Garfield 2024', 'Garfield\'Ä±n uzun sÃ¼redir kayÄ±p olan babasÄ± sokak kedisi Vic ile beklenmedik bir buluÅŸma, Garfield ve sadÄ±k kÃ¶pek arkadaÅŸÄ± Odie\'yi kusursuz ve ÅŸÄ±martÄ±lmÄ±ÅŸ hayatlarÄ±ndan uzaklaÅŸtÄ±rÄ±r. Bu olaÄŸanÃ¼stÃ¼ kesiÅŸme, ikiliyi Vic\'in iÃ§inde bulunduÄŸu komik ve yÃ¼ksek riskli bir soygun planÄ±na sÃ¼rÃ¼kler. Garfield ve Odie, alÄ±ÅŸtÄ±klarÄ± konfor bÃ¶lgesinden Ã§Ä±karak, Vic\'in renkli ve tehlikeli dÃ¼nyasÄ±na adÄ±m atmak zorunda kalÄ±r.Garfield\'Ä±n uzun sÃ¼redir kayÄ±p olan babasÄ± sokak kedisi Vic ile beklenmedik bir buluÅŸma, Garfield ve sadÄ±k kÃ¶pek arkadaÅŸÄ± Odie\'yi kusursuz ve ÅŸÄ±martÄ±lmÄ±ÅŸ hayatlarÄ±ndan uzaklaÅŸtÄ±rÄ±r. Bu olaÄŸanÃ¼stÃ¼ kesiÅŸme, ikiliyi Vic\'in iÃ§inde bulunduÄŸu komik ve yÃ¼ksek riskli bir soygun planÄ±na sÃ¼rÃ¼kler. Garfield ve Odie, alÄ±ÅŸtÄ±klarÄ± konfor bÃ¶lgesinden Ã§Ä±karak, Vic\'in renkli ve tehlikeli dÃ¼nyasÄ±na adÄ±m atmak zorunda kalÄ±r.', 'Aksiyon,Animasyon,Komedi,Aile,Macera,Aksiyon & Macera', '2024-04-30', '101min', 'https://image.tmdb.org//t/p/original/sf6i8gcZX69q7W3ErgJjAXucsSN.jpg', 'https://image.tmdb.org//t/p/original/1wP1phHo2CROOqzv7Azs0MT5esU.jpg', 'https://www.youtube.com/watch?v=IeFWNtMo1Fs', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (37, 13804, 'HÄ±zlÄ± ve Ã–fkeli 4', 'Eski dolandÄ±rÄ±cÄ± Domile ile ajan Brian arasÄ±ndaki eskilerden beri devam eden husumet yeniden alevlenir. Ancak ortak dÃ¼ÅŸmanlarÄ±yla mÃ¼cadele etmek zorunda kalÄ±nca ikisi arasÄ±nda yeni bir gÃ¼ven ortamÄ± oluÅŸmaya baÅŸlar. Birbirlerine ÅŸartsÄ±z ve kesinlikle gÃ¼venmek zorundadÄ±rlar. Omuz omuza zorlu mÃ¼cadeleye giriÅŸen iki erkek intikam almanÄ±n en iyi Ã§aresini bulmuÅŸtur: Araba direksiyonu baÅŸÄ±ndayken mÃ¼mkÃ¼n olan en yÃ¼ksek hÄ±z limitlerini zorlamak.Eski dolandÄ±rÄ±cÄ± Domile ile ajan Brian arasÄ±ndaki eskilerden beri devam eden husumet yeniden alevlenir. Ancak ortak dÃ¼ÅŸmanlarÄ±yla mÃ¼cadele etmek zorunda kalÄ±nca ikisi arasÄ±nda yeni bir gÃ¼ven ortamÄ± oluÅŸmaya baÅŸlar. Birbirlerine ÅŸartsÄ±z ve kesinlikle gÃ¼venmek zorundadÄ±rlar. Omuz omuza zorlu mÃ¼cadeleye giriÅŸen iki erkek intikam almanÄ±n en iyi Ã§aresini bulmuÅŸtur: Araba direksiyonu baÅŸÄ±ndayken mÃ¼mkÃ¼n olan en yÃ¼ksek hÄ±z limitlerini zorlamak.', 'Aksiyon,Dram,Aksiyon & Macera,SuÃ§,Gerilim', '2009-04-02', '107min', 'https://image.tmdb.org//t/p/original/wqUfhelSGhN5AWytxlOgMHxy9x.jpg', 'https://image.tmdb.org//t/p/original/acktCBsLJcgEJsjTuyiQhJipCD6.jpg', 'https://www.youtube.com/watch?v=7GNg6rAg4hg', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (38, 51497, 'HÄ±zlÄ± ve Ã–fkeli 5: Rio Soygunu', 'Eski polis Brian O\'Conner ve geÃ§miÅŸte, paÃ§asÄ±nÄ± kurtardÄ±ÄŸÄ± Dom Toretto, tamamen Ã¶zgÃ¼r olabilmek iÃ§in bir kez daha takÄ±m olurlar. Ancak Ã¶zgÃ¼rlÃ¼k kolay olmayacaktÄ±r, peÅŸlerinde onlarÄ± Ã¶lÃ¼ isteyen belalÄ± bir iÅŸ adamÄ± ve avÄ±nÄ± yakalamayÄ± amaÃ§ edinmiÅŸ Federal bir ajan vardÄ±r. Ä°kili Rio\'da sÄ±kÄ±ÅŸÄ±p kalmÄ±ÅŸken bir yandan da, yarÄ±ÅŸma iÃ§in, eÅŸsiz bir ekip toplamaktadÄ±r.Eski polis Brian O\'Conner ve geÃ§miÅŸte, paÃ§asÄ±nÄ± kurtardÄ±ÄŸÄ± Dom Toretto, tamamen Ã¶zgÃ¼r olabilmek iÃ§in bir kez daha takÄ±m olurlar. Ancak Ã¶zgÃ¼rlÃ¼k kolay olmayacaktÄ±r, peÅŸlerinde onlarÄ± Ã¶lÃ¼ isteyen belalÄ± bir iÅŸ adamÄ± ve avÄ±nÄ± yakalamayÄ± amaÃ§ edinmiÅŸ Federal bir ajan vardÄ±r. Ä°kili Rio\'da sÄ±kÄ±ÅŸÄ±p kalmÄ±ÅŸken bir yandan da, yarÄ±ÅŸma iÃ§in, eÅŸsiz bir ekip toplamaktadÄ±r.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2011-04-20', '130min', 'https://image.tmdb.org//t/p/original/oG4bxAtNP8ikDYkH5PoHdCE0muN.jpg', 'https://image.tmdb.org//t/p/original/lvSxooYCRuF3S2kHWXYTrcOtYco.jpg', 'https://www.youtube.com/watch?v=uSDNZeRX_1Y', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (39, 82992, 'HÄ±zlÄ± ve Ã–fkeli 6', 'Dom ve Brianâ€™Ä±n birlikte hareket ederek Ã§ok nÃ¼fuzlu bir kiÅŸinin imparatorluÄŸunu yÄ±ktÄ±klarÄ±ndan bu yana kahramanlarÄ±mÄ±z tÃ¼m dÃ¼nyaya yayÄ±lmÄ±ÅŸtÄ±r. Bu arada Hobbs dÃ¼zenlenen yepyeni bir organizasyonu takip etmektedir. SuÃ§lu takÄ±mÄ±nÄ± durdurmanÄ±n tek yolu sokakta Ã¼stÃ¼n gelmektir. Bu nedenle Hobbs, Domâ€™dan en seÃ§kin takÄ±mÄ±nÄ± Londraâ€™da toplamasÄ±nÄ± ister. BÃ¶ylece evlerine dÃ¶nebilecekler ve ailelerini yeniden bir araya getirebileceklerdir.Dom ve Brianâ€™Ä±n birlikte hareket ederek Ã§ok nÃ¼fuzlu bir kiÅŸinin imparatorluÄŸunu yÄ±ktÄ±klarÄ±ndan bu yana kahramanlarÄ±mÄ±z tÃ¼m dÃ¼nyaya yayÄ±lmÄ±ÅŸtÄ±r. Bu arada Hobbs dÃ¼zenlenen yepyeni bir organizasyonu takip etmektedir. SuÃ§lu takÄ±mÄ±nÄ± durdurmanÄ±n tek yolu sokakta Ã¼stÃ¼n gelmektir. Bu nedenle Hobbs, Domâ€™dan en seÃ§kin takÄ±mÄ±nÄ± Londraâ€™da toplamasÄ±nÄ± ister. BÃ¶ylece evlerine dÃ¶nebilecekler ve ailelerini yeniden bir araya getirebileceklerdir.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2013-05-21', '130min', 'https://image.tmdb.org//t/p/original/tnB3s33Hg8pFqeqJC7mLBaFvjyt.jpg', 'https://image.tmdb.org//t/p/original/mRfI3y2oAd7ejur2di09xC9niqp.jpg', 'https://www.youtube.com/watch?v=z7zl_t48CMc', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (40, 168259, 'HÄ±zlÄ± ve Ã–fkeli 7', 'HÄ±zlÄ± ve Ã–fkeli ekibi, intikam almak isteyen bir Ä°ngiliz gizli operasyonlar suikastÃ§Ä±sÄ±ndan gelen tehlikeden habersizdirler. KÃ¼Ã§Ã¼k kardeÅŸi Owenâ€™Ä± yaralayanlarÄ± sistematik olarak avlamakta olan Shaw, ekibe verilen Toretto evini havaya uÃ§urur. Bunun Ã¼zerine Dom, yardÄ±m iÃ§in Ã¼st dÃ¼zey bir devlet ajanÄ±na baÅŸvurur. KahramanlarÄ±mÄ±z bir kez daha direksiyona geÃ§er. ABD hÃ¼kÃ¼meti iÃ§in yapÄ±lmÄ±ÅŸ bir takip cihazÄ±nÄ±n ele geÃ§irilmesi gereklidir.HÄ±zlÄ± ve Ã–fkeli ekibi, intikam almak isteyen bir Ä°ngiliz gizli operasyonlar suikastÃ§Ä±sÄ±ndan gelen tehlikeden habersizdirler. KÃ¼Ã§Ã¼k kardeÅŸi Owenâ€™Ä± yaralayanlarÄ± sistematik olarak avlamakta olan Shaw, ekibe verilen Toretto evini havaya uÃ§urur. Bunun Ã¼zerine Dom, yardÄ±m iÃ§in Ã¼st dÃ¼zey bir devlet ajanÄ±na baÅŸvurur. KahramanlarÄ±mÄ±z bir kez daha direksiyona geÃ§er. ABD hÃ¼kÃ¼meti iÃ§in yapÄ±lmÄ±ÅŸ bir takip cihazÄ±nÄ±n ele geÃ§irilmesi gereklidir.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2015-04-01', '137min', 'https://image.tmdb.org//t/p/original/fvxAFADmcbYSMJ6GYqkHqcELczd.jpg', 'https://image.tmdb.org//t/p/original/cHkhb5A4gQRK6zs6Pv7zorHs8Nk.jpg', 'https://www.youtube.com/watch?v=Skpu5HaVkOc', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (41, 337339, 'HÄ±zlÄ± ve Ã–fkeli 8', 'Ekip artÄ±k sakinleÅŸmiÅŸtir ve suÃ§tan uzak bir hayat yaÅŸamak istemektedir. Dom ve Letty evlenip balayÄ±na giderlerken, Brian ile Mia da emekli olmaya karar vermiÅŸtir. Ancak gizemli bir kadÄ±n olan Chiper, Domâ€™u hedefine almÄ±ÅŸ durumdadÄ±r. Domâ€™u tekrar suÃ§a bulaÅŸmaya ikna eden Chiper, onu sevdiÄŸi ve gÃ¼vendiÄŸi insanlardan da ayÄ±racaktÄ±r. ArtÄ±k Domâ€™u durdurmanÄ±n tek yolu, ekibin geri kalanÄ±nÄ±n peÅŸlerine dÃ¼ÅŸmesidir.Ekip artÄ±k sakinleÅŸmiÅŸtir ve suÃ§tan uzak bir hayat yaÅŸamak istemektedir. Dom ve Letty evlenip balayÄ±na giderlerken, Brian ile Mia da emekli olmaya karar vermiÅŸtir. Ancak gizemli bir kadÄ±n olan Chiper, Domâ€™u hedefine almÄ±ÅŸ durumdadÄ±r. Domâ€™u tekrar suÃ§a bulaÅŸmaya ikna eden Chiper, onu sevdiÄŸi ve gÃ¼vendiÄŸi insanlardan da ayÄ±racaktÄ±r. ArtÄ±k Domâ€™u durdurmanÄ±n tek yolu, ekibin geri kalanÄ±nÄ±n peÅŸlerine dÃ¼ÅŸmesidir.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2017-04-12', '136min', 'https://image.tmdb.org//t/p/original/80v4HQwREdesIvnnpTfvoCXQJ4T.jpg', 'https://image.tmdb.org//t/p/original/jzdnhRhG0dsuYorwvSqPqqnM1cV.jpg', 'https://www.youtube.com/watch?v=JwMKRevYa_M', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (42, 385128, 'HÄ±zlÄ± ve Ã–fkeli 9', 'Dom Toretto, oÄŸlu kÃ¼Ã§Ã¼k Brian ile gÃ¶zlerden uzakta, sessiz bir hayat sÃ¼rmektedir. Ama huzurlu Ã§evrelerinin hemen Ã¶tesinde tehlikenin hep pusuda olduÄŸunu biliyorlardÄ±r. Bu kez tehlike Domâ€™u, en sevdiklerini kurtarmak istiyorsa geÃ§miÅŸinin gÃ¼nahlarÄ±yla yÃ¼zleÅŸmeye zorlayacaktÄ±r. Dom\'un ekibi, bugÃ¼ne kadar karÅŸÄ±laÅŸtÄ±klarÄ± en yetenekli suikastÃ§Ä± ve yÃ¼ksek performans sÃ¼rÃ¼cÃ¼sÃ¼ olan, Domâ€™un terk edilmiÅŸ erkek kardeÅŸi Jakobâ€™un liderliÄŸindeki dÃ¼nyayÄ± yÄ±kacak bir planÄ± durdurmak iÃ§in bir araya gelir.Dom Toretto, oÄŸlu kÃ¼Ã§Ã¼k Brian ile gÃ¶zlerden uzakta, sessiz bir hayat sÃ¼rmektedir. Ama huzurlu Ã§evrelerinin hemen Ã¶tesinde tehlikenin hep pusuda olduÄŸunu biliyorlardÄ±r. Bu kez tehlike Domâ€™u, en sevdiklerini kurtarmak istiyorsa geÃ§miÅŸinin gÃ¼nahlarÄ±yla yÃ¼zleÅŸmeye zorlayacaktÄ±r. Dom\'un ekibi, bugÃ¼ne kadar karÅŸÄ±laÅŸtÄ±klarÄ± en yetenekli suikastÃ§Ä± ve yÃ¼ksek performans sÃ¼rÃ¼cÃ¼sÃ¼ olan, Domâ€™un terk edilmiÅŸ erkek kardeÅŸi Jakobâ€™un liderliÄŸindeki dÃ¼nyayÄ± yÄ±kacak bir planÄ± durdurmak iÃ§in bir araya gelir.', 'Aksiyon,Macera,Aksiyon & Macera,SuÃ§', '2021-05-19', '143min', 'https://image.tmdb.org//t/p/original/1EoKu1Nu8oMFa4evDJtNBW3cDQ9.jpg', 'https://image.tmdb.org//t/p/original/xXHZeb1yhJvnSHPzZDqee0zfMb6.jpg', 'https://www.youtube.com/watch?v=aSiDu3Ywi8E', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (43, 385687, 'HÄ±zlÄ± ve Ã–fkeli 10', 'BirÃ§ok gÃ¶revde ve imkansÄ±z ÅŸartlar altÄ±nda, Dom Toretto ve ailesi yolundaki her dÃ¼ÅŸmanÄ± kurnazlÄ±kla, cesaretle ve sÃ¼rÃ¼ÅŸ becerileriyle alt ettiler. Åžimdiyse, geÃ§miÅŸin gÃ¶lgelerinden Ã§Ä±kan kan intikamÄ±yla gÃ¼Ã§lenmiÅŸ ve Dom\'un sevdiÄŸi her ÅŸeyi ve herkesi sonsuza dek yok etmeye kararlÄ± dehÅŸet verici bir tehditle karÅŸÄ± karÅŸÄ±yalar - hayatlarÄ±nÄ±n en Ã¶lÃ¼mcÃ¼l dÃ¼ÅŸmanÄ±yla.BirÃ§ok gÃ¶revde ve imkansÄ±z ÅŸartlar altÄ±nda, Dom Toretto ve ailesi yolundaki her dÃ¼ÅŸmanÄ± kurnazlÄ±kla, cesaretle ve sÃ¼rÃ¼ÅŸ becerileriyle alt ettiler. Åžimdiyse, geÃ§miÅŸin gÃ¶lgelerinden Ã§Ä±kan kan intikamÄ±yla gÃ¼Ã§lenmiÅŸ ve Dom\'un sevdiÄŸi her ÅŸeyi ve herkesi sonsuza dek yok etmeye kararlÄ± dehÅŸet verici bir tehditle karÅŸÄ± karÅŸÄ±yalar - hayatlarÄ±nÄ±n en Ã¶lÃ¼mcÃ¼l dÃ¼ÅŸmanÄ±yla.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2023-05-17', '142min', 'https://image.tmdb.org//t/p/original/Am1mIWClibXSNcDudFRV9F9RdBm.jpg', 'https://image.tmdb.org//t/p/original/4XM8DUTQb3lhLemJC51Jx4a2EuA.jpg', 'https://www.youtube.com/watch?v=32RAq6JzY-w', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (44, 603692, 'John Wick 4', 'Wick\'in geÃ§miÅŸteki dÃ¼ÅŸmanlarÄ±yla yÃ¼zleÅŸmek zorunda kaldÄ±ÄŸÄ± ve uluslararasÄ± bir suikastÃ§i aÄŸÄ±na karÅŸÄ± verdiÄŸi mÃ¼cadeleyi konu alÄ±r. Bu kez, John Wick, Ã¶zgÃ¼rlÃ¼ÄŸÃ¼ iÃ§in savaÅŸÄ±rken, eski dostlarÄ±nÄ±n ihanetleriyle de karÅŸÄ±laÅŸÄ±r. Wick, Ã§eÅŸitli yerlerde geÃ§en Ã§atÄ±ÅŸmalarda ustaca dÃ¶vÃ¼ÅŸ yeteneklerini sergilerken, her sahne heyecan verici bir ÅŸekilde kurgulanmÄ±ÅŸtÄ±r. \"John Wick 4\", hem dÃ¶vÃ¼ÅŸ sanatlarÄ± tutkunlarÄ± hem de aksiyon severler iÃ§in unutulmaz bir deneyim sunmayÄ± hedefliyor.Wick\'in geÃ§miÅŸteki dÃ¼ÅŸmanlarÄ±yla yÃ¼zleÅŸmek zorunda kaldÄ±ÄŸÄ± ve uluslararasÄ± bir suikastÃ§i aÄŸÄ±na karÅŸÄ± verdiÄŸi mÃ¼cadeleyi konu alÄ±r. Bu kez, John Wick, Ã¶zgÃ¼rlÃ¼ÄŸÃ¼ iÃ§in savaÅŸÄ±rken, eski dostlarÄ±nÄ±n ihanetleriyle de karÅŸÄ±laÅŸÄ±r. Wick, Ã§eÅŸitli yerlerde geÃ§en Ã§atÄ±ÅŸmalarda ustaca dÃ¶vÃ¼ÅŸ yeteneklerini sergilerken, her sahne heyecan verici bir ÅŸekilde kurgulanmÄ±ÅŸtÄ±r. \"John Wick 4\", hem dÃ¶vÃ¼ÅŸ sanatlarÄ± tutkunlarÄ± hem de aksiyon severler iÃ§in unutulmaz bir deneyim sunmayÄ± hedefliyor.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2023-03-22', '170min', 'https://image.tmdb.org//t/p/original/23H925rm6D1F2jbojKlUuiaAKd4.jpg', 'https://image.tmdb.org//t/p/original/7I6VUdPj6tQECNHdviJkUHD2u89.jpg', 'https://www.youtube.com/watch?v=qEVUtrk8_B4', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (45, 245891, 'John Wick', 'John Wick, emekliye ayrÄ±lmÄ±ÅŸ bir tetikÃ§idir. EmekliliÄŸinin tadÄ±nÄ± Ã§Ä±karÄ±rken karÄ±sÄ±nÄ±n yakalandÄ±ÄŸÄ± amansÄ±z hastalÄ±kla hayatÄ± altÃ¼st olur. KarÄ±sÄ±ndan kendisine kalan en deÄŸerli varlÄ±ÄŸÄ± ve can yoldaÅŸÄ± kÃ¶peÄŸidir. Ancak evine dalan Ã¼Ã§ gangster onu da Ã¶ldÃ¼rÃ¼r. Gansterlerden biri, mafya babasÄ± Viggo Tasarov\'un oÄŸlu Josef Tasarov\'dur ve John\'un daha Ã¶nce birlikte Ã§alÄ±ÅŸtÄ±ÄŸÄ± bir adamdÄ±r. ArtÄ±k kaybedecek hiÃ§bir ÅŸeyi de kalmayan John Wick\'in tek istediÄŸi intikamdÄ±r ve New York sokaklarÄ±nda dÃ¼ÅŸmanlarÄ±yla nefes kesen bir kovalamacanÄ±n iÃ§ine girer.John Wick, emekliye ayrÄ±lmÄ±ÅŸ bir tetikÃ§idir. EmekliliÄŸinin tadÄ±nÄ± Ã§Ä±karÄ±rken karÄ±sÄ±nÄ±n yakalandÄ±ÄŸÄ± amansÄ±z hastalÄ±kla hayatÄ± altÃ¼st olur. KarÄ±sÄ±ndan kendisine kalan en deÄŸerli varlÄ±ÄŸÄ± ve can yoldaÅŸÄ± kÃ¶peÄŸidir. Ancak evine dalan Ã¼Ã§ gangster onu da Ã¶ldÃ¼rÃ¼r. Gansterlerden biri, mafya babasÄ± Viggo Tasarov\'un oÄŸlu Josef Tasarov\'dur ve John\'un daha Ã¶nce birlikte Ã§alÄ±ÅŸtÄ±ÄŸÄ± bir adamdÄ±r. ArtÄ±k kaybedecek hiÃ§bir ÅŸeyi de kalmayan John Wick\'in tek istediÄŸi intikamdÄ±r ve New York sokaklarÄ±nda dÃ¼ÅŸmanlarÄ±yla nefes kesen bir kovalamacanÄ±n iÃ§ine girer.', 'Aksiyon,Aksiyon & Macera,Gerilim', '2014-10-22', '101min', 'https://image.tmdb.org//t/p/original/6SVzIUmISk8SiWA6OFcDvuK7jhI.jpg', 'https://image.tmdb.org//t/p/original/ipyxbPJrLB1g9AfHq4xH5nLWmew.jpg', 'https://www.youtube.com/watch?v=2AUmvWm5ZDQ', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (46, 458156, 'John Wick 3: Parabellum', '14 milyon dolarlÄ±k bir kontrat yÃ¼zÃ¼nden herkes John Wickâ€™in peÅŸine takÄ±lmÄ±ÅŸtÄ±r. Her tÃ¼rlÃ¼ hizmeti almasÄ± yasaklanÄ±r, diÄŸer bÃ¼tÃ¼n Ã¼yelerle iletiÅŸimi kesilir. Continental Hotelâ€™in yÃ¶neticisi Winston Oâ€™na kaÃ§Ä±p kaybolmasÄ± iÃ§in bir saat zaman verir. John, New Yorkâ€™tan Ã§Ä±kmak ve hayatta kalmak iÃ§in hizmet sektÃ¶rÃ¼nÃ¼ kullanacak, bunlarÄ± yaparken de dÃ¶vÃ¼ÅŸerek ve Ã¶ldÃ¼rerek kendini aklama yoluna devam edecektir.14 milyon dolarlÄ±k bir kontrat yÃ¼zÃ¼nden herkes John Wickâ€™in peÅŸine takÄ±lmÄ±ÅŸtÄ±r. Her tÃ¼rlÃ¼ hizmeti almasÄ± yasaklanÄ±r, diÄŸer bÃ¼tÃ¼n Ã¼yelerle iletiÅŸimi kesilir. Continental Hotelâ€™in yÃ¶neticisi Winston Oâ€™na kaÃ§Ä±p kaybolmasÄ± iÃ§in bir saat zaman verir. John, New Yorkâ€™tan Ã§Ä±kmak ve hayatta kalmak iÃ§in hizmet sektÃ¶rÃ¼nÃ¼ kullanacak, bunlarÄ± yaparken de dÃ¶vÃ¼ÅŸerek ve Ã¶ldÃ¼rerek kendini aklama yoluna devam edecektir.', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2019-05-15', '131min', 'https://image.tmdb.org//t/p/original/c1QmssgO9Kfx2fVFP0c1X7CGXX9.jpg', 'https://image.tmdb.org//t/p/original/vVpEOvdxVBP2aV166j5Xlvb5Cdc.jpg', 'https://www.youtube.com/watch?v=M7XM597XO94', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (47, 324552, 'John Wick 2', 'Emekliye ayrÄ±lmÄ±ÅŸ olan John Wick can yoldaÅŸÄ± kÃ¶peÄŸiyle sakin bir hayat sÃ¼rmektedir. Ancak baÅŸÄ±na gelen kimi olaylar onu bir kez daha suÃ§ dÃ¼nyasÄ±na iter. Bu kez bu uÄŸurda Roma sokaklarÄ±nÄ± arÅŸÄ±nlamasÄ± gerekecektir...Emekliye ayrÄ±lmÄ±ÅŸ olan John Wick can yoldaÅŸÄ± kÃ¶peÄŸiyle sakin bir hayat sÃ¼rmektedir. Ancak baÅŸÄ±na gelen kimi olaylar onu bir kez daha suÃ§ dÃ¼nyasÄ±na iter. Bu kez bu uÄŸurda Roma sokaklarÄ±nÄ± arÅŸÄ±nlamasÄ± gerekecektir...', 'Aksiyon,Aksiyon & Macera,SuÃ§,Gerilim', '2017-02-08', '122min', 'https://image.tmdb.org//t/p/original/1jUrsSAFwYTmsrKHAz9bgpdEVv.jpg', 'https://image.tmdb.org//t/p/original/tHkujDqdPC9VQoFpEWU0QgWIZyM.jpg', 'https://www.youtube.com/watch?v=Sx1Qm3gavRg', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (48, 293660, 'Deadpool', 'Eski bir Ã¶zel kuvvetler gÃ¶revlisi olan Wade Wilson ordudan ayrÄ±ldÄ±ktan sonra kendi Ã§Ã¶plÃ¼ÄŸÃ¼nde, kendi kurallarÄ±na gÃ¶re takÄ±lan, kÃ¶tÃ¼nÃ¼n iyisi bir adamdÄ±r. HayatÄ±na yeni giren Vanessa ile harika bir uyumu varken, bir ÅŸeylerin tam da yolunda gittiÄŸini dÃ¼ÅŸÃ¼nÃ¼rken, kanser olduÄŸu gerÃ§eÄŸiyle yÃ¼z yÃ¼ze kalÄ±r. SevdiÄŸi kadÄ±nÄ± bu acÄ±lÄ± sÃ¼reci izlemekten kurtarmak iÃ§in onu terk eden Wade, kendisine tedavi umudu sunan bir bilimsel projeye katÄ±lÄ±r. Fakat bu proje sadece bir \'yan etki\' olarak kansere tedavi olacaktÄ±r. AsÄ±l amaÃ§ birtakÄ±m DNA\'larÄ± tetiklemektir. Akla gelmeyecek acÄ±lara gÃ¶ÄŸÃ¼s geren Wade, her ÅŸey sona erdiÄŸinde Ã¼stÃ¼n yeteneklere sahip olur. Fakat tÃ¼m bu Ã¶zellikleriyle tek bir amacÄ± vardÄ±r: Ajax \"Francis\"ten intikam almak!Eski bir Ã¶zel kuvvetler gÃ¶revlisi olan Wade Wilson ordudan ayrÄ±ldÄ±ktan sonra kendi Ã§Ã¶plÃ¼ÄŸÃ¼nde, kendi kurallarÄ±na gÃ¶re takÄ±lan, kÃ¶tÃ¼nÃ¼n iyisi bir adamdÄ±r. HayatÄ±na yeni giren Vanessa ile harika bir uyumu varken, bir ÅŸeylerin tam da yolunda gittiÄŸini dÃ¼ÅŸÃ¼nÃ¼rken, kanser olduÄŸu gerÃ§eÄŸiyle yÃ¼z yÃ¼ze kalÄ±r. SevdiÄŸi kadÄ±nÄ± bu acÄ±lÄ± sÃ¼reci izlemekten kurtarmak iÃ§in onu terk eden Wade, kendisine tedavi umudu sunan bir bilimsel projeye katÄ±lÄ±r. Fakat bu proje sadece bir \'yan etki\' olarak kansere tedavi olacaktÄ±r. AsÄ±l amaÃ§ birtakÄ±m DNA\'larÄ± tetiklemektir. Akla gelmeyecek acÄ±lara gÃ¶ÄŸÃ¼s geren Wade, her ÅŸey sona erdiÄŸinde Ã¼stÃ¼n yeteneklere sahip olur. Fakat tÃ¼m bu Ã¶zellikleriyle tek bir amacÄ± vardÄ±r: Ajax \"Francis\"ten intikam almak!', 'Aksiyon,Komedi,Macera,Aksiyon & Macera', '2016-02-09', '108min', 'https://image.tmdb.org//t/p/original/99p0n6EhX6PebGIScQ0uRZ8aUv8.jpg', 'https://image.tmdb.org//t/p/original/en971MEXui9diirXlogOrPKmsEn.jpg', 'https://www.youtube.com/watch?v=FyKWUTwSYAs', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (49, 383498, 'Deadpool 2', 'Deadpool, kahramanlÄ±k iÅŸlerini devam ettirmekte, bir yandan da gÃ¼ndelik hayatÄ±nÄ± sÃ¼rdÃ¼rmektedir. KÄ±z arkadaÅŸÄ± Vanessa\'yla mutlu bir iliÅŸki sÃ¼rdÃ¼ren Deadpool\'un dÃ¼zeni, gelecekten gelen Cable\'Ä±n ortaya Ã§Ä±kÄ±ÅŸÄ±yla sarsÄ±lÄ±r. Cable gelecekte tehdit oluÅŸturacak bir Ã§ocuÄŸun peÅŸindedir. Deadpool, Cable\'Ä± durdurabilmek iÃ§in sÃ¼per gÃ¼Ã§lere sahip bir ekibi toplar ve bu aykÄ±rÄ± karakterlerden oluÅŸan X-Force ekibi, Deadpool\'la birlikte maceraya atÄ±lÄ±r...Deadpool, kahramanlÄ±k iÅŸlerini devam ettirmekte, bir yandan da gÃ¼ndelik hayatÄ±nÄ± sÃ¼rdÃ¼rmektedir. KÄ±z arkadaÅŸÄ± Vanessa\'yla mutlu bir iliÅŸki sÃ¼rdÃ¼ren Deadpool\'un dÃ¼zeni, gelecekten gelen Cable\'Ä±n ortaya Ã§Ä±kÄ±ÅŸÄ±yla sarsÄ±lÄ±r. Cable gelecekte tehdit oluÅŸturacak bir Ã§ocuÄŸun peÅŸindedir. Deadpool, Cable\'Ä± durdurabilmek iÃ§in sÃ¼per gÃ¼Ã§lere sahip bir ekibi toplar ve bu aykÄ±rÄ± karakterlerden oluÅŸan X-Force ekibi, Deadpool\'la birlikte maceraya atÄ±lÄ±r...', 'Aksiyon,Komedi,Macera,Aksiyon & Macera', '2018-05-10', '120min', 'https://image.tmdb.org//t/p/original/pV2OwKjfBnsCGNXVOz6nAqHm4pw.jpg', 'https://image.tmdb.org//t/p/original/3P52oz9HPQWxcwHOwxtyrVV1LKi.jpg', 'https://www.youtube.com/watch?v=D86RtevtfrA', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (50, 533535, 'Deadpool & Wolverine', 'Wade Wilsonâ€™un ahlaki aÃ§Ä±dan esnek bir paralÄ± asker olarak geÃ§irdiÄŸi gÃ¼nler ve Deadpool kimliÄŸi Ã§ok gerilerde kalmÄ±ÅŸ, artÄ±k sadece sivil hayatta varlÄ±k gÃ¶stermeye Ã§abalamaktadÄ±r. Ancak  sakin dÃ¼nyasÄ± bÃ¼yÃ¼k bir tehlike tehdidiyle karÅŸÄ± karÅŸÄ±ya kalÄ±nca Wade isteksizce harekete geÃ§mek zorunda kalÄ±r. Bu sorun karÅŸÄ±sÄ±nda, en az kendisi kadar isteksiz birini, Wolverineâ€™i yardÄ±m etmesi iÃ§in ikna etmeye Ã§alÄ±ÅŸÄ±r.', 'Aksiyon, Komedi, Bilim-Kurgu, ', '2024-07-24', '128', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/fVr2X3jnoeLuZ2v0L1O8MOdOiSz.jpg', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/yDHYTfA3R0jFYba16jBB1ef8oIt.jpg', 'https://www.youtube.com/watch?v=73_1biulkYk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (51, 671, 'Harry Potter ve Felsefe TaÅŸÄ±', 'Harry Potter, muggle (bÃ¼yÃ¼cÃ¼ yada cadÄ± olmayan insanlar) amcasÄ± ve halasÄ±yla sÄ±radan ve zorluklarla dolu bir hayatÄ± yaÅŸarken, yÄ±lanlarla konuÅŸabildiÄŸinin, kÄ±zgÄ±nlÄ±k Ã¶fkesi sÄ±rasÄ±nda eÅŸyalarÄ± hareket ettirebildiÄŸinin farkÄ±na varacaktÄ±r. Hogwarts BÃ¼yÃ¼cÃ¼lÃ¼k ve CadÄ±lÄ±k Okulu\'ndan kabul edildiÄŸini belirten mektup ise hayatÄ±nÄ±n sÄ±radanlÄ±ÄŸÄ±nÄ± deÄŸiÅŸtirecektir. ArtÄ±k o bir bÃ¼yÃ¼cÃ¼ adayÄ±dÄ±r.', 'Macera,Aksiyon & Macera,Fantastik', '2001-11-16', '159min', 'https://image.tmdb.org//t/p/original/6FHO9N5mj5hdgRNYzflgheemIBZ.jpg', 'https://image.tmdb.org//t/p/original/t3LicFpYHeYpwqm7L5wDpd22hL5.jpg', 'https://www.youtube.com/watch?v=PbdM1db3JbY', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (52, 672, 'Harry Potter ve SÄ±rlar OdasÄ±', 'Hogwarts CadÄ±lÄ±k ve BÃ¼yÃ¼cÃ¼lÃ¼k okulundaki ikinci yÄ±lÄ±na baÅŸlarken Harry Potter, ev cini Dobby tarafÄ±ndan okula dÃ¶nmesinin kendisi iÃ§in tehlikeli olacaÄŸÄ± konusunda uyarÄ±lÄ±r. Bunun yanÄ±nda ProfesÃ¶r Snape ondan halen hoÅŸlanmamaktadÄ±r, Draco Malfoy da ondan hala nefret eder. Bu ortamda Harry en iyi arkadaÅŸlarÄ± Ron ve Hermione ile birlikte yeni bir okul yÄ±lÄ±na baÅŸlar. ÃœnlÃ¼ yazar Gilderoy Lockhart da bu yÄ±l Hogwarts\'a katÄ±lmÄ±ÅŸtÄ±r. Ancak Hogwarts Ã¶ÄŸrencileri garip bir ÅŸekilde taÅŸa dÃ¶nÃ¼ÅŸmektedirler. Bunu kimin yaptÄ±ÄŸÄ±ysa gizemini korumaktadÄ±r.', 'Macera,Aksiyon & Macera,Fantastik', '2002-11-13', '175min', 'https://image.tmdb.org//t/p/original/sI62SD5NJMIVyMpY18gvdoyREJf.jpg', 'https://image.tmdb.org//t/p/original/yHzyPJrVqlTySQ9mc379yxrLBYQ.jpg', 'https://www.youtube.com/watch?v=s4Fh2WQ2Xbk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (53, 166426, 'Karayip KorsanlarÄ±: Salazar\'Ä±n Ä°ntikamÄ±', 'Ã‡Ä±lgÄ±n maceralarÄ± ile bilinen, kaptanlarÄ± ÅŸahÄ± ama bir o kadar talihsiz Jack Sparrow, yelken aÃ§tÄ±ÄŸÄ± sularda yaklaÅŸan kÃ¶tÃ¼ rÃ¼zgarlarÄ± hisseder. KorkunÃ§ Kaptan Salazar\'Ä±n yÃ¶netimindeki Ã¶lÃ¼mcÃ¼l hayalet korsanlar, denizdeki tÃ¼m korsanlarÄ± Ã¶ldÃ¼rerek Åžeytan ÃœÃ§geniâ€™nden kaÃ§mayÄ± baÅŸarmÄ±ÅŸtÄ±r; hayatta kalan tek korsan kaptan ise Jack\'tir. Jack, Salazar\'Ä±n gazabÄ±ndan ve intikamÄ±ndan kurtulmak iÃ§in Poseidon AsasÄ±â€™nÄ±n peÅŸine dÃ¼ÅŸer. Bu efsanevi asayÄ± bulmak iÃ§inse gÃ¼zel ve zeki gÃ¶kbilimci Carina Smyth ve Kraliyet DonanmasÄ±\'ndan  dik baÅŸlÄ±, genÃ§ bir denizci olan Henry ile zorlu bir anlaÅŸma yapar. KÃ¼Ã§Ã¼k ve kÃ¼lÃ¼stÃ¼r gemisi Dying Gullâ€™un dÃ¼menindeki Jack Sparrow, hem kÃ¶tÃ¼ kaderini tersine Ã§evirmenin hem de ÅŸimdiye dek karÅŸÄ±na Ã§Ä±kan en diÅŸli ve korkunÃ§ dÃ¼ÅŸmandan kurtulmanÄ±n yollarÄ±nÄ± arayacaktÄ±r.Ã‡Ä±lgÄ±n maceralarÄ± ile bilinen, kaptanlarÄ± ÅŸahÄ± ama bir o kadar talihsiz Jack Sparrow, yelken aÃ§tÄ±ÄŸÄ± sularda yaklaÅŸan kÃ¶tÃ¼ rÃ¼zgarlarÄ± hisseder. KorkunÃ§ Kaptan Salazar\'Ä±n yÃ¶netimindeki Ã¶lÃ¼mcÃ¼l hayalet korsanlar, denizdeki tÃ¼m korsanlarÄ± Ã¶ldÃ¼rerek Åžeytan ÃœÃ§geniâ€™nden kaÃ§mayÄ± baÅŸarmÄ±ÅŸtÄ±r; hayatta kalan tek korsan kaptan ise Jack\'tir. Jack, Salazar\'Ä±n gazabÄ±ndan ve intikamÄ±ndan kurtulmak iÃ§in Poseidon AsasÄ±â€™nÄ±n peÅŸine dÃ¼ÅŸer. Bu efsanevi asayÄ± bulmak iÃ§inse gÃ¼zel ve zeki gÃ¶kbilimci Carina Smyth ve Kraliyet DonanmasÄ±\'ndan  dik baÅŸlÄ±, genÃ§ bir denizci olan Henry ile zorlu bir anlaÅŸma yapar. KÃ¼Ã§Ã¼k ve kÃ¼lÃ¼stÃ¼r gemisi Dying Gullâ€™un dÃ¼menindeki Jack Sparrow, hem kÃ¶tÃ¼ kaderini tersine Ã§evirmenin hem de ÅŸimdiye dek karÅŸÄ±na Ã§Ä±kan en diÅŸli ve korkunÃ§ dÃ¼ÅŸmandan kurtulmanÄ±n yollarÄ±nÄ± arayacaktÄ±r.', 'Aksiyon,Macera,Aksiyon & Macera,Fantastik', '2017-05-23', '128min', 'https://image.tmdb.org//t/p/original/49dEadPwXooCcGx0lc1i4pnMuoD.jpg', 'https://image.tmdb.org//t/p/original/7C921eWK06n12c1miRXnYoEu5Yv.jpg', 'https://www.youtube.com/watch?v=Hgeu5rhoxxY', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (54, 58, 'Karayip KorsanlarÄ±: Ã–lÃ¼ Adam\'Ä±n SandÄ±ÄŸÄ±', 'Kaptan Jack Sparrrowâ€™un, UÃ§an HollandalÄ±â€™nÄ±n kaptanÄ± Davy Jonesâ€™a kan borcu olduÄŸu konusunda kendisine bir hatÄ±rlatma yapÄ±lÄ±r. Davy Jones, cehennemden Ã§Ä±kma mÃ¼rettebatÄ± ile bir hayalet geminin kaptanÄ±dÄ±r. Jack, borcunu temizlemezse, Davyâ€™nin kÃ¶lesi olarak kalmaya mahkum olacaktÄ±r. Jack Sparrowâ€™un iÃ§inden Ã§Ä±kamayacaÄŸÄ± durum pek gÃ¶rÃ¼lmediÄŸi Ã¼zere illa ki bir yol bulacaktÄ±r. Ã–lÃ¼ AdamÄ±n SandÄ±ÄŸÄ±â€™na sahip olan kiÅŸinin Davy Jonesâ€™un da kontrol edebileceÄŸini fark edince durum karmaÅŸÄ±klaÅŸacaktÄ±r.', 'Macera, Fantastik, Aksiyon', '2006-07-06', '151', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/kbHReT65bMcy0jyz7tMUi9NMuOd.jpg', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/vr6n6ZFUZvedvIlhfYcbCWcaKyW.jpg', 'https://www.youtube.com/watch?v=elqO-GNfStM', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (55, 22, 'Karayip KorsanlarÄ±: Siyah Ä°nci\'nin Laneti', 'Hafif Ã¼Ã§kaÄŸÄ±tÃ§Ä± fakat bir o kadar da sevimli Kaptan Jack Sparrowâ€™un (Johnny Depp) korsanlÄ±k yaÅŸamÄ±, dÃ¼ÅŸmanÄ± kurnaz Kaptan Barbossaâ€™nÄ±n (Geoffrey Rush), gemisi Siyah Ä°nciâ€™yi Ã§almasÄ±yla altÃ¼st olur. Bu da yetmezmiÅŸ gibi Kaptan Barbossa, Port Royal kasabasÄ±na saldÄ±rÄ±r ve belediye baÅŸkanÄ±nÄ±n gÃ¼zeller gÃ¼zeli kÄ±zÄ± Elizabethâ€™i (Keira Knightley) kaÃ§Ä±rÄ±r. KÄ±zÄ± kurtarmak ve Siyah Ä°nciâ€™yi yeniden ele geÃ§irmek amacÄ±yla Elizabethâ€™in Ã§ocukluk arkadaÅŸÄ± Will (Orlando Bloom) ve Jack gÃ¼Ã§lerini birleÅŸtirirler. Willâ€™in bilmediÄŸi ise lanetli bir hazinenin Barbossaâ€™nÄ±n kaderini nasÄ±l deÄŸiÅŸtirdiÄŸi ve onu ve mÃ¼rettebatÄ±nÄ± nasÄ±l sonsuza kadar Ã¶lÃ¼msÃ¼z olarak yaÅŸamaya mahkum ettiÄŸidir.', 'Macera, Fantastik, Aksiyon', '2003-07-09', '143', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/hGIDdwPMM8tusFMiobZiJ942O4c.jpg', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/wW7Wt5bXzPy4VOEE4LTIUDyDgBo.jpg', 'https://www.youtube.com/watch?v=naQr0uTrH_s', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (56, 1865, 'Karayip KorsanlarÄ±: Gizemli Denizlerde', '<span style=\"color: rgb(255, 255, 255); font-family: &quot;Source Sans Pro&quot;, Arial, sans-serif; font-size: 16px; background-color: rgb(255, 255, 255);\"><font style=\"vertical-align: inherit;\"><font style=\"vertical-align: inherit;\">Gizemli Angelica (Penelope Cruz) ile Jack Sparrow\'un kesiştiği yollar, bunun aşkın olduğundan emin değildir – yoksa bu kadın onu efsanevi Gençlik Pınarı\'nı bulmak için kullanmakta mıydı? Kadın onu efsane korsan Kara Sakal\'ın gemisi \"Kraliçe Anne\'in İntikamı\"na bindirdiğinde kendisini beklenmedik bir maceranın ortasında bulur ve kimden daha çok korkması gerektiğini bilemez: Kara Sakal\'dan mı yoksa gizemli bir geçmişi Angelica\'dan mı paylaştı?</font></font></span><br>', 'Aksiyon,Macera,Aksiyon & Macera,Fantastik', '2011-05-15', '137', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/9CqNYF0kEXulBFwKExSeojrPcxV.jpg', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/uzIGtyS6bbnJzGsPL93WCF1FWm8.jpg', 'https://www.youtube.com/watch?v=t5AqJww06bw', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (57, 105, 'Geleceğe Dönüş', 'Dönemin özellikle tasarımıyla öne çıkan otomobillerinden olan bir DeLoran\'ın içine gizlenmiş icat, Marty\'i yanlışlıkla 50\'lere geri götürür. Sorumsuz delikanlı bu gösterişsiz Amerikan kasabasında bir kazaya yol açar ve müstakbel anne ve babasının tanışmasına engel olur. Böylece kendisi de hiç doğmamış olacağı için bu durumu düzeltmesi gerekmektedir. Ama hayat sandığından daha karmaşıktır ve sorumluluk kelimesinin anlamını öğrenmek zorundadır.', 'Komedi,Macera,Aksiyon & Macera,Bilim Kurgu', '1985-07-03', '116min', 'https://image.tmdb.org//t/p/original/s6pfkJuTFZe7BCfJ5vOCECNmQbW.jpg', 'https://image.tmdb.org//t/p/original/hxSB02ksqnkXY4hPGAXqgO2fL01.jpg', 'https://www.youtube.com/watch?v=qb7Fd0l_BRo', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (58, 165, 'Geleceğe Dönüş II', 'Marty bu kez 2015\'e gidip henüz doğmamış çocuğuna yardım etmek zorunda kalacak. Elbette bunu yaparken ortalığı karıştıp zamanın dokusuna ve düzenine zarar verecek. Dostumuz, yol açtığı sorunları çözmek için yeniden geçmişe, sonra da geleceğe gidip gelecek. 50\'lere döndüğünde, ilk serüvendeki sahnelerin bazılarını yeniden yaşama fırsatı bulacak ama bu kez başka birinin gözünden!Marty bu kez 2015\'e gidip henüz doğmamış çocuğuna yardım etmek zorunda kalacak. Elbette bunu yaparken ortalığı karıştıp zamanın dokusuna ve düzenine zarar verecek. Dostumuz, yol açtığı sorunları çözmek için yeniden geçmişe, sonra da geleceğe gidip gelecek. 50\'lere döndüğünde, ilk serüvendeki sahnelerin bazılarını yeniden yaşama fırsatı bulacak ama bu kez başka birinin gözünden!', 'Komedi,Macera,Aksiyon & Macera,Bilim-Kurgu', '1989-11-22', '108min', 'https://image.tmdb.org//t/p/original/9en7rsecFBOMAZYqwuVeZpTjtpl.jpg', 'https://image.tmdb.org//t/p/original/skQN2UMQKQnOTmwplcYMx6ZF4jS.jpg', 'https://www.youtube.com/watch?v=M8kvj07HpFI', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (59, 196, 'Geleceğe Dönüş III', '1955 yılında kısılıp kalan Marty\'yi kurtarmak için Dr. Brown zamanda seyahat eder. Ancak kendisi 1885\'e gelip DeLorean bozulduğu ve o zamanın teknolojisi yetmediği için burada takılan Doktor, Marty\'ye bir mektup yazarak arabayı gömdüğü yeri söyler. 1955\'teki Marty bu sayede arabayı bulur ve Doktoru kurtarmaya vahşi batıya gelir. Tabii burada işler umduğu gibi olmaz zira Dr. Brown hem iyi bir doktor olmuş hem de çok feci aşık olmuştır bunun dışında peşine de onu öldürmek isteyen bir kanun kaçağı çetesini takmıştır.1955 yılında kısılıp kalan Marty\'yi kurtarmak için Dr. Brown zamanda seyahat eder. Ancak kendisi 1885\'e gelip DeLorean bozulduğu ve o zamanın teknolojisi yetmediği için burada takılan Doktor, Marty\'ye bir mektup yazarak arabayı gömdüğü yeri söyler. 1955\'teki Marty bu sayede arabayı bulur ve Doktoru kurtarmaya vahşi batıya gelir. Tabii burada işler umduğu gibi olmaz zira Dr. Brown hem iyi bir doktor olmuş hem de çok feci aşık olmuştır bunun dışında peşine de onu öldürmek isteyen bir kanun kaçağı çetesini takmıştır.', 'Komedi,Macera,Aksiyon & Macera,Bilim-Kurgu', '1990-05-25', '119min', 'https://image.tmdb.org//t/p/original/l28VFt2qCamIKA9HGrKLYHASKtH.jpg', 'https://image.tmdb.org//t/p/original/vKp3NvqBkcjHkCHSGi6EbcP7g4J.jpg', 'https://www.youtube.com/watch?v=DTdBq1fQOBU', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (60, 619264, 'The Platform', 'Dikey yerleşimli bir tesiste üzeri yemek dolu bir platform aşağı doğru iner. Üst katlardakiler doyasıya yerken alttakiler aç ve çaresiz kalır. İsyan kaçınılmazdır.Dikey yerleşimli bir tesiste üzeri yemek dolu bir platform aşağı doğru iner. Üst katlardakiler doyasıya yerken alttakiler aç ve çaresiz kalır. İsyan kaçınılmazdır.', 'Dram,Bilim-Kurgu,Gerilim', '2019-11-08', '95min', 'https://image.tmdb.org//t/p/original/qv30R1uDDKTLWDlNc3qi6MRdRf0.jpg', 'https://image.tmdb.org//t/p/original/3tkDMNfM2YuIAJlvGO6rfIzAnfG.jpg', 'https://www.youtube.com/watch?v=Ez0rXJfjnsc', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (61, 1125510, 'The Platform 2', 'Gizemli bir lider, dikey hücrelerden oluşan acımasız bir sistemde kendi kanunlarını dayatırken yeni gelen biri, şaibeli yiyecek dağıtım yöntemine karşı mücadele eder.Gizemli bir lider, dikey hücrelerden oluşan acımasız bir sistemde kendi kanunlarını dayatırken yeni gelen biri, şaibeli yiyecek dağıtım yöntemine karşı mücadele eder.', 'Dram,Bilim-Kurgu,Gerilim', '2024-09-27', '100min', 'https://image.tmdb.org//t/p/original/3awoWMKDfTROjGB2vivky1TCSRd.jpg', 'https://image.tmdb.org//t/p/original/3m0j3hCS8kMAaP9El6Vy5Lqnyft.jpg', 'https://www.youtube.com/watch?v=UKFMYWNatQM', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (62, 1014661, 'House of Spoils', 'House of Spoils, ilk restoranını açan hırslı bir şefin hikayesini anlatıyor. Uzak bir arazide çiftlikten sofraya konseptiyle hizmet veren bu restoranda mutfak kaosu, kuşkulu bir yatırımcı, ezici öz şüpheler ve arazinin her fırsatta onu sabote etmekle tehdit eden eski sahibinin güçlü ruhuyla mücadele ediyor.House of Spoils, ilk restoranını açan hırslı bir şefin hikayesini anlatıyor. Uzak bir arazide çiftlikten sofraya konseptiyle hizmet veren bu restoranda mutfak kaosu, kuşkulu bir yatırımcı, ezici öz şüpheler ve arazinin her fırsatta onu sabote etmekle tehdit eden eski sahibinin güçlü ruhuyla mücadele ediyor.', 'Gerilim,Korku', '2024-09-21', '101min', 'https://image.tmdb.org//t/p/original/udfMAdiyKhgAS47dRXEnXo6tHt6.jpg', 'https://image.tmdb.org//t/p/original/ziNTYITRqa7Xy69dnaWAS3TQ69I.jpg', 'https://www.youtube.com/watch?v=qPtxADbsUzk', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (63, 671, 'Harry Potter ve Felsefe Taşı', 'Harry Potter, muggle (büyücü yada cadı olmayan insanlar) amcası ve halasıyla sıradan ve zorluklarla dolu bir hayatı yaşarken, yılanlarla konuşabildiğinin, kızgınlık öfkesi sırasında eşyaları hareket ettirebildiğinin farkına varacaktır. Hogwarts Büyücülük ve Cadılık Okulu\'ndan kabul edildiğini belirten mektup ise hayatının sıradanlığını değiştirecektir. Artık o bir büyücü adayıdır.Harry Potter, muggle (büyücü yada cadı olmayan insanlar) amcası ve halasıyla sıradan ve zorluklarla dolu bir hayatı yaşarken, yılanlarla konuşabildiğinin, kızgınlık öfkesi sırasında eşyaları hareket ettirebildiğinin farkına varacaktır. Hogwarts Büyücülük ve Cadılık Okulu\'ndan kabul edildiğini belirten mektup ise hayatının sıradanlığını değiştirecektir. Artık o bir büyücü adayıdır.', 'Macera,Aksiyon & Macera,Fantastik', '2001-11-16', '159min', 'https://image.tmdb.org//t/p/original/6FHO9N5mj5hdgRNYzflgheemIBZ.jpg', 'https://image.tmdb.org//t/p/original/t3LicFpYHeYpwqm7L5wDpd22hL5.jpg', 'https://www.youtube.com/watch?v=PbdM1db3JbY', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (64, 767, 'Harry Potter ve Melez Prens', 'Voldemort hem Muggle hem de büyücüler dünyasındaki kıskacını daraltmaktadır ve Hogwarts artık bir zamanlar olduğu güvenli liman değildir. Harry tehlikenin kalenin içinde bile olabileceğinden şüphelenirken, Dumbledore da Harry’yi hızla yaklaşmakta olduğunu bildiği nihai savaşa hazırlamaya her zamankinden kararlıdır. Birlikte, Voldemort’un savunma hattını kırmanın yollarını ararlar. Bu amaçla, Dumbledore eski bir dostu ve meslektaşı olan, çok önemli bilgilere sahip olduğunu düşündüğü Profesör Horace Slughorn’u görevlendirir. Profesör iyi bağlantıları olan, iyi yaşamayı seven, saf bir insandır.Bu arada, öğrenciler bambaşka bir rakibin kuşatması altındadırlar: Gençlik hormonları zirveye tırmanmaktadır.Voldemort hem Muggle hem de büyücüler dünyasındaki kıskacını daraltmaktadır ve Hogwarts artık bir zamanlar olduğu güvenli liman değildir. Harry tehlikenin kalenin içinde bile olabileceğinden şüphelenirken, Dumbledore da Harry’yi hızla yaklaşmakta olduğunu bildiği nihai savaşa hazırlamaya her zamankinden kararlıdır. Birlikte, Voldemort’un savunma hattını kırmanın yollarını ararlar. Bu amaçla, Dumbledore eski bir dostu ve meslektaşı olan, çok önemli bilgilere sahip olduğunu düşündüğü Profesör Horace Slughorn’u görevlendirir. Profesör iyi bağlantıları olan, iyi yaşamayı seven, saf bir insandır.Bu arada, öğrenciler bambaşka bir rakibin kuşatması altındadırlar: Gençlik hormonları zirveye tırmanmaktadır.', 'Macera,Aksiyon & Macera,Fantastik', '2009-07-15', '153min', 'https://image.tmdb.org//t/p/original/qNnc26VS15FdNf5QSoVOWaIZLaB.jpg', 'https://image.tmdb.org//t/p/original/urDWNffjwmNi5IQaezw9GwqkUXa.jpg', 'https://www.youtube.com/watch?v=JYLdTuL9Wjw', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (65, 889737, 'Joker: İkili Delilik', 'Zamanla kendi kimliğinden uzaklaşıp Joker kimliğine bürünen Arthur Fleck’in hayatına odaklanılan Joker filminin devam halkası olan Joker: Folie à Deux’da, Joker karakterine bir kez daha Joaquin Phoenix hayat veriyor. Joker’in aynı derecede dengesiz olan muadili Harley Quinn rolünü ise Lady Gaga üstleniyor.Zamanla kendi kimliğinden uzaklaşıp Joker kimliğine bürünen Arthur Fleck’in hayatına odaklanılan Joker filminin devam halkası olan Joker: Folie à Deux’da, Joker karakterine bir kez daha Joaquin Phoenix hayat veriyor. Joker’in aynı derecede dengesiz olan muadili Harley Quinn rolünü ise Lady Gaga üstleniyor.', 'Dram,Gerilim,Suç', '2024-10-01', '138min', 'https://image.tmdb.org//t/p/original/np1vrw75NcwOxSUrNIJsE0IFYfS.jpg', 'https://image.tmdb.org//t/p/original/reNf6GBzOe48l9WEnFOxXgW56Vg.jpg', 'https://www.youtube.com/watch?v=xy8aJw1vYHo', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (66, 698687, 'Transformers: Başlangıç', 'Yeminli düşmanlar olarak bilinen, ama bir zamanlar kardeş gibi birbirine bağlı dostlar olan ve Cybertron\'un kaderini sonsuza dek değiştiren Optimus Prime ve Megatron\'un anlatılmamış köken hikayesi.Yeminli düşmanlar olarak bilinen, ama bir zamanlar kardeş gibi birbirine bağlı dostlar olan ve Cybertron\'un kaderini sonsuza dek değiştiren Optimus Prime ve Megatron\'un anlatılmamış köken hikayesi.', 'Animasyon,Aile,Macera,Aksiyon & Macera,Bilim-Kurgu', '2024-09-11', '104min', 'https://image.tmdb.org//t/p/original/5tlRopdbFf8rFjPmDY56WmnkmR3.jpg', 'https://image.tmdb.org//t/p/original/tAwfoDyKiYa4KQdUp3DTMrEs4En.jpg', 'https://www.youtube.com/watch?v=5a09yJU-mCI', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (67, 27275, 'G.O.R.A.', 'Arif, Antalya’da halı ticareti yapmaktadır. En büyük zevki UFO’larla ilgili hayaller kurup bunları çevresi ile paylaşmaktır. Bir gün hayali gerçek olur ve uzaylılar tarafından kaçırılır. Komutan Logar’ın esir ettiği Arif, GORA gezegenini bir alev topundan kurtarır. Bu sayede Logar’ın düşmanlığını, Amiral’in kızı Prenses Ceku’nunsa sevgisini kazanır. Oysa Logar, Prenses Ceku ile evlenip gezegeni ele geçirmeyi planlamaktadır. Arif’in yapabileceği tek şey, kaçarken Ceku’yu da yanına almaktır.Arif, Antalya’da halı ticareti yapmaktadır. En büyük zevki UFO’larla ilgili hayaller kurup bunları çevresi ile paylaşmaktır. Bir gün hayali gerçek olur ve uzaylılar tarafından kaçırılır. Komutan Logar’ın esir ettiği Arif, GORA gezegenini bir alev topundan kurtarır. Bu sayede Logar’ın düşmanlığını, Amiral’in kızı Prenses Ceku’nunsa sevgisini kazanır. Oysa Logar, Prenses Ceku ile evlenip gezegeni ele geçirmeyi planlamaktadır. Arif’in yapabileceği tek şey, kaçarken Ceku’yu da yanına almaktır.', 'Komedi,Macera,Aksiyon & Macera,Bilim-Kurgu', '2004-11-12', '123min', 'https://image.tmdb.org//t/p/original/hXLKHzlybVWloEbfWKZ43APdGUX.jpg', 'https://image.tmdb.org//t/p/original/g90Hlbaj8OofowG9hDg9ScD5fqG.jpg', 'https://www.youtube.com/watch?v=EmCsr9g9q-o', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (68, 24426, 'A.R.O.G', 'Komutan Logar, halı tüccarı Arif\'i zamanda bir milyon yıl geriye gönderir. Burada dinozorlarla karşılaşan Arif, sakalını tıraş etmenin bir yolunu da bulur.Komutan Logar, halı tüccarı Arif\'i zamanda bir milyon yıl geriye gönderir. Burada dinozorlarla karşılaşan Arif, sakalını tıraş etmenin bir yolunu da bulur.', 'Komedi,Bilim-Kurgu,Fantastik', '2008-12-05', '127min', 'https://image.tmdb.org//t/p/original/oWhCozl58kpEtM2TdcH3Vs6SUCV.jpg', 'https://image.tmdb.org//t/p/original/iyTbRgp3W2jbl6XyNXNbQdx3aAr.jpg', '', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (69, 450720, 'Arif V 216', 'Robot olan 216, insan olmanın hayalini kurmaktadır. Uzaydan dünyaya çok sevdiği arkadaşı Arif’in yanına gelir ve insan gibi yaşamaya başlar. Sıradan insanlar gibi bir yaşam sürmeye çalışsa da farklılığı kimsenin dikkatinden kaçmaz. Yeni yaşantısını alışmaya çalıştığı sırada aşk da kapısını çalmıştır. Robot olduğunu herkesten saklamaya çalışan 216 bunu başaramaz. 216’dan ilham alan bir iş adamı, onu herkese tanıtıp kopyalarını yapmak ister. Sunduğu cazip tekliflerle 216’yı kandırmayı başaran iş adamı, onun sayesinde geleceği değiştirecektir. Arif bu korkunç planı öğrenir ve hem dünyayı hem de 216’yı kurtarmak için bir mücadeleye girişir.Robot olan 216, insan olmanın hayalini kurmaktadır. Uzaydan dünyaya çok sevdiği arkadaşı Arif’in yanına gelir ve insan gibi yaşamaya başlar. Sıradan insanlar gibi bir yaşam sürmeye çalışsa da farklılığı kimsenin dikkatinden kaçmaz. Yeni yaşantısını alışmaya çalıştığı sırada aşk da kapısını çalmıştır. Robot olduğunu herkesten saklamaya çalışan 216 bunu başaramaz. 216’dan ilham alan bir iş adamı, onu herkese tanıtıp kopyalarını yapmak ister. Sunduğu cazip tekliflerle 216’yı kandırmayı başaran iş adamı, onun sayesinde geleceği değiştirecektir. Arif bu korkunç planı öğrenir ve hem dünyayı hem de 216’yı kurtarmak için bir mücadeleye girişir.', 'Komedi,Macera,Aksiyon & Macera,Bilim-Kurgu', '2018-01-05', '126min', 'https://image.tmdb.org//t/p/original/piVSQrFRnSF1iXpYO5FoRbYfZI2.jpg', 'https://image.tmdb.org//t/p/original/xwBMzAq3JFO4U7aSvAng9jcoZyH.jpg', '', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (70, 331313, 'Komşum Bir Ajan', 'Casusluk komedisi türü filmde bir banliyö çifti, görünüşte mükemmel bir çift olan yeni komşularının hükûmet casusu olduğunu öğrendiklerinde uluslararası casusluk komplosunun ortasında kalakalırlar.Casusluk komedisi türü filmde bir banliyö çifti, görünüşte mükemmel bir çift olan yeni komşularının hükûmet casusu olduğunu öğrendiklerinde uluslararası casusluk komplosunun ortasında kalakalırlar.', 'Aksiyon,Komedi,Aksiyon & Macera,aile-filmleri', '2016-10-20', '105min', 'https://image.tmdb.org//t/p/original/yvWcTrRCzE4C2hkd2wV4erPuKCn.jpg', 'https://image.tmdb.org//t/p/original/o4qR3tT1lLeLy7nL0TaLM5LQmgW.jpg', 'https://www.youtube.com/watch?v=nPfYXXg65qA', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (71, 1065826, 'The Adventures of Jurassic Pet 2: The Lost Secret', '', 'Komedi,Aile,Macera,Aksiyon & Macera,Bilim-Kurgu,aile-filmleri', '2023-05-04', '84min', 'https://image.tmdb.org//t/p/original/wxDG3w316i5bQ4vw4qDAVE7tAR9.jpg', 'https://image.tmdb.org//t/p/original/79czbC1CQ4Mak3AjextNzGubPfJ.jpg', 'https://www.youtube.com/watch?v=FeDPc_Z8Z4Q', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (72, 594767, 'Shazam! Tanrıların Öfkesi', 'Bu yapım, genç Billy Batson\'un (Shazam) süper güçlerini kullanarak hem kendi içsel sorunlarıyla yüzleşmesini hem de yeni düşmanlarla mücadelesini konu alıyor. Billy ve arkadaşlarının Shazam güçlerini kullanarak hayatlarına devam etmeye çalışmaktalar. Ancak, bu sırada tanrıların dünyasından gelen yeni bir tehdit ortaya çıkar: Hespera ve onun kız kardeşleri, kendilerine ait olan büyülü güçleri geri almak için insan dünyasına gelirler. Hespera, güçlü bir düşman olarak karşımıza çıkarak, Shazam ve ekibi için büyük bir tehlike oluşturur. Billy, Shazam kimliğini koruyarak, hem arkadaşlarıyla birlikte hem de ailesiyle olan bağlarını güçlendirmeye çalışırken, aynı zamanda bu yeni düşmanı durdurmak zorundadır.Bu yapım, genç Billy Batson\'un (Shazam) süper güçlerini kullanarak hem kendi içsel sorunlarıyla yüzleşmesini hem de yeni düşmanlarla mücadelesini konu alıyor. Billy ve arkadaşlarının Shazam güçlerini kullanarak hayatlarına devam etmeye çalışmaktalar. Ancak, bu sırada tanrıların dünyasından gelen yeni bir tehdit ortaya çıkar: Hespera ve onun kız kardeşleri, kendilerine ait olan büyülü güçleri geri almak için insan dünyasına gelirler. Hespera, güçlü bir düşman olarak karşımıza çıkarak, Shazam ve ekibi için büyük bir tehlike oluşturur. Billy, Shazam kimliğini koruyarak, hem arkadaşlarıyla birlikte hem de ailesiyle olan bağlarını güçlendirmeye çalışırken, aynı zamanda bu yeni düşmanı durdurmak zorundadır.', 'Aksiyon,Komedi,Aksiyon & Macera,Fantastik', '2023-03-15', '130min', 'https://image.tmdb.org//t/p/original/sPJ561hs7GcV2Ebi3vgE9dtiMSQ.jpg', 'https://image.tmdb.org//t/p/original/zRQITMLvVi8z2Xz12Bi6wvbZE82.jpg', 'https://www.youtube.com/watch?v=Zi88i4CpHe4', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (73, 572802, 'Aquaman ve Kayıp Krallık', 'Aquaman’i ilk seferinde yenmeyi başaramayan Black Manta, babasının intikamını alma arzusuyla Aquaman’i sonsuza dek alt etme konusunda engel tanımayacaktır. Black Manta bu kez her zamankinden daha dişli bir düşmandır; elinde ise kötücül bir gücü açığa çıkaran efsanevi Black Trident vardır. Aquaman bu güçlü düşmanı yenmek için, Atlantis’in eski Kralı olan hapisteki kardeşi Orm ile ittifak kurar.Aquaman’i ilk seferinde yenmeyi başaramayan Black Manta, babasının intikamını alma arzusuyla Aquaman’i sonsuza dek alt etme konusunda engel tanımayacaktır. Black Manta bu kez her zamankinden daha dişli bir düşmandır; elinde ise kötücül bir gücü açığa çıkaran efsanevi Black Trident vardır. Aquaman bu güçlü düşmanı yenmek için, Atlantis’in eski Kralı olan hapisteki kardeşi Orm ile ittifak kurar.', 'Aksiyon,Macera,Aksiyon & Macera,Fantastik', '2023-12-20', '124min', 'https://image.tmdb.org//t/p/original/lnY7pZrAreZ3cAXEfDGbJM9ijIA.jpg', 'https://image.tmdb.org//t/p/original/cnqwv5Uz3UW5f086IWbQKr3ksJr.jpg', 'https://www.youtube.com/watch?v=UGc5Tzz19UY', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (74, 297802, 'Aquaman', 'Sualtı Krallığı Atlantis’in kraliçesi Atlanna’nın bir deniz feneri gözcüsüne aşık olması sonucu dünyaya gelen Arthur Curry, yaşamını insanların içinde sürdürmektedir ve zaman içerisinde Atlantis’in tek gerçek varisi olduğunu öğrenir. Fakat Aquaman’in üvey kardeşi Prens Orm, doğum sırasına göre hakkı olmayan Atlantis tahtına göz dikmiştir. Arthur, annesinden kalan mirasa sahip çıkarak hem tahtın sahibi olmalı hem de kötülüklerle savaşmalıdır.', 'Aksiyon,Macera,Aksiyon & Macera,Fantastik', '2018-12-07', '143min', 'https://image.tmdb.org//t/p/original/v5ykZHV9HoGz9rpiXgz6Gz5fV1Y.jpg', 'https://image.tmdb.org//t/p/original/skauHPLA4so9PqOuu3jhWmiWnFd.jpg', '', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (75, 1071215, 'Kara Cuma', 'Gizemli bir seri katil, Şükran Günü’nden ilham alarak bu özel günün ortaya çıktığı ve kutlamaların başladığı yer olan Plymouth’un Massachusetts kasabasında cinayetlere başlar ve terör estirmeye başlar. Merkez mahalle sakinleri tek tek öldürülmektedir. Bu özel günde kendilerini büyük bir kâbusun içinde bulan insanlar, seri katili ortaya çıkarıp tatilden sağ kurtulmayı başaracak mıdırlar yoksa onun çarpık tatil ve ziyafet masasına konuk mu olacaktırlar?Gizemli bir seri katil, Şükran Günü’nden ilham alarak bu özel günün ortaya çıktığı ve kutlamaların başladığı yer olan Plymouth’un Massachusetts kasabasında cinayetlere başlar ve terör estirmeye başlar. Merkez mahalle sakinleri tek tek öldürülmektedir. Bu özel günde kendilerini büyük bir kâbusun içinde bulan insanlar, seri katili ortaya çıkarıp tatilden sağ kurtulmayı başaracak mıdırlar yoksa onun çarpık tatil ve ziyafet masasına konuk mu olacaktırlar?', 'Gerilim,Gizem,Korku', '2023-11-16', '106min', 'https://image.tmdb.org//t/p/original/q0B5EXnqroNg3Lgo0cV2qi2GEQR.jpg', 'https://image.tmdb.org//t/p/original/ktHEdqmMWC1wdfPRMRCTZe2OISL.jpg', 'https://www.youtube.com/watch?v=KbU50SdL8zA', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (76, 10315, 'Yaman Tilki', 'Mr. Fox ailesini beslemek için her akşam üç zengin çiftçiden tavuk, ördek ve hindi çalmaktadır. Sinirli çiftçiler tilkiden artık bıkmışlardır ve onu öldürmek için ellerinden gelen herşeyi yapmaktadırlar. Sonunda yakalanan tilki, çiftçilerden daha zeki davranarak yakalandığı yerden aç kalmamak için çıkmaya çalışır.Mr. Fox ailesini beslemek için her akşam üç zengin çiftçiden tavuk, ördek ve hindi çalmaktadır. Sinirli çiftçiler tilkiden artık bıkmışlardır ve onu öldürmek için ellerinden gelen herşeyi yapmaktadırlar. Sonunda yakalanan tilki, çiftçilerden daha zeki davranarak yakalandığı yerden aç kalmamak için çıkmaya çalışır.', 'Animasyon,Komedi,Aile,Macera,Aksiyon & Macera,aile-filmleri', '2009-10-23', '87min', 'https://image.tmdb.org//t/p/original/yfQJWTnARrunzLFjKnU89z6GZv6.jpg', 'https://image.tmdb.org//t/p/original/qU4HDNKv7gjdlvMu74r70rISPwn.jpg', 'https://www.youtube.com/watch?v=n2igjYFojUo', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (77, 335983, 'Venom: Zehirli Öfke', 'Marvel’in en esrarengiz, karmaşık ve en kötü karakterinin evrim hikâyesi - Venom! Eddie Brock, işi ve sevgilisi dâhil her şeyini kaybetmiş umutsuz bir adamdır. Hayatının en kötü zamanında, onu Venom’a dönüştürecek ve süper güçlere sahip olmasını sağlayacak bir symbiote’un taşıyıcısı olur. Bu güçler, bu yeni ölümcül koruyucunun, , büyük kötü güçleri özellikle de daha güçlü ve daha silahlı simbiote rakibi Riot\'u yenmesi için yeterli olacak mı?Marvel’in en esrarengiz, karmaşık ve en kötü karakterinin evrim hikâyesi - Venom! Eddie Brock, işi ve sevgilisi dâhil her şeyini kaybetmiş umutsuz bir adamdır. Hayatının en kötü zamanında, onu Venom’a dönüştürecek ve süper güçlere sahip olmasını sağlayacak bir symbiote’un taşıyıcısı olur. Bu güçler, bu yeni ölümcül koruyucunun, , büyük kötü güçleri özellikle de daha güçlü ve daha silahlı simbiote rakibi Riot\'u yenmesi için yeterli olacak mı?', 'Aksiyon,Aksiyon & Macera,Bilim-Kurgu', '2018-09-28', '112min', 'https://image.tmdb.org//t/p/original/bQK5C2mL7DJUpQSahoT2CYMtvkX.jpg', 'https://image.tmdb.org//t/p/original/VuukZLgaCrho2Ar8Scl9HtV3yD.jpg', 'https://www.youtube.com/watch?v=u9Mv98Gr5pY', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (78, 121875, 'Evde', 'İspanyol Juan Mayorga\'nın \"Arkaa Sıradaki Çocuk\" oyunundan uyarlama olan sinema filmi, 16 yaşındaki gizemli bir çocuk ile bir edebiyat öğretmeni arasında geçen olayları konu alıyor. Claude meraklı ve çokta yetenekli bir öğrencidir. Yaşıtlarına göre ileri derecede yazarlık yeteneği vardır. Bir gün arkadaşının evine gizlice girer ve evde gördüklerini bir kompozisyonda yazar. Edebiyat öğretmeninin Claude\'nin bu yaptıklarından haberi olsa da kimseye bundan bahsetmez. Ancak bütün bunlar ikilinin başına büyük dertler açacaktır.', 'Dram,Komedi,Gerilim,Gizem', '2012-09-26', '105min', 'https://image.tmdb.org//t/p/original/iqrdGLT9DjuKyPZ6eadk1XEK8U6.jpg', 'https://image.tmdb.org//t/p/original/44e7qs704rSWWGFMhGtPhAvyT8O.jpg', 'https://www.youtube.com/watch?v=oxbWP_oYLGQ', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (79, 786892, 'Furiosa: Bir Mad Max Destanı', 'Genç Furiosa, dünya çökerken Nice Annelerin Yeşil Diyarı’ndan kaçırılır ve Savaş Lordu Dementus liderliğindeki büyük bir Motorcu Sürüsü\'nün eline düşer. Çorak Topraklar\'da ilerlerken Ölümsüz Joe\'nun başkanlık ettiği Kale\'ye gelirler. İki diktatör egemenlik için savaşır. Bu sırada Furiosa, eve dönüş yolunu bulmaya çalışırken birçok zorluğu aşmak zorunda kalır.Genç Furiosa, dünya çökerken Nice Annelerin Yeşil Diyarı’ndan kaçırılır ve Savaş Lordu Dementus liderliğindeki büyük bir Motorcu Sürüsü\'nün eline düşer. Çorak Topraklar\'da ilerlerken Ölümsüz Joe\'nun başkanlık ettiği Kale\'ye gelirler. İki diktatör egemenlik için savaşır. Bu sırada Furiosa, eve dönüş yolunu bulmaya çalışırken birçok zorluğu aşmak zorunda kalır.', 'Aksiyon,Macera,Aksiyon & Macera,Bilim-Kurgu', '2024-05-22', '148min', 'https://image.tmdb.org//t/p/original/n1AkCpSi2KylD97xf1PUur3YJRk.jpg', 'https://image.tmdb.org//t/p/original/wNAhuOZ3Zf84jCIlrcI6JhgmY5q.jpg', 'https://www.youtube.com/watch?v=XJMuhwVlca4', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (80, 10591, 'Komşu Kızı', 'Matthew, politikaya atılmak isteyen 18 yaşında bir gençtir. Bitirmek üzere olduğu okuluna konsantre olduğu için, sosyal yaşamı neredeyse yok gibidir. Bir gün masum görünüşlü güzel karşı komşusu Danielle ile tanışan Matthew\'in hayatı birden bire değişir. İkili bir birine aşık olur ve hayal gibi bir ilişki başlar. Fakat Danielle\'in geçmişi sanıldığı gibi masum değildir. Matthew, bütün şehirle birlikte, genç kızın bir dönem porno yıldızı olduğunu keşfeder. Kurduğu mükemmel yaşantı derinden sarsılan Matthew, Danielle\'in geçmişte bıraktığı masumiyetini yeniden kazanmasına yardımcı olurken, Danielle\'de Matthew\'un kabuğundan çıkarak yaşamı keşfetmesini sağlayacaktır.Matthew, politikaya atılmak isteyen 18 yaşında bir gençtir. Bitirmek üzere olduğu okuluna konsantre olduğu için, sosyal yaşamı neredeyse yok gibidir. Bir gün masum görünüşlü güzel karşı komşusu Danielle ile tanışan Matthew\'in hayatı birden bire değişir. İkili bir birine aşık olur ve hayal gibi bir ilişki başlar. Fakat Danielle\'in geçmişi sanıldığı gibi masum değildir. Matthew, bütün şehirle birlikte, genç kızın bir dönem porno yıldızı olduğunu keşfeder. Kurduğu mükemmel yaşantı derinden sarsılan Matthew, Danielle\'in geçmişte bıraktığı masumiyetini yeniden kazanmasına yardımcı olurken, Danielle\'de Matthew\'un kabuğundan çıkarak yaşamı keşfetmesini sağlayacaktır.', 'Romantik,Komedi', '2004-04-09', '110min', 'https://image.tmdb.org//t/p/original/nc2NfaHxVhm6cxRyxgRoX5qETG6.jpg', 'https://image.tmdb.org//t/p/original/hC9QftCUwQxgOoYrO6TwQ3Qr3HH.jpg', 'https://www.youtube.com/watch?v=0rD3Qkh-238', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (81, 20453, '3 Aptal', 'Hindistan’da mühendislik okuyan Farhan, bu bölüme ailesinin zoruyla girmiştir. Farhan\'ın asıl arzusu ise fotoğrafçılık eğitimi almaktır. Oda arkadaşı Raju ise fakir bir ailede büyümüş, bir an önce mesleğini eline alıp onlara bakmak için çırpınan bir mühendis adayıdır. Odalarına gelen Rancho (Aamir Khan) ise her ikisinden de tamamen farklı, tuhaf ve bir o kadar da zeki bir çocuktur. Birbirlerinin en yakın arkadaşı haline gelen Farhan, Raju ve Rancho, Rancho’nun içinde bulunduğu okulu ve eğitim sistemini değiştirme çabalarının sonucunda okulun diktatör hocası “Virus”ün görüş alanına girerler. Kendilerine ve tüm okula ilham olan, herkesten farklı düşünen ve sistemi değiştirmenin mümkün olduğunu savunan Rancho, mezun olduktan sonra ortadan kaybolur. Rancho’yu bulmak için yıllar sonra yollara düşen Farhan ve Raju, bu yolculuklarında Rancho’nun şaşırtıcı hikâyesine tanık olacaktır.Hindistan’da mühendislik okuyan Farhan, bu bölüme ailesinin zoruyla girmiştir. Farhan\'ın asıl arzusu ise fotoğrafçılık eğitimi almaktır. Oda arkadaşı Raju ise fakir bir ailede büyümüş, bir an önce mesleğini eline alıp onlara bakmak için çırpınan bir mühendis adayıdır. Odalarına gelen Rancho (Aamir Khan) ise her ikisinden de tamamen farklı, tuhaf ve bir o kadar da zeki bir çocuktur. Birbirlerinin en yakın arkadaşı haline gelen Farhan, Raju ve Rancho, Rancho’nun içinde bulunduğu okulu ve eğitim sistemini değiştirme çabalarının sonucunda okulun diktatör hocası “Virus”ün görüş alanına girerler. Kendilerine ve tüm okula ilham olan, herkesten farklı düşünen ve sistemi değiştirmenin mümkün olduğunu savunan Rancho, mezun olduktan sonra ortadan kaybolur. Rancho’yu bulmak için yıllar sonra yollara düşen Farhan ve Raju, bu yolculuklarında Rancho’nun şaşırtıcı hikâyesine tanık olacaktır.', 'Dram,Komedi,Hint', '2009-12-23', '171min', 'https://image.tmdb.org//t/p/original/2Zpa6RG9t2qvKHcVJlpgsb4LOP5.jpg', 'https://image.tmdb.org//t/p/original/u7kuUaySqXBVAtqEl9vkTkAzHV9.jpg', 'https://www.youtube.com/watch?v=xvszmNXdM4w', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (83, 297222, 'PK', 'P.K. bi şehirdeki yabancının düşünceler komedisidir. P.K.(Aamir Khan) Daha önce kimsenin sormadığı sorular sorar. Bunlar masum, çocuk gibi sorulardır ama cevapları enteresandır.P.K.\'in masum gözlerini gören insanlar kendi monoton hayatlarını gözden geçirirler.P.K.\'in sadık arkadaşları ve dostları olur. Kırık kalpleri düzeltir öfkeleri dindirir. P.K.\'in çocuksu merakı kendisi ve milyonlarca insan için manevi bir yolculuğa dönüşür.Film karmaşık felsefelerin iddialı ve benzersiz yönlerini orijinal bi şekilde ortaya koyuyor. Ayrıca basit, kahkaha dolu, insani bir aşk masalı da süregidiyor. Sonuç olarak ayrı dünyalardan gelen yabancılar arasında dostluk destanı işlenmiş diyebiliriz.', 'Dram,Komedi,Bilim-Kurgu,Hint', '2014-12-18', '153min', 'https://image.tmdb.org//t/p/original/wGAMZ5DgfqAGsJ4EzXlm23vCGb1.jpg', 'https://image.tmdb.org//t/p/original/gxfvtq5eYiClS2X7hxAAPBNrbWA.jpg', '', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (84, 9738, 'Fantastik Dörtlü', 'Kozmik ışınlara maruz kalmalarıyla süper kahraman haline gelen grupta, kurucu Reed Richards vücudunu değişik şekillere sokabilmektedir. Kız arkadaşı, Sue Storm, görünmez olabilmektedir. Johnny Storm ateşi kontrol edebilmektedir. Pilot Ben Grimm ise süper güçlü bir taştan bir adama dönüşmüştür. Süper güçlerini bir araya getiren grup Doktor Doom\'un kötülüklerine karşı koymaya çalışmaktadırlar...Kozmik ışınlara maruz kalmalarıyla süper kahraman haline gelen grupta, kurucu Reed Richards vücudunu değişik şekillere sokabilmektedir. Kız arkadaşı, Sue Storm, görünmez olabilmektedir. Johnny Storm ateşi kontrol edebilmektedir. Pilot Ben Grimm ise süper güçlü bir taştan bir adama dönüşmüştür. Süper güçlerini bir araya getiren grup Doktor Doom\'un kötülüklerine karşı koymaya çalışmaktadırlar...', 'Fantastik Dörtlü Serisi', '2005-06-29', '100min', 'https://image.tmdb.org//t/p/original/5zG07ExIrWtZoxWlMOyhBszWAwf.jpg', 'https://image.tmdb.org//t/p/original/nDYz0HDfEiNVCBwhCDay8Ud0n7M.jpg', 'https://www.youtube.com/watch?v=QIx2jkXYu34', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (85, 1979, 'Fantastik Dörtlü: Gümüş Sörfçü\'nün Yükselişi', 'Marvel uyarlamaları birer birer beyazperdeyi doldurdu da, artık sıra devam filmlerine bile geldi. En sevilen çizgi romalardan biri olan Fantastik Dörtlü, ikinci filmde yine tam gaz maceralarına devam ediyor.Bu devam filminin en sevindirici yanı ise, en gözde kahramanlardan biri olan Silver Surfer (Gümüş Sörfçü)\'ın karşımıza gelecek olması. Dünyadaki tek süper güç olmadıklarının iyice farkında varmak zorunda kalan kahramanlarımız, süper gücü ve inanılmaz bir hızla uçma yeteneği olan Silver Surfer ve dünyayı yok etmek isteyen Galactus ile tanışırlar.Dünyayı yok etmek isteyen bu ikiliyi durdurabilecek tek güç olan Fantastik Dörtlü, yine zor ve heyecan dolu bir macera ile karşı karşıyadır.Marvel uyarlamaları birer birer beyazperdeyi doldurdu da, artık sıra devam filmlerine bile geldi. En sevilen çizgi romalardan biri olan Fantastik Dörtlü, ikinci filmde yine tam gaz maceralarına devam ediyor.Bu devam filminin en sevindirici yanı ise, en gözde kahramanlardan biri olan Silver Surfer (Gümüş Sörfçü)\'ın karşımıza gelecek olması. Dünyadaki tek süper güç olmadıklarının iyice farkında varmak zorunda kalan kahramanlarımız, süper gücü ve inanılmaz bir hızla uçma yeteneği olan Silver Surfer ve dünyayı yok etmek isteyen Galactus ile tanışırlar.Dünyayı yok etmek isteyen bu ikiliyi durdurabilecek tek güç olan Fantastik Dörtlü, yine zor ve heyecan dolu bir macera ile karşı karşıyadır.', 'Fantastik Dörtlü Serisi', '2007-06-13', '92min', 'https://image.tmdb.org//t/p/original/b704jZVgUWzxrtxd5UA7d6lGMLe.jpg', 'https://image.tmdb.org//t/p/original/7ff2FyFmskEFfmXHkxuqVr47DiG.jpg', 'https://www.youtube.com/watch?v=ZN7PWE2dyAY', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (87, 166424, 'Fantastik Dörtlü', 'Film, dört aykırı gencin, alternatif ve aynı zamanda tehlikeli bir boyuta ışınlanmasıyla, olağanüstü bir fiziksel değişime uğramalarını konu alıyor. Alt üst olan hayatlarını yoluna sokup, yeni yeteneklerini kullanarak bir takım olarak hareket etmeyi öğrenmeli ve dünyayı tehdit eden eski dostlarına karşı gelmeliler.Film, dört aykırı gencin, alternatif ve aynı zamanda tehlikeli bir boyuta ışınlanmasıyla, olağanüstü bir fiziksel değişime uğramalarını konu alıyor. Alt üst olan hayatlarını yoluna sokup, yeni yeteneklerini kullanarak bir takım olarak hareket etmeyi öğrenmeli ve dünyayı tehdit eden eski dostlarına karşı gelmeliler.', 'Fantastik Dörtlü Serisi', '2015-08-05', '100min', 'https://image.tmdb.org//t/p/original/xDGgIWDNSypqDIwZpt2Vn0BCLK1.jpg', 'https://image.tmdb.org//t/p/original/or5kDR8Ve3TtuPSdEf1X5NdQHyz.jpg', 'https://www.youtube.com/watch?v=_flR9_6msik', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (88, 479718, 'Haydutlar', '2004 yılında gerçek olaylara dayanarak yapılmış olan filmde, Çin\'den Güney Kore\'ye göç edip yerleşen insanların belirli bölgelerde mahalle kurması ile birlikte bu bölgelerde Çinlilerin çeteler oluşturması ve Çin\'den gelen Çetelerin bölge savaşını ele almaktadır. Polis ekiplerinin yerel halkın yardımıyla mahalleye huzur getirmeye çalışılmaktadır.', 'Aksiyon,Aksiyon & Macera,Gerilim,Suç', '2017-10-03', '121min', 'https://image.tmdb.org//t/p/original/ayk6y2D5v5VACFqrPfF05MARZ9n.jpg', 'https://image.tmdb.org//t/p/original/xord8lZ7mK8ctki6FBgNYrbpWCO.jpg', 'https://www.youtube.com/watch?v=UbLzMUbiMmY', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (89, 2105, 'Amerikan Pastası', 'Kızlara nasıl yaklaşacaklarını bilmeyen 4 delikanlı, bu konularda daha tecrübeli dört genç kız ve pasta alır. Yılın en komik filmlerinden biri olmaya aday olan film aynı zamanda pastayı seks aracı olarak da kullanan ilk film.Kızlara nasıl yaklaşacaklarını bilmeyen 4 delikanlı, bu konularda daha tecrübeli dört genç kız ve pasta alır. Yılın en komik filmlerinden biri olmaya aday olan film aynı zamanda pastayı seks aracı olarak da kullanan ilk film.', 'Romantik,Komedi', '1999-07-09', '95min', 'https://image.tmdb.org//t/p/original/pNzarHZjSGo6NgotluiAG3U2nwy.jpg', 'https://image.tmdb.org//t/p/original/z9DFGaWj4G4kZUWLZ6ESs1NP1Fp.jpg', 'https://www.youtube.com/watch?v=Sithad108Og', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (90, 2770, 'Amerikan Pastası 2', 'Sevdiğiniz karakterler geri döndü! Amerikan Pastası ölümsüzleştıren mezuniyet balosundan 1 yıl sonra tüm ekıp tam takım yaz için yeniden bir arada. Bu sefer, sakin görünümlü bir sahil evi, çılgın partilerin merkezine dönüşecek. 5 erkek arkadaşlığın ne kadar güçlü bir birleştirici olduğunu keşfedecek... ve bir de Süper Yapıştırıcının. 5 kız aşkın gizemini öğrenecek... ve Üç Kuralını. İlerleyen saatlerde bando kampı beklenmedik bir ziyaretçiyle hareketli saatler yaşayacak ve bu yaz tatili herkes için unutulmaz olacak!Sevdiğiniz karakterler geri döndü! Amerikan Pastası ölümsüzleştıren mezuniyet balosundan 1 yıl sonra tüm ekıp tam takım yaz için yeniden bir arada. Bu sefer, sakin görünümlü bir sahil evi, çılgın partilerin merkezine dönüşecek. 5 erkek arkadaşlığın ne kadar güçlü bir birleştirici olduğunu keşfedecek... ve bir de Süper Yapıştırıcının. 5 kız aşkın gizemini öğrenecek... ve Üç Kuralını. İlerleyen saatlerde bando kampı beklenmedik bir ziyaretçiyle hareketli saatler yaşayacak ve bu yaz tatili herkes için unutulmaz olacak!', 'Romantik,Komedi', '2001-08-10', '108min', 'https://image.tmdb.org//t/p/original/rhrJDGzCa3NewpPqHewbJ7KPeVd.jpg', 'https://image.tmdb.org//t/p/original/uKiMpSGhKHDfZ7TwNfVFDLwvNRR.jpg', 'https://www.youtube.com/watch?v=ntxIBzJ0tU8', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (91, 8273, 'Amerikan Pastası: Düğün', 'American Pie serisinin üçüncü filminde evlenmeye karar veren Jim ve Michelle Jim\'in ağır hasta olan büyükannesinin düğünlerini görebilmesi için düğün hazırlıklarını iki haftada tamamlamaya çalışırlar. Stifler\'ın ebeveynleri onun ısrarları sayesinde yeniden evlenmeye karar verirler; Finch ise bu evliliğe engel olmaya çalışır. Bu arada Finch ile birlikte Jim için büyük bir bekarlığa veda partisi planlayan Stifler ise Michelle\'in kız kardeşi Cadence ile yakınlaşır. Partiden sonraki sabah uzak bir kasabada terkedilmiş bir depoda uyanan Jim düğününe vaktinde yetişmek zorundadır...American Pie serisinin üçüncü filminde evlenmeye karar veren Jim ve Michelle Jim\'in ağır hasta olan büyükannesinin düğünlerini görebilmesi için düğün hazırlıklarını iki haftada tamamlamaya çalışırlar. Stifler\'ın ebeveynleri onun ısrarları sayesinde yeniden evlenmeye karar verirler; Finch ise bu evliliğe engel olmaya çalışır. Bu arada Finch ile birlikte Jim için büyük bir bekarlığa veda partisi planlayan Stifler ise Michelle\'in kız kardeşi Cadence ile yakınlaşır. Partiden sonraki sabah uzak bir kasabada terkedilmiş bir depoda uyanan Jim düğününe vaktinde yetişmek zorundadır...', 'Romantik,Komedi', '2003-08-01', '103min', 'https://image.tmdb.org//t/p/original/d5Kd0BOmc4huq5pru69tCdAOBHI.jpg', 'https://image.tmdb.org//t/p/original/qW703anWHFXulRTKWOckAg9i70K.jpg', 'https://www.youtube.com/watch?v=YmIIHsPa2F8', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (92, 8274, 'Amerikan Pastası: Bando Kampı', 'Stifler’ın erkek kardeşi Matt yaz tatilini bir bando kampında geçirmekle cezalandırılır. Türlü anormalliklerin yaşandığı bando kampı Matt’in gizli kameraları ve seksi danışmanları yüzünden tam bir karnavala dönüşür.Stifler’ın erkek kardeşi Matt yaz tatilini bir bando kampında geçirmekle cezalandırılır. Türlü anormalliklerin yaşandığı bando kampı Matt’in gizli kameraları ve seksi danışmanları yüzünden tam bir karnavala dönüşür.', 'Komedi', '2005-10-31', '94min', 'https://image.tmdb.org//t/p/original/nifAHIwFMq01lxciJXJ6Oqj9Xbt.jpg', 'https://image.tmdb.org//t/p/original/TWchvpMO36QZTIiNjFBm4MYsmQ.jpg', 'https://www.youtube.com/watch?v=ORLDIRIENXY', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (93, 8275, 'Amerikan Pastası: Çıplak Yol', 'Erik Stifler, Stifler ailesinin liseden bakir mezun olan tek üyesi olmak üzere olduğunu fark eder ve bu geleneği bozmak adına elinden geleni yapmaya karar verir. Jim’in babasından (Eugene Levy) alınmış bir dizi iyi niyetli tavsiyenin ardından Erik, şansını her yıl düzenlenen ve son derece rezil olan Çıplak Yol yarışlarında denemeye karar verir.Erik Stifler, Stifler ailesinin liseden bakir mezun olan tek üyesi olmak üzere olduğunu fark eder ve bu geleneği bozmak adına elinden geleni yapmaya karar verir. Jim’in babasından (Eugene Levy) alınmış bir dizi iyi niyetli tavsiyenin ardından Erik, şansını her yıl düzenlenen ve son derece rezil olan Çıplak Yol yarışlarında denemeye karar verir.', 'Komedi', '2006-12-01', '97min', 'https://image.tmdb.org//t/p/original/aGsPsZ0ysqV0T03GIgnY2OpCe50.jpg', 'https://image.tmdb.org//t/p/original/9IUZw1blAscYnyFi5vEFlHVXAWr.jpg', 'https://www.youtube.com/watch?v=tkU2pjpt0Eo', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (94, 8277, 'Amerikan Pastası: Parti Evi', 'Pastanın en müstehcen dilimi! Sansürsüz! Parti devam ediyor... Amerikan Pastası Sunar Parti Evi\'yle, kolej tarihinin en eğlenceli ve seksi yılını geçirmeye hazırlanın. Dwight Stifler, kuzeni Erik, Mr. Levenstein ve birbirinden rezil Beta House öğrencileri, pastanın en seksi, en vahşi ve en yeni diliminde sizi kahkahalara boğmak üzere biraraya geliyor.Pastanın en müstehcen dilimi! Sansürsüz! Parti devam ediyor... Amerikan Pastası Sunar Parti Evi\'yle, kolej tarihinin en eğlenceli ve seksi yılını geçirmeye hazırlanın. Dwight Stifler, kuzeni Erik, Mr. Levenstein ve birbirinden rezil Beta House öğrencileri, pastanın en seksi, en vahşi ve en yeni diliminde sizi kahkahalara boğmak üzere biraraya geliyor.', 'Komedi', '2007-12-26', '89min', 'https://image.tmdb.org//t/p/original/3KAquDqsDUqBJUypUn6B6g1wHQc.jpg', 'https://image.tmdb.org//t/p/original/qSx994cBgJ2jgc5Gx4hc3QjtJP0.jpg', 'https://www.youtube.com/watch?v=Sp-R7u6XJPs', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (95, 26123, 'Amerikan Pastası: Aşk Kitabı', 'İlk american pastası filminden on yıl sonra üc talihsiz bakire erkek, okul kütüphanesinde gezerken okulun kutsal kitabı sayılan aşk kitabını bulurlar. Başta buna çok sevinirler ama kitap oldukça yıpranmış, eksik öğütler içermekte ve anlaşılmamaktadır.İlk american pastası filminden on yıl sonra üc talihsiz bakire erkek, okul kütüphanesinde gezerken okulun kutsal kitabı sayılan aşk kitabını bulurlar. Başta buna çok sevinirler ama kitap oldukça yıpranmış, eksik öğütler içermekte ve anlaşılmamaktadır.', 'Komedi', '2009-12-07', '93min', 'https://image.tmdb.org//t/p/original/ok69KVYnzWpwYrQykKfGWaPpy8.jpg', 'https://image.tmdb.org//t/p/original/vVpPX97LFI19u56tgEP5eObqgBx.jpg', 'https://www.youtube.com/watch?v=SWYLgOrrsno', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (96, 71552, 'Amerikan Pastası: Buluşma', 'Komedi içerikli American Reunion, bütün tanıştığımız American Pie karakterlerinin lise döneminde birleştikleri 10 yıl önce East Great Falls’a dönüşlerinden daha fazlasını içeriyor.  Uzun geçirilmiş hafta sonunda hayatlarındaki değişmeleri ve bu zaman ve mesafenin aralarındaki dostluk bağını kıramadığını keşfediyorlar. 1999 yazında küçük kasaba Michigan’nın dört erkeği bekaretlerini kaybetmek için arayışa başlamıştı. Yıllar geçtiğinde Jim ve Michelle evlenirken Kevin ve Vicky hoşça kal dedi. Oz ve Heather ayrı büyüdüler fakat Frinch, hala Stifler’in annesini arzu ediyor.  Şimdi de bu uzun ömürlü arkadaşlar, komedi efsanelerinin başlangıcı hormonsal gençliklerinin üzerine yetişkin hatıraları gibi geri geldiler.Komedi içerikli American Reunion, bütün tanıştığımız American Pie karakterlerinin lise döneminde birleştikleri 10 yıl önce East Great Falls’a dönüşlerinden daha fazlasını içeriyor.  Uzun geçirilmiş hafta sonunda hayatlarındaki değişmeleri ve bu zaman ve mesafenin aralarındaki dostluk bağını kıramadığını keşfediyorlar. 1999 yazında küçük kasaba Michigan’nın dört erkeği bekaretlerini kaybetmek için arayışa başlamıştı. Yıllar geçtiğinde Jim ve Michelle evlenirken Kevin ve Vicky hoşça kal dedi. Oz ve Heather ayrı büyüdüler fakat Frinch, hala Stifler’in annesini arzu ediyor.  Şimdi de bu uzun ömürlü arkadaşlar, komedi efsanelerinin başlangıcı hormonsal gençliklerinin üzerine yetişkin hatıraları gibi geri geldiler.', 'Komedi', '2012-04-04', '113min', 'https://image.tmdb.org//t/p/original/A96jLOgxLucYvX37mvywcmcQGVA.jpg', 'https://image.tmdb.org//t/p/original/xr3a08OeCkSHwOUvJrOngQSlrC2.jpg', 'https://www.youtube.com/watch?v=1akixU65dDY', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (97, 660982, 'Amerikan Pastası: Kızların Kuralları', 'Liseli gençler, ebeveynlerinden kurtulmak, ihtiyaçlarını, arzularını gidermek ve doyasıya eğlenmek için bir parti düzenlerler… Fakat bu parti onlar için pekte iyi sonuçlanmayacaktır.Liseli gençler, ebeveynlerinden kurtulmak, ihtiyaçlarını, arzularını gidermek ve doyasıya eğlenmek için bir parti düzenlerler… Fakat bu parti onlar için pekte iyi sonuçlanmayacaktır.', 'Komedi', '2020-10-06', '95min', 'https://image.tmdb.org//t/p/original/xqvX5A24dbIWaeYsMTxxKX5qOfz.jpg', 'https://image.tmdb.org//t/p/original/75ooojtgiKYm5LcCczbCexioZze.jpg', 'https://www.youtube.com/watch?v=fGjfQjIKWkw', 1, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (98, 96721, 'Zafere Hücum', '1976 yılında gerçekleşen Alman Grand Prix yarışında Niki Lauda\'nın kullandığı Ferrari ikinci round\'un sonunda yaşadığı bir sorun nedeniyle yarış dışı kalır ve birincilik ezeli rakibi James Hunt\'a gider. Bu kaza sonrasında Lauda yaralanır; aradan geçen altı haftanın ardından olağan hırsı ve öfkesiyle pistlere geri döner. İki yarışçı arasında italyan Grand Prix\'i ile başlayan mücadele diğer yarışlarda katlanarak devam eder. Hedef dünya şampiyonluğudur...  Avusturyalı F1 yarışcısı Niki Lauda ve İngiliz rakibi James Hunt arasındaki dillere destan rekabeti konu alan film, Formula 1\'in altın döneminde, 1970\'lerde geçiyor.1976 yılında gerçekleşen Alman Grand Prix yarışında Niki Lauda\'nın kullandığı Ferrari ikinci round\'un sonunda yaşadığı bir sorun nedeniyle yarış dışı kalır ve birincilik ezeli rakibi James Hunt\'a gider. Bu kaza sonrasında Lauda yaralanır; aradan geçen altı haftanın ardından olağan hırsı ve öfkesiyle pistlere geri döner. İki yarışçı arasında italyan Grand Prix\'i ile başlayan mücadele diğer yarışlarda katlanarak devam eder. Hedef dünya şampiyonluğudur...  Avusturyalı F1 yarışcısı Niki Lauda ve İngiliz rakibi James Hunt arasındaki dillere destan rekabeti konu alan film, Formula 1\'in altın döneminde, 1970\'lerde geçiyor.', '', '2013-09-02', '123min', 'https://image.tmdb.org//t/p/original/kHlUDPGyJ1INaDogTyUJJOLJObN.jpg', 'https://image.tmdb.org//t/p/original/caKZWDGmv5iW2U99skHs75MmOmU.jpg', 'https://www.youtube.com/watch?v=9ZJqxgR-5Xc', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (99, 8769, 'Katil Araba', 'Filmde ünlü yıldız Keith Gordon Arnie rolündedir. Filmin başlangıcı 1958 yılında geçmektedir. Plymouth Furry fabrikasında arabalar üretilmektedir. İşçilerden biri oradaki arabalardan birinin kaportasında elini kıstırmış, diğer bir işçi aynı arabanın içinde boğularak ölmüştür. Yıl 1978′de Arnie isimli bir genç bu arabayı bir arazide görmüştür. Arabanın sahibi George LeBay arabanın adının Christine olduğunu söylemiştir. George LeBay’ın kardeşi bu arabayı 1957 yılının Eylül ayında almıştır. Christine o yıllardan bu yıla tam 93.475 kilometre yapmış bir arabadır.', 'Korku', '1983-12-09', '110min', 'https://image.tmdb.org//t/p/original/bWi3Cjg8gkf5h3xgU91CVtxkjUc.jpg', 'https://image.tmdb.org//t/p/original/xgmRZBt1JMfvsP5dz3wM4lUW1Fc.jpg', 'https://www.youtube.com/watch?v=wMoHFqV3aX8', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (100, 39001, 'My Teacher\'s Wife', '', 'Romantik,Komedi', '1999-11-10', '89min', 'https://image.tmdb.org//t/p/original/4esN7mSfMoDUF9Y3fWP0TeUvZW4.jpg', 'https://image.tmdb.org//t/p/original/nKXnTdrdNjTk8TxEfngNCNwDWFT.jpg', 'https://www.youtube.com/watch?v=dUu9tCTBiLw', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (101, 487297, 'Erkekler Ne İster', 'Başarılı spor menajeri Ali Davis, kadın olduğu için erkek meslektaşları tarafından sürekli dışlanmaktadır. Patronundan da beklediği terfiyi alamayınca, erkeklerin dünyasında başarılı olmak için ne yapması gerektiğini sorgulamaya başlar. Hatasını anlamaya çalışmak için bir falcıya giden ve orada bitki çayı içen Ali, ertesi sabaha uyandığına erkeklerin düşüncelerini okuyabildiğini fark eder.', 'Romantik,Komedi', '2019-02-08', '117min', 'https://image.tmdb.org//t/p/original/6mm9XCL7A6zthX0Fd5ikkLoCUC1.jpg', 'https://image.tmdb.org//t/p/original/pmVBOsh8TBvvtFKIo6QS5dE6tTs.jpg', 'https://www.youtube.com/watch?v=HeoLiTirRp4', 0, 0, 1, 1);
INSERT INTO `movies` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `runtime`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (102, 399566, 'Godzilla vs. Kong', 'Ezelî bir düşmanlık iki efsanevi yaratığı karşı karşıya getirirken bilinmeyen bölgelere yapılan bir keşif görevi, Titanların kökenlerine ilişkin gizemleri açığa çıkarır.', 'Aksiyon,Macera,Aksiyon & Macera,Bilim-Kurgu', '2021-03-24', '114min', 'https://image.tmdb.org//t/p/original/pgqgaUx1cJb5oZQQ5v0tNARCeBp.jpg', 'https://image.tmdb.org//t/p/original/mGJuQwMq1bEboaVTqQAK4p4zQvC.jpg', 'https://www.youtube.com/watch?v=odM92ap8_c0', 0, 0, 1, 1);


#
# TABLE STRUCTURE FOR: networks
#

DROP TABLE IF EXISTS `networks`;

CREATE TABLE `networks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `logo` text NOT NULL,
  `networks_order` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `networks` (`id`, `name`, `logo`, `networks_order`, `status`) VALUES (1, 'Netflix', 'https://film.dizipro3.gen.tr/netflix.png', 1, 1);
INSERT INTO `networks` (`id`, `name`, `logo`, `networks_order`, `status`) VALUES (2, 'AMAZON', 'https://turktorrent.us/data/torrents/category_images/86.png', 2, 1);


#
# TABLE STRUCTURE FOR: report
#

DROP TABLE IF EXISTS `report`;

CREATE TABLE `report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` text NOT NULL,
  `description` longtext NOT NULL,
  `report_type` int(11) NOT NULL COMMENT '0=Custom, 1=Movie, 2=Web Series, 3=Live TV',
  `status` int(11) NOT NULL COMMENT '0=Pending, 1=Solved, 2=Canceled',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: request
#

DROP TABLE IF EXISTS `request`;

CREATE TABLE `request` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` text NOT NULL,
  `description` longtext NOT NULL,
  `type` int(11) NOT NULL COMMENT '0=Custom, 1=Movie, 2=Web Series, 3=Live TV',
  `status` int(11) NOT NULL COMMENT '0=Pending, 1=Accepted, 2=Rejected',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: search_list
#

DROP TABLE IF EXISTS `search_list`;

CREATE TABLE `search_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `search_text` text NOT NULL,
  `movies_found` int(11) NOT NULL,
  `web_series_found` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (1, 'marifet', 0, 0, 1726104043);
INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (2, 'marife', 0, 0, 1726104046);
INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (3, 'marif', 0, 0, 1726104046);
INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (4, 'mari', 0, 0, 1726104047);
INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (5, 'Garfield', 1, 0, 1726329689);
INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (6, 'joke', 1, 0, 1728185949);
INSERT INTO `search_list` (`id`, `search_text`, `movies_found`, `web_series_found`, `timestamp`) VALUES (7, 'joker', 1, 0, 1728185949);


#
# TABLE STRUCTURE FOR: subscription
#

DROP TABLE IF EXISTS `subscription`;

CREATE TABLE `subscription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `time` int(11) NOT NULL COMMENT 'Days',
  `amount` int(11) NOT NULL,
  `currency` int(11) NOT NULL COMMENT '0=INR,1=USD',
  `background` text NOT NULL,
  `subscription_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=Remove Ads, 2=Play Premium, 3=Download Premium',
  `status` int(11) NOT NULL COMMENT '0=UnPublished, 1=Published',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

#
# TABLE STRUCTURE FOR: subscription_log
#

DROP TABLE IF EXISTS `subscription_log`;

CREATE TABLE `subscription_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `amount` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `subscription_start` date NOT NULL,
  `subscription_exp` date NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

#
# TABLE STRUCTURE FOR: subtitles
#

DROP TABLE IF EXISTS `subtitles`;

CREATE TABLE `subtitles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `content_type` int(11) NOT NULL COMMENT '1=Movie, 2=WebSeries',
  `language` text NOT NULL,
  `subtitle_url` text NOT NULL,
  `mime_type` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `subtitles` (`id`, `content_id`, `content_type`, `language`, `subtitle_url`, `mime_type`, `status`) VALUES (1, 3, 1, 'TR', 'film.dizipro3.gen.tr/Garfield.2024.srt', 'WebVTT', 1);
INSERT INTO `subtitles` (`id`, `content_id`, `content_type`, `language`, `subtitle_url`, `mime_type`, `status`) VALUES (2, 38, 1, 'TR', 'https://rfg8rqh7cor1.cdn-jupiter.com/vtt/01/04953/st4q6vebxudc_eng.vtt', 'WebVTT', 1);
INSERT INTO `subtitles` (`id`, `content_id`, `content_type`, `language`, `subtitle_url`, `mime_type`, `status`) VALUES (3, 60, 1, 'TR', 'http://appp.dizipro3.gen.tr/uploads/Gelece%C4%9FeD%C3%B6n%C3%BC%C5%9F1.srt', 'WebVTT', 1);
INSERT INTO `subtitles` (`id`, `content_id`, `content_type`, `language`, `subtitle_url`, `mime_type`, `status`) VALUES (4, 156, 2, 'TR', 'https://uvsyulgjoz8v.cdn-jupiter.com/vtt/01/05071/zpvvx5zloobk_tur.vtt', 'WebVTT', 1);
INSERT INTO `subtitles` (`id`, `content_id`, `content_type`, `language`, `subtitle_url`, `mime_type`, `status`) VALUES (5, 156, 2, 'TR1', 'https://ap.dizipro3.gen.tr/TulsaKing1x1.vtt', 'WebVTT', 1);


#
# TABLE STRUCTURE FOR: upcoming_contents
#

DROP TABLE IF EXISTS `upcoming_contents`;

CREATE TABLE `upcoming_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tmdb_id` int(11) NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `poster` text NOT NULL,
  `trailer_url` text NOT NULL,
  `release_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `type` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `upcoming_contents` (`id`, `tmdb_id`, `name`, `description`, `poster`, `trailer_url`, `release_date`, `type`, `status`) VALUES (1, 698687, 'Transformers: BaÅŸlangÄ±Ã§', 'Yeminli dÃ¼ÅŸmanlar olarak bilinen, ama bir zamanlar kardeÅŸ gibi birbirine baÄŸlÄ± dostlar olan ve Cybertron\'un kaderini sonsuza dek deÄŸiÅŸtiren Optimus Prime ve Megatron\'un anlatÄ±lmamÄ±ÅŸ kÃ¶ken hikayesi.', 'https://www.themoviedb.org/t/p/originalhttps://image.tmdb.org//t/p/original/xR5U1C9XMOBHdkQBscFxx06LimZ.jpg', 'https://www.youtube.com/watch?v=5a09yJU-mCI', '2024-09-11 00:00:00', 1, 1);


#
# TABLE STRUCTURE FOR: user_db
#

DROP TABLE IF EXISTS `user_db`;

CREATE TABLE `user_db` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `role` int(11) NOT NULL DEFAULT 0 COMMENT '0=User, 1=Admin, 2=SubAdmin, 3=Manager, 4=Editor',
  `active_subscription` text NOT NULL,
  `subscription_type` int(11) NOT NULL DEFAULT 0 COMMENT '0=Default, 1=Remove Ads, 2=Play Premium, 3=Download Premium',
  `time` int(11) NOT NULL DEFAULT 0,
  `amount` int(11) NOT NULL DEFAULT 0,
  `subscription_start` text NOT NULL,
  `subscription_exp` text NOT NULL,
  `device_id` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `user_db` (`id`, `name`, `email`, `password`, `role`, `active_subscription`, `subscription_type`, `time`, `amount`, `subscription_start`, `subscription_exp`, `device_id`) VALUES (1, 'berat', 'beratapo12@gmail.com', '94faf91ced3043d9738ed92f354f23d1', 1, 'free', 0, 0, 0, '', '', '');
INSERT INTO `user_db` (`id`, `name`, `email`, `password`, `role`, `active_subscription`, `subscription_type`, `time`, `amount`, `subscription_start`, `subscription_exp`, `device_id`) VALUES (2, 'berat akar', 'denemtest@gmail.com', '25f9e794323b453885f5181f1b624d0b', 0, '', 123, 30, 30, '2024-09-20', '2024-10-20', 'cbec3a82ce3b5767');
INSERT INTO `user_db` (`id`, `name`, `email`, `password`, `role`, `active_subscription`, `subscription_type`, `time`, `amount`, `subscription_start`, `subscription_exp`, `device_id`) VALUES (3, 'AKAR BERAT TV', 'adanmerkez13@gmail.com', '25f9e794323b453885f5181f1b624d0b', 0, 'Free', 0, 0, 0, '0000-00-00', '0000-00-00', '849e5f91960b3aa4');


#
# TABLE STRUCTURE FOR: view_log
#

DROP TABLE IF EXISTS `view_log`;

CREATE TABLE `view_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` text NOT NULL,
  `content_id` int(11) NOT NULL,
  `content_type` int(11) NOT NULL COMMENT '1=Movie, 2=WebSeries',
  `date` text NOT NULL,
  `time` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (1, 'cbec3a82ce3b5767', 1, 1, '09-10-2024', '05:26:14 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (2, 'cbec3a82ce3b5767', 2, 1, '09-10-2024', '05:40:40 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (3, 'cbec3a82ce3b5767', 3, 1, '09-10-2024', '05:56:44 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (4, 'cbec3a82ce3b5767', 3, 1, '09-10-2024', '06:05:11 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (5, 'cbec3a82ce3b5767', 3, 1, '09-10-2024', '06:05:26 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (6, 'cbec3a82ce3b5767', 4, 1, '09-10-2024', '06:57:13 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (7, 'cbec3a82ce3b5767', 4, 1, '09-10-2024', '07:03:27 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (8, 'cbec3a82ce3b5767', 4, 1, '09-10-2024', '07:06:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (9, 'cbec3a82ce3b5767', 4, 1, '09-10-2024', '07:07:37 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (10, 'cbec3a82ce3b5767', 3, 1, '09-10-2024', '07:08:25 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (11, 'cbec3a82ce3b5767', 1, 1, '09-10-2024', '07:10:01 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (12, 'cbec3a82ce3b5767', 1, 1, '09-10-2024', '07:10:38 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (13, 'cbec3a82ce3b5767', 3, 1, '09-10-2024', '07:44:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (14, 'cbec3a82ce3b5767', 4, 1, '09-10-2024', '08:03:22 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (15, 'cbec3a82ce3b5767', 4, 1, '09-11-2024', '08:53:51 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (16, 'cbec3a82ce3b5767', 2, 1, '09-11-2024', '05:38:26 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (17, 'cbec3a82ce3b5767', 2, 1, '09-11-2024', '06:10:06 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (18, 'cbec3a82ce3b5767', 2, 1, '09-11-2024', '06:10:12 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (19, 'cbec3a82ce3b5767', 2, 1, '09-11-2024', '06:10:14 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (20, 'cbec3a82ce3b5767', 3, 1, '09-11-2024', '06:21:47 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (21, 'cbec3a82ce3b5767', 2, 1, '09-11-2024', '06:21:53 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (22, 'cbec3a82ce3b5767', 4, 1, '09-11-2024', '06:21:57 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (23, 'cbec3a82ce3b5767', 5, 1, '09-11-2024', '06:28:54 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (24, 'cbec3a82ce3b5767', 1, 2, '09-11-2024', '07:03:27 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (25, 'cbec3a82ce3b5767', 5, 1, '09-11-2024', '07:25:58 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (26, 'cbec3a82ce3b5767', 1, 2, '09-11-2024', '07:34:48 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (27, 'cbec3a82ce3b5767', 1, 2, '09-11-2024', '08:01:03 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (28, 'cbec3a82ce3b5767', 4, 1, '09-11-2024', '08:34:26 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (29, 'cbec3a82ce3b5767', 6, 1, '09-12-2024', '03:08:54 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (30, 'cbec3a82ce3b5767', 3, 2, '09-12-2024', '07:34:00 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (31, 'cbec3a82ce3b5767', 1, 2, '09-12-2024', '07:34:14 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (32, 'cbec3a82ce3b5767', 8, 1, '09-12-2024', '07:34:29 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (33, 'cbec3a82ce3b5767', 9, 1, '09-12-2024', '08:09:30 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (34, 'cbec3a82ce3b5767', 9, 1, '09-12-2024', '08:10:23 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (35, 'cbec3a82ce3b5767', 4, 1, '09-13-2024', '03:05:53 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (36, 'cbec3a82ce3b5767', 4, 1, '09-13-2024', '03:07:00 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (37, 'cbec3a82ce3b5767', 4, 2, '09-13-2024', '05:52:50 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (38, 'cbec3a82ce3b5767', 4, 2, '09-13-2024', '05:57:55 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (39, 'cbec3a82ce3b5767', 3, 1, '09-13-2024', '06:54:40 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (40, 'cbec3a82ce3b5767', 5, 2, '09-13-2024', '08:48:01 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (41, 'cbec3a82ce3b5767', 14, 1, '09-14-2024', '07:11:16 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (42, 'cbec3a82ce3b5767', 1, 2, '09-14-2024', '07:18:09 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (43, 'cbec3a82ce3b5767', 14, 1, '09-14-2024', '07:26:14 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (44, 'cbec3a82ce3b5767', 14, 1, '09-14-2024', '07:29:30 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (45, 'cbec3a82ce3b5767', 13, 1, '09-14-2024', '07:32:44 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (46, 'cbec3a82ce3b5767', 14, 1, '09-14-2024', '08:00:15 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (47, 'cbec3a82ce3b5767', 1, 2, '09-14-2024', '08:02:04 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (48, 'cbec3a82ce3b5767', 3, 1, '09-14-2024', '08:28:14 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (49, '2', 14, 1, '09-15-2024', '05:29:35 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (50, '2', 6, 2, '09-15-2024', '06:15:25 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (51, '2', 6, 2, '09-15-2024', '06:16:12 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (52, '2', 7, 2, '09-15-2024', '07:38:04 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (53, '2', 7, 2, '09-15-2024', '07:40:33 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (54, '2', 7, 2, '09-15-2024', '07:41:27 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (55, '2', 6, 2, '09-15-2024', '07:42:21 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (56, '2', 7, 2, '09-15-2024', '07:45:43 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (57, '2', 14, 1, '09-16-2024', '11:58:01 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (58, '2', 6, 2, '09-17-2024', '12:20:34 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (59, '2', 6, 2, '09-17-2024', '12:20:35 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (60, '2', 6, 2, '09-17-2024', '12:21:06 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (61, '2', 8, 2, '09-17-2024', '08:57:13 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (62, '2', 7, 2, '09-17-2024', '08:57:28 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (63, '2', 6, 2, '09-17-2024', '08:58:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (64, '2', 15, 1, '09-17-2024', '10:01:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (65, '2', 9, 2, '09-18-2024', '10:32:12 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (66, '2', 15, 1, '09-18-2024', '07:07:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (67, '2', 6, 2, '09-18-2024', '07:10:49 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (68, '2', 10, 2, '09-19-2024', '11:43:27 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (69, '2', 21, 1, '09-19-2024', '11:55:27 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (70, '2', 24, 1, '09-19-2024', '02:38:13 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (71, '2', 24, 1, '09-19-2024', '02:40:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (72, '2', 24, 1, '09-19-2024', '02:45:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (73, '2', 24, 1, '09-19-2024', '02:46:29 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (74, '2', 5, 1, '09-19-2024', '04:33:43 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (75, '2', 21, 1, '09-19-2024', '04:33:50 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (76, '2', 10, 2, '09-19-2024', '10:07:19 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (77, '2', 1, 2, '09-19-2024', '11:06:18 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (78, '2', 25, 1, '09-19-2024', '11:06:26 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (79, '2', 4, 2, '09-20-2024', '12:02:40 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (80, '2', 4, 2, '09-20-2024', '12:03:07 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (81, '2', 4, 2, '09-20-2024', '12:03:32 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (82, '2', 4, 2, '09-20-2024', '12:11:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (83, '2', 26, 1, '09-20-2024', '12:30:39 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (84, '2', 29, 1, '09-20-2024', '09:04:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (85, '2', 32, 1, '09-20-2024', '10:35:26 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (86, '2', 32, 1, '09-20-2024', '10:47:12 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (87, '2', 6, 1, '09-20-2024', '11:23:25 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (88, '2', 6, 1, '09-20-2024', '11:27:16 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (89, '2', 28, 1, '09-20-2024', '11:29:46 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (90, '2', 22, 1, '09-20-2024', '11:30:01 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (91, '2', 6, 2, '09-20-2024', '11:30:42 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (92, '2', 33, 1, '09-21-2024', '11:06:35 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (93, '2', 33, 1, '09-21-2024', '11:54:04 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (94, '2', 43, 1, '09-21-2024', '01:00:07 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (95, '2', 43, 1, '09-21-2024', '01:00:38 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (96, '2', 43, 1, '09-21-2024', '01:01:50 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (97, '2', 37, 1, '09-21-2024', '01:02:07 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (98, '2', 44, 1, '09-21-2024', '01:06:26 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (99, '2', 47, 1, '09-21-2024', '01:20:03 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (100, '2', 48, 1, '09-21-2024', '01:23:30 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (101, '2', 24, 1, '09-26-2024', '06:39:22 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (102, '2', 14, 1, '09-29-2024', '02:48:48 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (103, '2', 14, 1, '09-29-2024', '03:08:36 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (104, '2', 6, 2, '09-29-2024', '03:12:30 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (105, '2', 50, 1, '09-29-2024', '06:28:03 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (106, '2', 13, 2, '09-29-2024', '06:30:31 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (107, '2', 12, 2, '09-29-2024', '06:30:42 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (108, '2', 12, 2, '09-29-2024', '06:34:11 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (109, '2', 12, 2, '09-29-2024', '06:34:44 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (110, '2', 9, 2, '09-29-2024', '06:35:53 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (111, '2', 1, 2, '09-29-2024', '06:35:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (112, '2', 14, 2, '09-29-2024', '06:45:44 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (113, '2', 14, 2, '09-29-2024', '06:46:15 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (114, '2', 14, 2, '09-29-2024', '06:46:42 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (115, '2', 14, 2, '09-29-2024', '06:47:18 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (116, '2', 14, 2, '09-29-2024', '06:49:54 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (117, '2', 9, 2, '09-29-2024', '06:49:57 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (118, '2', 14, 2, '09-29-2024', '06:50:00 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (119, '2', 14, 2, '09-29-2024', '06:50:50 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (120, '2', 15, 2, '09-29-2024', '07:02:07 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (121, '2', 1, 2, '09-29-2024', '07:12:32 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (122, '2', 6, 2, '09-29-2024', '07:29:22 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (123, '2', 6, 2, '09-29-2024', '07:30:15 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (124, '2', 6, 2, '09-29-2024', '07:31:40 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (125, '2', 6, 2, '09-29-2024', '07:32:32 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (126, '2', 6, 2, '09-29-2024', '07:45:31 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (127, '2', 51, 1, '09-30-2024', '05:49:58 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (128, '2', 51, 1, '09-30-2024', '06:46:23 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (129, '3', 57, 1, '10-04-2024', '03:39:24 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (130, '3', 57, 1, '10-04-2024', '03:48:00 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (131, '3', 48, 1, '10-04-2024', '03:50:51 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (132, '3', 57, 1, '10-04-2024', '04:44:06 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (133, '3', 57, 1, '10-04-2024', '05:12:29 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (134, '3', 57, 1, '10-04-2024', '05:12:30 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (135, '3', 15, 2, '10-04-2024', '05:18:06 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (136, '3', 57, 1, '10-04-2024', '05:18:12 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (137, '3', 57, 1, '10-04-2024', '05:20:43 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (138, '3', 58, 1, '10-04-2024', '06:08:21 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (139, '3', 6, 2, '10-04-2024', '08:04:36 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (140, '3', 41, 1, '10-04-2024', '08:05:04 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (141, '3', 43, 1, '10-04-2024', '08:05:07 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (142, '3', 62, 1, '10-04-2024', '09:10:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (143, '3', 62, 1, '10-05-2024', '09:21:34 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (144, '3', 62, 1, '10-05-2024', '09:21:34 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (145, '3', 62, 1, '10-05-2024', '09:21:34 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (146, '3', 59, 1, '10-05-2024', '09:21:34 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (147, '3', 57, 1, '10-05-2024', '09:22:24 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (148, '3', 60, 1, '10-05-2024', '01:03:07 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (149, '3', 62, 1, '10-05-2024', '01:05:33 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (150, '3', 63, 1, '10-05-2024', '09:01:27 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (151, '3', 64, 1, '10-05-2024', '10:04:52 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (152, '3', 65, 1, '10-05-2024', '10:07:42 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (153, '3', 65, 1, '10-05-2024', '10:07:47 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (154, '3', 65, 1, '10-05-2024', '10:08:46 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (155, '3', 65, 1, '10-05-2024', '10:09:11 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (156, '3', 65, 1, '10-05-2024', '10:19:18 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (157, '3', 65, 1, '10-06-2024', '10:59:18 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (158, '3', 66, 1, '10-06-2024', '11:41:04 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (159, '3', 66, 1, '10-06-2024', '11:42:16 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (160, '3', 66, 1, '10-06-2024', '11:46:03 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (161, '3', 66, 1, '10-06-2024', '11:50:02 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (162, '3', 67, 1, '10-06-2024', '11:53:40 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (163, '3', 67, 1, '10-06-2024', '11:54:54 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (164, '3', 69, 1, '10-06-2024', '12:12:08 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (165, '3', 17, 2, '10-06-2024', '12:46:01 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (166, '3', 17, 2, '10-06-2024', '12:46:54 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (167, '3', 17, 2, '10-06-2024', '12:48:00 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (168, '3', 17, 2, '10-06-2024', '12:49:13 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (169, '3', 17, 2, '10-06-2024', '12:49:54 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (170, '3', 17, 2, '10-06-2024', '12:50:37 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (171, '3', 17, 2, '10-06-2024', '12:51:03 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (172, '3', 17, 2, '10-06-2024', '12:53:24 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (173, '3', 70, 1, '10-06-2024', '12:59:12 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (174, '3', 70, 1, '10-06-2024', '01:00:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (175, '3', 70, 1, '10-06-2024', '01:03:33 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (176, '3', 70, 1, '10-06-2024', '01:04:18 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (177, '3', 70, 1, '10-06-2024', '01:13:14 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (178, '3', 70, 1, '10-06-2024', '01:15:58 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (179, '3', 70, 1, '10-06-2024', '01:16:23 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (180, '3', 71, 1, '10-06-2024', '01:18:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (181, '3', 72, 1, '10-06-2024', '01:46:55 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (182, '3', 18, 2, '10-06-2024', '07:50:19 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (183, '3', 18, 2, '10-06-2024', '07:59:48 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (184, '3', 18, 2, '10-06-2024', '08:02:01 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (185, '3', 18, 2, '10-06-2024', '08:11:35 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (186, '3', 18, 2, '10-06-2024', '08:11:59 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (187, '3', 18, 2, '10-06-2024', '08:12:04 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (188, '3', 18, 2, '10-06-2024', '08:12:05 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (189, '3', 18, 2, '10-06-2024', '08:12:50 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (190, '3', 17, 2, '10-06-2024', '08:13:10 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (191, '3', 65, 1, '10-06-2024', '08:50:03 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (192, '3', 73, 1, '10-06-2024', '09:00:43 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (193, '3', 18, 2, '10-06-2024', '10:04:39 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (194, '3', 72, 1, '10-07-2024', '11:07:20 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (195, '3', 72, 1, '10-07-2024', '11:07:20 am');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (196, '3', 75, 1, '10-07-2024', '06:17:54 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (197, '3', 28, 1, '10-07-2024', '06:37:43 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (198, '3', 5, 1, '10-07-2024', '06:37:56 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (199, '3', 84, 1, '10-07-2024', '09:18:41 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (200, '3', 88, 1, '10-07-2024', '10:55:46 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (201, '3', 98, 1, '10-08-2024', '07:07:48 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (202, '3', 98, 1, '10-08-2024', '07:09:31 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (203, '3', 98, 1, '10-08-2024', '07:10:45 pm');
INSERT INTO `view_log` (`id`, `user_id`, `content_id`, `content_type`, `date`, `time`) VALUES (204, '3', 98, 1, '10-08-2024', '07:11:00 pm');


#
# TABLE STRUCTURE FOR: watch_log
#

DROP TABLE IF EXISTS `watch_log`;

CREATE TABLE `watch_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` text NOT NULL,
  `content_id` int(11) NOT NULL,
  `content_type` int(11) NOT NULL COMMENT '1=Movie, 2=WebSeries',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (1, 'cbec3a82ce3b5767', 1, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (2, 'cbec3a82ce3b5767', 1, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (3, 'cbec3a82ce3b5767', 2, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (4, 'cbec3a82ce3b5767', 3, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (5, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (6, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (7, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (8, 'cbec3a82ce3b5767', 1, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (9, 'cbec3a82ce3b5767', 1, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (10, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (11, 'cbec3a82ce3b5767', 3, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (12, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (13, 'cbec3a82ce3b5767', 2, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (14, 'cbec3a82ce3b5767', 2, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (15, 'cbec3a82ce3b5767', 5, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (16, 'cbec3a82ce3b5767', 5, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (17, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (18, 'cbec3a82ce3b5767', 6, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (19, 'cbec3a82ce3b5767', 8, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (20, 'cbec3a82ce3b5767', 9, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (21, 'cbec3a82ce3b5767', 9, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (22, 'cbec3a82ce3b5767', 9, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (23, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (24, 'cbec3a82ce3b5767', 4, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (25, 'cbec3a82ce3b5767', 4, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (26, 'cbec3a82ce3b5767', 3, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (27, 'cbec3a82ce3b5767', 5, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (28, 'cbec3a82ce3b5767', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (29, 'cbec3a82ce3b5767', 1, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (30, 'cbec3a82ce3b5767', 1, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (31, 'cbec3a82ce3b5767', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (32, 'cbec3a82ce3b5767', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (33, 'cbec3a82ce3b5767', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (34, 'cbec3a82ce3b5767', 13, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (35, 'cbec3a82ce3b5767', 13, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (36, 'cbec3a82ce3b5767', 1, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (37, '2', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (38, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (39, '2', 7, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (40, '2', 7, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (41, '2', 7, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (42, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (43, '2', 7, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (44, '2', 7, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (45, '2', 7, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (46, '2', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (47, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (48, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (49, '2', 15, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (50, '2', 9, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (51, '2', 9, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (52, '2', 9, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (53, '2', 15, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (54, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (55, '2', 10, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (56, '2', 21, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (57, '2', 24, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (58, '2', 24, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (59, '2', 24, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (60, '2', 24, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (61, '2', 21, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (62, '2', 25, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (63, '2', 4, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (64, '2', 4, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (65, '2', 26, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (66, '2', 29, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (67, '2', 32, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (68, '2', 32, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (69, '2', 32, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (70, '2', 6, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (71, '2', 6, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (72, '2', 22, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (73, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (74, '2', 33, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (75, '2', 33, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (76, '2', 43, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (77, '2', 43, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (78, '2', 43, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (79, '2', 37, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (80, '2', 44, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (81, '2', 47, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (82, '2', 48, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (83, '2', 24, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (84, '2', 14, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (85, '2', 50, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (86, '2', 12, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (87, '2', 12, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (88, '2', 12, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (89, '2', 12, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (90, '2', 1, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (91, '2', 14, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (92, '2', 14, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (93, '2', 14, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (94, '2', 14, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (95, '2', 14, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (96, '2', 14, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (97, '2', 15, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (98, '2', 15, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (99, '2', 15, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (100, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (101, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (102, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (103, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (104, '2', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (105, '2', 51, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (106, '2', 51, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (107, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (108, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (109, '3', 48, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (110, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (111, '3', 58, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (112, '3', 6, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (113, '3', 43, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (114, '3', 62, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (115, '3', 62, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (116, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (117, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (118, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (119, '3', 57, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (120, '3', 62, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (121, '3', 63, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (122, '3', 64, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (123, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (124, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (125, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (126, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (127, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (128, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (129, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (130, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (131, '3', 66, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (132, '3', 66, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (133, '3', 66, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (134, '3', 66, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (135, '3', 67, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (136, '3', 69, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (137, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (138, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (139, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (140, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (141, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (142, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (143, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (144, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (145, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (146, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (147, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (148, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (149, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (150, '3', 70, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (151, '3', 71, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (152, '3', 72, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (153, '3', 72, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (154, '3', 18, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (155, '3', 18, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (156, '3', 18, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (157, '3', 18, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (158, '3', 17, 2);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (159, '3', 65, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (160, '3', 73, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (161, '3', 72, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (162, '3', 75, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (163, '3', 84, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (164, '3', 88, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (165, '3', 98, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (166, '3', 98, 1);
INSERT INTO `watch_log` (`id`, `user_id`, `content_id`, `content_type`) VALUES (167, '3', 98, 1);


#
# TABLE STRUCTURE FOR: web_series
#

DROP TABLE IF EXISTS `web_series`;

CREATE TABLE `web_series` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `TMDB_ID` int(11) NOT NULL,
  `name` text NOT NULL,
  `description` longtext NOT NULL,
  `genres` text NOT NULL,
  `release_date` text NOT NULL,
  `poster` text NOT NULL,
  `banner` text NOT NULL,
  `youtube_trailer` text NOT NULL,
  `downloadable` int(11) NOT NULL,
  `type` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `content_type` int(11) NOT NULL DEFAULT 2 COMMENT '1=Movie, 2=WebSeries',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (1, 202736, 'KÄ±yma', 'Ã–mer, Poyraz ve Tufan 3 yÄ±l hapiste yattÄ±kran sonra Adanaâ€™dan Ä°stanbulâ€™a gelip bir kebapÃ§Ä± aÃ§arlar. ArtÄ±k illegal dÃ¼nyayla iÅŸleri bitmiÅŸtir. Ancak gerÃ§ekler planladÄ±klarÄ± gibi olmaz. Ä°stanbulâ€™da daha dÃ¼kkanÄ± kiralarken dolandÄ±rÄ±lÄ±nca paralarÄ±nÄ± geri almak iÃ§in girdikleri yolda yeni bir dÃ¼nyayla karÅŸÄ±laÅŸÄ±rlar. BÃ¼yÃ¼k ve saygÄ± duyulan bir mafya babasÄ± olan DayÄ±â€™nÄ±n gÃ¼venini kazanÄ±rlar. DayÄ±â€™nÄ±n oÄŸlu YiÄŸit ilk gÃ¼nden beri Ã–mer, Poyraz ve Tufanâ€™a dÃ¼ÅŸman olur, daha sonra da karÅŸÄ±larÄ±na Ã§Ä±kacaktÄ±r.Ã–mer, Poyraz ve Tufan 3 yÄ±l hapiste yattÄ±kran sonra Adanaâ€™dan Ä°stanbulâ€™a gelip bir kebapÃ§Ä± aÃ§arlar. ArtÄ±k illegal dÃ¼nyayla iÅŸleri bitmiÅŸtir. Ancak gerÃ§ekler planladÄ±klarÄ± gibi olmaz. Ä°stanbulâ€™da daha dÃ¼kkanÄ± kiralarken dolandÄ±rÄ±lÄ±nca paralarÄ±nÄ± geri almak iÃ§in girdikleri yolda yeni bir dÃ¼nyayla karÅŸÄ±laÅŸÄ±rlar. BÃ¼yÃ¼k ve saygÄ± duyulan bir mafya babasÄ± olan DayÄ±â€™nÄ±n gÃ¼venini kazanÄ±rlar. DayÄ±â€™nÄ±n oÄŸlu YiÄŸit ilk gÃ¼nden beri Ã–mer, Poyraz ve Tufanâ€™a dÃ¼ÅŸman olur, daha sonra da karÅŸÄ±larÄ±na Ã§Ä±kacaktÄ±r.', 'Aksiyon & Macera,SuÃ§', '2022-05-24', 'https://image.tmdb.org//t/p/original/vXOvtRLx6NS4f654E3SFsW2tf9q.jpg', 'https://image.tmdb.org//t/p/original/qRCnBJ3TMtnZORNedZSaJSQFZVg.jpg', '', 1, 0, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (2, 223785, 'Milyarder AdasÄ±', 'NorveÃ§li bir balÄ±k Ã§iftliÄŸi ÅŸirketinin acÄ±masÄ±z sahibi, dÃ¼nyanÄ±n en bÃ¼yÃ¼k somon Ã¼reticisi olmak iÃ§in yerel rakibini ÅŸeytani bir ÅŸekilde ele geÃ§irmeyi planlar.NorveÃ§li bir balÄ±k Ã§iftliÄŸi ÅŸirketinin acÄ±masÄ±z sahibi, dÃ¼nyanÄ±n en bÃ¼yÃ¼k somon Ã¼reticisi olmak iÃ§in yerel rakibini ÅŸeytani bir ÅŸekilde ele geÃ§irmeyi planlar.', 'Dram,Komedi', '2024-09-12', 'https://image.tmdb.org//t/p/original/2WoDRjEGDooGYl4NysuZqsBIsTs.jpg', 'https://image.tmdb.org//t/p/original/qcTXvYBxQriORMJwTD8NsUxXRcu.jpg', 'https://www.youtube.com/watch?v=beyM5ngTZZM', 1, 0, 0, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (3, 237512, 'Jâ€‹â€‹urassic World: Kaos Teorisi', 'Hem dinozorlar hem de kendileri iÃ§in tehlike yaratan kÃ¼resel bir komplodan haberdar olan Kretase KampÄ± ekibi, bÃ¼yÃ¼k gizemi aÃ§Ä±ÄŸa Ã§Ä±karmak iÃ§in iÅŸ birliÄŸi yapar.Hem dinozorlar hem de kendileri iÃ§in tehlike yaratan kÃ¼resel bir komplodan haberdar olan Kretase KampÄ± ekibi, bÃ¼yÃ¼k gizemi aÃ§Ä±ÄŸa Ã§Ä±karmak iÃ§in iÅŸ birliÄŸi yapar.', 'Animasyon,Aile,Aksiyon & Macera,Bilim Kurgu & Fantazi,Ã‡ocuklar', '2024-05-24', 'https://image.tmdb.org//t/p/original/c2Od0cY2IeayDj5osUxZSAD1QK.jpg', 'https://image.tmdb.org//t/p/original/7y31JWag4vsWtXZvcjmLUDJ6NSp.jpg', 'https://www.youtube.com/watch?v=bLgUKAAKyQw', 0, 0, 0, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (4, 125412, 'Ayak Ä°ÅŸleri', 'TecrÃ¼beli gÃ¶rev adamÄ± Vedat ve felsefe okumuÅŸ, politik doÄŸrucu Evren, zengin bir iÅŸ adamÄ±nÄ±n â€˜aÅŸÄ±rÄ± Ã¶nemliâ€™ ayak iÅŸleri iÃ§in gÃ¶revlendirilen ikilidir. Biri gÃ¶zlerini kapayÄ±p vazifesini yapan, diÄŸeri attÄ±ÄŸÄ± her adÄ±mÄ± sorgulayan bu uyumsuz ikili, her bÃ¶lÃ¼m baÅŸka bir maceraya doÄŸru yola Ã§Ä±kar. Fakat gÃ¶rev icabÄ± Ã§atÄ±ÅŸtÄ±klarÄ±ndan daha fazla, kendi iÃ§lerinde Ã§atÄ±ÅŸÄ±rlar.TecrÃ¼beli gÃ¶rev adamÄ± Vedat ve felsefe okumuÅŸ, politik doÄŸrucu Evren, zengin bir iÅŸ adamÄ±nÄ±n â€˜aÅŸÄ±rÄ± Ã¶nemliâ€™ ayak iÅŸleri iÃ§in gÃ¶revlendirilen ikilidir. Biri gÃ¶zlerini kapayÄ±p vazifesini yapan, diÄŸeri attÄ±ÄŸÄ± her adÄ±mÄ± sorgulayan bu uyumsuz ikili, her bÃ¶lÃ¼m baÅŸka bir maceraya doÄŸru yola Ã§Ä±kar. Fakat gÃ¶rev icabÄ± Ã§atÄ±ÅŸtÄ±klarÄ±ndan daha fazla, kendi iÃ§lerinde Ã§atÄ±ÅŸÄ±rlar.', 'Komedi,Aksiyon & Macera', '2021-05-12', 'https://image.tmdb.org//t/p/original/w7Ye1LMhPlST5nvEcmOMJsQcCFf.jpg', 'https://image.tmdb.org//t/p/original/7MSFsfEY4z9VAczH9flrY10vCzb.jpg', '', 1, 1, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (5, 115708, '@EnisArÄ±kan', 'Enis ArÄ±kan, bu kez bambaÅŸka bir formatla karÅŸÄ±nÄ±zda! Ä°lk kez bir talk showla seyirci karÅŸÄ±sÄ±na Ã§Ä±kan Enis ArÄ±kan, birbirinden Ã¼nlÃ¼ konuklarÄ±nÄ± aÄŸÄ±rlÄ±yor ve daha Ã¶nce sorulmayanlarÄ± soruyor.Enis ArÄ±kan, bu kez bambaÅŸka bir formatla karÅŸÄ±nÄ±zda! Ä°lk kez bir talk showla seyirci karÅŸÄ±sÄ±na Ã§Ä±kan Enis ArÄ±kan, birbirinden Ã¼nlÃ¼ konuklarÄ±nÄ± aÄŸÄ±rlÄ±yor ve daha Ã¶nce sorulmayanlarÄ± soruyor.', 'Komedi,Talk', '2021-01-01', 'https://image.tmdb.org//t/p/original/a3GM2GSuMdTZjgFJJZwB5JwPBmo.jpg', 'https://image.tmdb.org//t/p/original/eN5m7e0aLSf5mPxBDL6IrnhxKRs.jpg', '', 1, 0, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (6, 115641, 'KonuÅŸanlar', 'Senarist Komedyen Hasan Can Kayaâ€™nÄ±n hazÄ±rlayÄ±p sunduÄŸu, odaÄŸÄ±na  OrantÄ±sÄ±z Mizahâ€™Ä± alan yeni Talk Show formatÄ± KonuÅŸanlar Ã¼nlÃ¼ konuk ve sÃ¼rpriz konularÄ±yla mizahÄ±n daha Ã¶nce girilmeyen sÄ±nÄ±rlarÄ±nÄ± paramparÃ§a ediyor.Senarist Komedyen Hasan Can Kayaâ€™nÄ±n hazÄ±rlayÄ±p sunduÄŸu, odaÄŸÄ±na  OrantÄ±sÄ±z Mizahâ€™Ä± alan yeni Talk Show formatÄ± KonuÅŸanlar Ã¼nlÃ¼ konuk ve sÃ¼rpriz konularÄ±yla mizahÄ±n daha Ã¶nce girilmeyen sÄ±nÄ±rlarÄ±nÄ± paramparÃ§a ediyor.', 'Komedi,Talk', '2020-05-12', 'https://image.tmdb.org//t/p/original/gTJZ9d49dLI2m1vv1Ufi3Cx7rMt.jpg', 'https://image.tmdb.org//t/p/original/yRfroDcvczmBqyoM0VpTggBG7kO.jpg', '', 1, 1, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (7, 92783, 'DiÅŸi-Hulk: Kanuni Avukat', 'Marvel Studios\'dan \"She-Hulk: Attorney at Law\"da, sÃ¼per insan odaklÄ± davalara bakan 30\'lu yaÅŸlardaki avukat Jennifer Walters bekÃ¢r ve karmaÅŸÄ±k hayatÄ±nÄ±n yanÄ± sÄ±ra 2 metrelik boyu, sÃ¼per gÃ¼Ã§lÃ¼ ve yeÅŸil dev gÃ¶rÃ¼nÃ¼mÃ¼yle hayatÄ±nÄ± sÃ¼rdÃ¼rmeye Ã§alÄ±ÅŸmaktadÄ±r.Marvel Studios\'dan \"She-Hulk: Attorney at Law\"da, sÃ¼per insan odaklÄ± davalara bakan 30\'lu yaÅŸlardaki avukat Jennifer Walters bekÃ¢r ve karmaÅŸÄ±k hayatÄ±nÄ±n yanÄ± sÄ±ra 2 metrelik boyu, sÃ¼per gÃ¼Ã§lÃ¼ ve yeÅŸil dev gÃ¶rÃ¼nÃ¼mÃ¼yle hayatÄ±nÄ± sÃ¼rdÃ¼rmeye Ã§alÄ±ÅŸmaktadÄ±r.', 'Komedi,Bilim Kurgu & Fantazi', '2022-08-18', 'https://image.tmdb.org//t/p/original/hJfI6AGrmr4uSHRccfJuSsapvOb.jpg', 'https://image.tmdb.org//t/p/original/eljErfkQUcFUgQkI4I1soZcH8MW.jpg', 'https://www.youtube.com/watch?v=gim2kprjL50', 1, 1, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (8, 1425, 'House of Cards', '90â€™lÄ± yÄ±llarda, politikacÄ± yazar Michael Dobbs tarafÄ±ndan yazÄ±lan aynÄ± adlÄ± kitaptan esinlenen ve BBCâ€™ye mini dizi olarak uyarlanan â€œHouse of Cardsâ€, ÅŸimdi AmerikalÄ± yapÄ±mcÄ±lar tarafÄ±ndan bir kez daha, Ã¼stelik muhteÅŸem bir kadro eÅŸliÄŸinde televizyona aktarÄ±ldÄ±. Son yÄ±llarda â€œThe Curious Case of Benjamin Buttonâ€ ve â€œSocial Networkâ€ filmleriyle ses getiren David Fincher tarafÄ±ndan yapÄ±mcÄ±lÄ±ÄŸÄ± ve yÃ¶netmenliÄŸi Ã¼stlenen dizinin baÅŸrollerinde, Fincherâ€™Ä±n filmlerinde de rol alan iki Ã¼nlÃ¼ yÄ±ldÄ±z yer alÄ±yor. â€œSevenâ€ filminde birlikte Ã§alÄ±ÅŸtÄ±ÄŸÄ± Kevin Spacey ve â€œThe Girl with the Dragon Tattooâ€ filminde rol alan Robin Wright. \n\nâ€œHouse of Cardsâ€ Washingtonâ€™da hÄ±rslÄ± bir politikacÄ±nÄ±n zirveye tÄ±rmanÄ±ÅŸÄ±nÄ± anlatÄ±yor. Kevin Spacey tarafÄ±ndan canlandÄ±rÄ±lan Francis Underwood yÄ±llarÄ±nÄ± Beyaz Saray koridorlarÄ±nda geÃ§irdikten sonra, artÄ±k baÅŸkanlÄ±k seÃ§imlerine adaylÄ±ÄŸÄ±nÄ± koymasÄ± gerektiÄŸini dÃ¼ÅŸÃ¼nÃ¼yor. Ne de olsa bunca zaman o koridorlarda gÃ¶rdÃ¼ÄŸÃ¼ tÃ¼m Ã¼st dÃ¼zey bÃ¼rokratlar ile ilgili her tÃ¼rlÃ¼ bilgiye sahip. Kimi hangi dosyayla tehdit edeceÄŸini biliyor. Bu gÃ¶zÃ¼ kara politikacÄ±nÄ±n Robin Wright tarafÄ±ndan canlandÄ±rÄ±lan eÅŸi Claireâ€™in de ondan aÅŸaÄŸÄ± kalÄ±r yanÄ± yok. Francis Underwoodâ€™un baÅŸkanlÄ±k koltuÄŸuna ilerlemek iÃ§in adeta iskambil kaÄŸÄ±tlarÄ±ndan bir ev gibi itinayla inÅŸa ettiÄŸi stratejisini ilgiyle takip edeceksiniz.90â€™lÄ± yÄ±llarda, politikacÄ± yazar Michael Dobbs tarafÄ±ndan yazÄ±lan aynÄ± adlÄ± kitaptan esinlenen ve BBCâ€™ye mini dizi olarak uyarlanan â€œHouse of Cardsâ€, ÅŸimdi AmerikalÄ± yapÄ±mcÄ±lar tarafÄ±ndan bir kez daha, Ã¼stelik muhteÅŸem bir kadro eÅŸliÄŸinde televizyona aktarÄ±ldÄ±. Son yÄ±llarda â€œThe Curious Case of Benjamin Buttonâ€ ve â€œSocial Networkâ€ filmleriyle ses getiren David Fincher tarafÄ±ndan yapÄ±mcÄ±lÄ±ÄŸÄ± ve yÃ¶netmenliÄŸi Ã¼stlenen dizinin baÅŸrollerinde, Fincherâ€™Ä±n filmlerinde de rol alan iki Ã¼nlÃ¼ yÄ±ldÄ±z yer alÄ±yor. â€œSevenâ€ filminde birlikte Ã§alÄ±ÅŸtÄ±ÄŸÄ± Kevin Spacey ve â€œThe Girl with the Dragon Tattooâ€ filminde rol alan Robin Wright. \n\nâ€œHouse of Cardsâ€ Washingtonâ€™da hÄ±rslÄ± bir politikacÄ±nÄ±n zirveye tÄ±rmanÄ±ÅŸÄ±nÄ± anlatÄ±yor. Kevin Spacey tarafÄ±ndan canlandÄ±rÄ±lan Francis Underwood yÄ±llarÄ±nÄ± Beyaz Saray koridorlarÄ±nda geÃ§irdikten sonra, artÄ±k baÅŸkanlÄ±k seÃ§imlerine adaylÄ±ÄŸÄ±nÄ± koymasÄ± gerektiÄŸini dÃ¼ÅŸÃ¼nÃ¼yor. Ne de olsa bunca zaman o koridorlarda gÃ¶rdÃ¼ÄŸÃ¼ tÃ¼m Ã¼st dÃ¼zey bÃ¼rokratlar ile ilgili her tÃ¼rlÃ¼ bilgiye sahip. Kimi hangi dosyayla tehdit edeceÄŸini biliyor. Bu gÃ¶zÃ¼ kara politikacÄ±nÄ±n Robin Wright tarafÄ±ndan canlandÄ±rÄ±lan eÅŸi Claireâ€™in de ondan aÅŸaÄŸÄ± kalÄ±r yanÄ± yok. Francis Underwoodâ€™un baÅŸkanlÄ±k koltuÄŸuna ilerlemek iÃ§in adeta iskambil kaÄŸÄ±tlarÄ±ndan bir ev gibi itinayla inÅŸa ettiÄŸi stratejisini ilgiyle takip edeceksiniz.', 'Dram', '2013-02-01', 'https://image.tmdb.org//t/p/original/hKWxWjFwnMvkWQawbhvC0Y7ygQ8.jpg', 'https://image.tmdb.org//t/p/original/zoAxfThy7ntyCutBeNgdaKhRoSX.jpg', 'https://www.youtube.com/watch?v=x1E8PSGcyqI', 0, 1, 0, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (9, 60625, 'Rick and Morty', 'Parlak zekalÄ± fakat alkolik bilim adamÄ± Rick, baÅŸka dÃ¼nyalara ve alternatif boyutlara Ã§Ä±lgÄ±n kaÃ§amaklar yaparken huysuz torunu Morty\'i de zorla yanÄ±nda gÃ¶tÃ¼rÃ¼r.Parlak zekalÄ± fakat alkolik bilim adamÄ± Rick, baÅŸka dÃ¼nyalara ve alternatif boyutlara Ã§Ä±lgÄ±n kaÃ§amaklar yaparken huysuz torunu Morty\'i de zorla yanÄ±nda gÃ¶tÃ¼rÃ¼r.', 'Animasyon,Komedi,Aksiyon & Macera,Bilim Kurgu & Fantazi', '2013-12-02', 'https://image.tmdb.org//t/p/original/gdIrmf2DdY5mgN6ycVP0XlzKzbE.jpg', 'https://image.tmdb.org//t/p/original/rBF8wVQN8hTWHspVZBlI3h7HZJ.jpg', 'https://www.youtube.com/watch?v=WNhH00OIPP0', 1, 1, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (10, 209924, 'En Ä°yi ArkadaÅŸÄ±m', 'BarÄ±ÅŸ, kendi halinde ve mutsuz bir Ã§ocuktur. Cinler diyarÄ±ndan BarÄ±ÅŸ\'Ä± mutlu etmesi ve iÅŸlerine yardÄ±mcÄ± olmasÄ± iÃ§in Cino adlÄ± bir cin dÃ¼nyaya gÃ¶nderilir. Cino, komik, sakar ve bir o kadar da tembel bir cindir. Tek amacÄ± BarÄ±ÅŸ\'Ä± mutlu ederek Cin Okulu\'ndan mezun olmaktÄ±r. Bunun iÃ§in Cinler Ã¼lkesi ve DÃ¼nya arasÄ±nda mekik dokuyacaktÄ±r.BarÄ±ÅŸ, kendi halinde ve mutsuz bir Ã§ocuktur. Cinler diyarÄ±ndan BarÄ±ÅŸ\'Ä± mutlu etmesi ve iÅŸlerine yardÄ±mcÄ± olmasÄ± iÃ§in Cino adlÄ± bir cin dÃ¼nyaya gÃ¶nderilir. Cino, komik, sakar ve bir o kadar da tembel bir cindir. Tek amacÄ± BarÄ±ÅŸ\'Ä± mutlu ederek Cin Okulu\'ndan mezun olmaktÄ±r. Bunun iÃ§in Cinler Ã¼lkesi ve DÃ¼nya arasÄ±nda mekik dokuyacaktÄ±r.', 'Komedi,Bilim Kurgu & Fantazi,Ã‡ocuklar', '2003-11-18', 'https://image.tmdb.org//t/p/original/lxHOrlOdROBkUe7kwOs41WD55w9.jpg', 'https://image.tmdb.org//t/p/original', 'https://www.youtube.com/watch?v=VGsorMjGeDk', 0, 1, 0, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (14, 40424, 'é ­æ–‡å­—D', 'Takumi Fujiwara, yerel bir tofu dÃ¼kkanÄ±nÄ±n sahibinin saf ve durgun karakterli oÄŸludur. Her gece babasÄ±nÄ±n eski Trueno AE86 model arabasÄ± ile tofu teslimatÄ±na giden Takumi, arabayÄ± Ã§ok iyi kullanmakta olduÄŸunun farkÄ±nda bile deÄŸildir. BÃ¶lgenin amatÃ¶r yol yarÄ±ÅŸ takÄ±mÄ± Ã¼yeleri olan arkadaÅŸlarÄ± ile takÄ±ldÄ±kÃ§a, arabalar, yollar ve yarÄ±ÅŸlar Ã¼zerine bir Ã§ok ÅŸey Ã¶ÄŸrenir. Takumiâ€™nin yarÄ±ÅŸÃ§Ä±lÄ±k macerasÄ±, bir gece bÃ¶lgenin en iyi amatÃ¶r yarÄ±ÅŸ takÄ±mlarÄ±ndan olan Akagi Red Sunâ€™Ä±n en iyi yarÄ±ÅŸÃ§Ä±larÄ±ndan birini ÅŸaÅŸÄ±rtÄ±cÄ± ÅŸekilde yenmesi ile baÅŸlar..Takumi Fujiwara, yerel bir tofu dÃ¼kkanÄ±nÄ±n sahibinin saf ve durgun karakterli oÄŸludur. Her gece babasÄ±nÄ±n eski Trueno AE86 model arabasÄ± ile tofu teslimatÄ±na giden Takumi, arabayÄ± Ã§ok iyi kullanmakta olduÄŸunun farkÄ±nda bile deÄŸildir. BÃ¶lgenin amatÃ¶r yol yarÄ±ÅŸ takÄ±mÄ± Ã¼yeleri olan arkadaÅŸlarÄ± ile takÄ±ldÄ±kÃ§a, arabalar, yollar ve yarÄ±ÅŸlar Ã¼zerine bir Ã§ok ÅŸey Ã¶ÄŸrenir. Takumiâ€™nin yarÄ±ÅŸÃ§Ä±lÄ±k macerasÄ±, bir gece bÃ¶lgenin en iyi amatÃ¶r yarÄ±ÅŸ takÄ±mlarÄ±ndan olan Akagi Red Sunâ€™Ä±n en iyi yarÄ±ÅŸÃ§Ä±larÄ±ndan birini ÅŸaÅŸÄ±rtÄ±cÄ± ÅŸekilde yenmesi ile baÅŸlar..', 'Animasyon', '1998-04-18', 'https://image.tmdb.org//t/p/original/7C1PMnV0uMrMNcfws5J7aLNxe3Q.jpg', 'https://image.tmdb.org//t/p/original/zBIIyH8yfdlfvvpEiG9PLwoVXc6.jpg', '', 0, 2, 0, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (15, 66393, 'Bring it on, Ghost', 'Dizi, bir hayalet ve hayaletleri gÃ¶rme yeteneÄŸine sahip olan bir kiÅŸi etrafÄ±nda dÃ¶nmektedir. Hyun-Ji (Kim So-Hyun) dÃ¼nyayÄ± gezen bir hayalettir. Bir gÃ¼n, bÃ¼yÃ¼ ile ruhlarÄ± Ã¶teki dÃ¼nyaya gÃ¶nderen Park Bong-Pal (Taecyeon) ile karÅŸÄ±laÅŸÄ±r. Hyun-Ji ve Bong-Pal hayaletlerden Ã§eÅŸitli hikÃ¢yeler dinler ve sonra birlikte onlarÄ± Ã¶teki dÃ¼nyaya geÃ§melerine yardÄ±mcÄ± olur. GÃ¼n geÃ§tikÃ§e de bu garip ikili arasÄ±ndaki yakÄ±nlÄ±k bÃ¼yÃ¼r.Dizi, bir hayalet ve hayaletleri gÃ¶rme yeteneÄŸine sahip olan bir kiÅŸi etrafÄ±nda dÃ¶nmektedir. Hyun-Ji (Kim So-Hyun) dÃ¼nyayÄ± gezen bir hayalettir. Bir gÃ¼n, bÃ¼yÃ¼ ile ruhlarÄ± Ã¶teki dÃ¼nyaya gÃ¶nderen Park Bong-Pal (Taecyeon) ile karÅŸÄ±laÅŸÄ±r. Hyun-Ji ve Bong-Pal hayaletlerden Ã§eÅŸitli hikÃ¢yeler dinler ve sonra birlikte onlarÄ± Ã¶teki dÃ¼nyaya geÃ§melerine yardÄ±mcÄ± olur. GÃ¼n geÃ§tikÃ§e de bu garip ikili arasÄ±ndaki yakÄ±nlÄ±k bÃ¼yÃ¼r.', 'Dram,Bilim Kurgu & Fantazi,Gizem', '2016-07-11', 'https://image.tmdb.org//t/p/original/wSNAMyfWVaHMfLdeGsA3cOTgrqX.jpg', 'https://image.tmdb.org//t/p/original/2gYZ0jQ7JKIukQSALPUXU7TZCbb.jpg', '', 1, 0, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (16, 122186, 'Doğu', 'Ailesi ve çevresi, Doğu’yu 7 yıldır okuduğu mühendislik bölümünü bitirip herkesçe kabul gören sigortalı bir meslek edinmeye, sabah 9 akşam 6 işe gitmeye, münasip bir eş bulup bir an önce çoluk çocuk sahibi olmaya yönlendirmektedir. Oysa olağanüstü sıradan bir hayatı olan Doğu’nun tek isteği komedyen olmaktır. Başta bir türlü mezun olamadığı bilgisayar mühendisliği, “Bir Cem Yılmaz Olamayacaksın.” diyen ailesi, başarılarıyla Doğu’yu sürekli ezip geçen kız kardeşi Kübra, tek hayali bir Bmw almak olan karamsar arkadaşı Özgür, yürütemediği gönül ilişkileri ve her biri düzenli işlere girmiş ve aile kurmuş yaşıtlarına rağmen hayatını yoluna sokmaya ve çocukluk hayali olan komedyenliğin peşinden gitmeye çalışan Doğu’nun trajikomik hikayesi.Ailesi ve çevresi, Doğu’yu 7 yıldır okuduğu mühendislik bölümünü bitirip herkesçe kabul gören sigortalı bir meslek edinmeye, sabah 9 akşam 6 işe gitmeye, münasip bir eş bulup bir an önce çoluk çocuk sahibi olmaya yönlendirmektedir. Oysa olağanüstü sıradan bir hayatı olan Doğu’nun tek isteği komedyen olmaktır. Başta bir türlü mezun olamadığı bilgisayar mühendisliği, “Bir Cem Yılmaz Olamayacaksın.” diyen ailesi, başarılarıyla Doğu’yu sürekli ezip geçen kız kardeşi Kübra, tek hayali bir Bmw almak olan karamsar arkadaşı Özgür, yürütemediği gönül ilişkileri ve her biri düzenli işlere girmiş ve aile kurmuş yaşıtlarına rağmen hayatını yoluna sokmaya ve çocukluk hayali olan komedyenliğin peşinden gitmeye çalışan Doğu’nun trajikomik hikayesi.', 'Dram,Komedi', '2021-03-31', 'https://image.tmdb.org//t/p/original/16TlWbNcmpyRaXt0IVmWOx8xtBl.jpg', 'https://image.tmdb.org//t/p/original/q7fBmC4mKlD0U5HxO4YjdV24M4C.jpg', '', 1, 0, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (17, 1399, 'Game of Thrones', 'Krallık dediğin savaşsız olur mu? En güçlü krallığı kurup, huzuru sağlamış olsan bile bu gücü elinde nasıl koruyacaksın? Burada yanlış yapana yer yok, affetmek yok. Kuzey Krallığının hükümdarı Lord Ned Stark, uzun ve zorlu savaşlardan sonra anayurduna dönüp krallığını bütünlük içerisinde tutmayı başarmıştır. Kral Robert Baratheon ile yıllarca omuz omuza çarpışan ve Baratheon\'un kral olmasını sağlayan Ned Stark\'ın tek istediği kuzey sınırlarını koruyan krallığında ailesiyle ve halkıyla yaşamaktır. \n\nFakat suyun öte yanında kendi topraklarından ve krallığından kovulduğunu iddia eden Viserys Targaryen , kız kardeşi Daenerys\'i barbar kavimlerin başı Han Drogo\'ya vererek, güç birliği planları yapmaktadır. Tahtını büyük bir iştahla geri isteyen ama kraliyet oyunlarından habersiz olan Viserys\'in planları Kral Baratheon\'a ulaşır. Savaş alanında büyük cengaver olan ama ülke ve aile yönetiminde aynı başarıyı tutturamayan Baratheon\'un tamamen güvenebileceği ve her yanlış hamlesini arkasından toplayacak yeni bir sağ kola ihtiyacı vardır. Kuzeyin Lordu Ned Stark bu görev için seçilen tek aday isimdir. Kış yaklaşıyor...\n\nHanedan entrikaları, kapılı kapılar ardında dönen oyunlar, birilerinin kuyusunu kazmak için düşmanın koynuna girmekten çekinmeyen kadınlar, kardeşler arası çekişmeler, dışlanmalar... Hepsi tek bir hedef için: Taht kavgası..Krallık dediğin savaşsız olur mu? En güçlü krallığı kurup, huzuru sağlamış olsan bile bu gücü elinde nasıl koruyacaksın? Burada yanlış yapana yer yok, affetmek yok. Kuzey Krallığının hükümdarı Lord Ned Stark, uzun ve zorlu savaşlardan sonra anayurduna dönüp krallığını bütünlük içerisinde tutmayı başarmıştır. Kral Robert Baratheon ile yıllarca omuz omuza çarpışan ve Baratheon\'un kral olmasını sağlayan Ned Stark\'ın tek istediği kuzey sınırlarını koruyan krallığında ailesiyle ve halkıyla yaşamaktır. \n\nFakat suyun öte yanında kendi topraklarından ve krallığından kovulduğunu iddia eden Viserys Targaryen , kız kardeşi Daenerys\'i barbar kavimlerin başı Han Drogo\'ya vererek, güç birliği planları yapmaktadır. Tahtını büyük bir iştahla geri isteyen ama kraliyet oyunlarından habersiz olan Viserys\'in planları Kral Baratheon\'a ulaşır. Savaş alanında büyük cengaver olan ama ülke ve aile yönetiminde aynı başarıyı tutturamayan Baratheon\'un tamamen güvenebileceği ve her yanlış hamlesini arkasından toplayacak yeni bir sağ kola ihtiyacı vardır. Kuzeyin Lordu Ned Stark bu görev için seçilen tek aday isimdir. Kış yaklaşıyor...\n\nHanedan entrikaları, kapılı kapılar ardında dönen oyunlar, birilerinin kuyusunu kazmak için düşmanın koynuna girmekten çekinmeyen kadınlar, kardeşler arası çekişmeler, dışlanmalar... Hepsi tek bir hedef için: Taht kavgası..', 'Dram,Aksiyon & Macera,Bilim Kurgu & Fantazi', '2011-04-17', 'https://image.tmdb.org//t/p/original/1XS1oqL89opfnbLl8WnZY1O1uJx.jpg', 'https://image.tmdb.org//t/p/original/zZqpAXxVSBtxV9qPBcscfXBcL2w.jpg', 'https://www.youtube.com/watch?v=BpJYNVhGf1s', 0, 0, 1, 2);
INSERT INTO `web_series` (`id`, `TMDB_ID`, `name`, `description`, `genres`, `release_date`, `poster`, `banner`, `youtube_trailer`, `downloadable`, `type`, `status`, `content_type`) VALUES (18, 153312, 'Tulsa King', '25 yıl hapis cezasının ardından cezaevinden yeni çıkan, \"General\" olarak bilinen eski New York mafya babası Dwight Manfredi, bağlı olduğu suç lordu tarafından törensiz bir şekilde kovulur. Oklahoma, Tulsa\'ya sürgüne gönderilen Dwight, renkli karakterlerle kendi takımını kurmaya karar verir.', 'Dram,Komedi,Suç,aile-filmleri', '2022-11-13', 'https://image.tmdb.org//t/p/original/zMFAdj30K84Sz90bCd6ePwiAO37.jpg', 'https://image.tmdb.org//t/p/original/mNHRGO1gFpR2CYZdANe72kcKq7G.jpg', 'https://www.youtube.com/watch?v=PXd3tO5ITyw', 1, 0, 1, 2);


#
# TABLE STRUCTURE FOR: web_series_episoade
#

DROP TABLE IF EXISTS `web_series_episoade`;

CREATE TABLE `web_series_episoade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Episoade_Name` text NOT NULL,
  `episoade_image` text NOT NULL,
  `episoade_description` text NOT NULL,
  `episoade_order` int(11) NOT NULL,
  `season_id` int(11) NOT NULL,
  `downloadable` int(11) NOT NULL COMMENT '0=No, 1=Yes',
  `type` int(11) NOT NULL COMMENT '0=NotPremium, 1=Premium',
  `status` int(11) NOT NULL COMMENT '0=Not Released, 1=Released',
  `source` text NOT NULL,
  `url` text NOT NULL,
  `skip_available` int(11) NOT NULL DEFAULT 0 COMMENT '0=No, 1=Yes',
  `intro_start` text NOT NULL,
  `intro_end` text NOT NULL,
  `end_credits_marker` text NOT NULL,
  `drm_uuid` text NOT NULL COMMENT 'WIDEVINE,PLAYREADY,CLEARKEY',
  `drm_license_uri` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (1, '2. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/mqQvLrN1PpuBOQ5bajn3hmth0fL.jpg', 'Ã–mer, Tufan ve Poyraz her ÅŸeye raÄŸmen hayatlarÄ±nÄ± yoluna sokmaya Ã§alÄ±ÅŸÄ±rken mahallede baÅŸ etmeleri gereken yeni bir tehlike doÄŸar.', 2, 2, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (2, '5. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/d842LavRQEXbxi6PzNCVC6kKDUv.jpg', 'YiÄŸit mahalleyi yangÄ±n yerine Ã§evirir, herkeste panik hakimdir. Mahallede klibin Ã§ekileceÄŸi gÃ¼n yaklaÅŸÄ±rken, Ã–mer\'in son bir planÄ± vardÄ±r.', 5, 2, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (3, '1. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/hIKf9h9Eexpn3UY1L9R5ppfXuJZ.jpg', 'Adana\'dan bÃ¼yÃ¼k hayallerle Ä°stanbul\'a gelen Ã¼Ã§ arkadaÅŸ yeni bir mahallede temiz bir baÅŸlangÄ±Ã§ yapmak ister. Ancak bela yakalarÄ±nÄ± bÄ±rakmaz.', 1, 2, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (4, '4. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/g8nnrHHSrkMC2GiMYgg0AnFnWOg.jpg', 'Mahalledeki tehlike gÃ¼n geÃ§tikÃ§e bÃ¼yÃ¼r. ÃœÃ§ arkadaÅŸ, kendini savunmak iÃ§in yeni yollar bulmak zorunda kalÄ±r.', 4, 2, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (5, '3. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/zVaYcbLiwM0Ph8wbqFYSUD0OqDb.jpg', 'AyÄ±k olun, aÄŸÄ±zlarÄ±nÄ±n tadÄ±nÄ± kaÃ§Ä±ranlar, elbet karÅŸÄ±lÄ±ÄŸÄ±nÄ± alacaklar.', 3, 2, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (6, 'Serbest DÃ¼ÅŸÃ¼ÅŸ', 'https://www.themoviedb.org/t/p/original/46SaXTbn0ij1kClFAlaosDoHXrr.jpg', 'Yaz, Sammy ile Ben\'i korunmakta olan adada gÃ¶rÃ¼nce ÅŸaÅŸÄ±rÄ±r ve onlara adayÄ± gezdirir. Peki, burasÄ± gerÃ§ekten de \"dinozorsuz alan\" mÄ±dÄ±r, bÃ¶yle bir ÅŸey mÃ¼mkÃ¼n mÃ¼dÃ¼r?', 6, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (7, 'Ã‡iftlikte', 'https://www.themoviedb.org/t/p/original/eNs3K92SD95QA3MpPniNI7mskIq.jpg', 'Davetsiz misafirler, Sammy\'nin Ã§iftliÄŸindeki mutlu buluÅŸmayÄ± bozar. Gizemli bir haritada Brooklynn\'in bÄ±raktÄ±ÄŸÄ± ÅŸifreli bir ipucu vardÄ±r. Peki ama bunun anlamÄ± nedir?', 3, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (8, 'O Gece', 'https://www.themoviedb.org/t/p/original/2hQMqvrYjahvx72E5dzhsMBgtTe.jpg', 'Gizemli bir yabancÄ±, Kenji ile Darius\'a bildiÄŸi her ÅŸeyi anlatÄ±nca o gece birÃ§ok gerÃ§ek su yÃ¼zÃ¼ne Ã§Ä±kar. Bu esnada diÄŸerleri ya batacak ya yÃ¼zecektir.', 7, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (9, 'Rehabilitasyon Evi', 'https://www.themoviedb.org/t/p/original/5hWALmh2KLSu6U9j83EkTuoTVTX.jpg', 'Ben ve Sammy, Kral Dino\'nun Tarih Ã–ncesi Oyun AlanÄ±\'nda mola verir. Kenji, kendisine Ã¼ltimatom veren babasÄ±yla yÃ¼zleÅŸir.', 5, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (10, 'Mola Yeri', 'https://www.themoviedb.org/t/p/original/bZpdySpn4DIZiZNeqquN5uqev74.jpg', 'Korkutucu bir kovalamaca Ben\'in, Nublar AltÄ±lÄ±sÄ±\'nÄ±n takip edildiÄŸi konusundaki teorisini gÃ¼Ã§lendirir. Fakat onlarÄ± kovalayan kimdir? Dairus, Teksas\'a gitmeyi kabul eder.', 2, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (11, 'BaÅŸlangÄ±cÄ±n Sonu', 'https://www.themoviedb.org/t/p/original/97AsqfyhFChgRo3jZFTnaJ9Ksgh.jpg', 'KarmaÅŸa, kaos ve Ã¶lÃ¼mcÃ¼l bir karÅŸÄ±laÅŸma. Kamp Ailesi gizemi Ã§Ã¶zmeye Ã§ok yaklaÅŸmÄ±ÅŸtÄ±r ama Ã¶nce canlarÄ±nÄ± kurtarmalarÄ± gerekir.', 10, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (12, 'ArtÃ§Ä± SarsÄ±ntÄ±', 'https://www.themoviedb.org/t/p/original/eDqHedIgMyQeQ3B2FLgKRToUILA.jpg', 'Isla Nublar\'Ä±n tehlikelerinden kaÃ§tÄ±ktan yÄ±llar sonra, Darius ve arkadaÅŸlarÄ± yine dinozorlarÄ±n arasÄ±nda yaÅŸamaktadÄ±r. AynÄ± zamanda yÄ±kÄ±cÄ± bir kaybÄ±n yasÄ±nÄ± tutmaktadÄ±rlar.', 1, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (13, 'Sisin Ä°Ã§ine DoÄŸru', 'https://www.themoviedb.org/t/p/original/h34ANOg0mhEcVRBF7rg3sufajKf.jpg', 'Sisin iÃ§erisinde kamyonlarÄ± izleyen dostlar, dinozorlarla dolu bir depoya ulaÅŸÄ±r. Bu devasa bir operasyondur ama acaba arkasÄ±nda kim vardÄ±r?', 9, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (14, 'KardeÅŸler', 'https://www.themoviedb.org/t/p/original/ooyglFXTRxzRuM6c7Nb7pQNBBJ8.jpg', 'Ekip, geÃ§miÅŸ yÃ¼zÃ¼nden hÃ¢lÃ¢ Darius\'u suÃ§layan Kenji\'yi uyarmak iÃ§in Colorado\'ya gelir. Sammy ile Ben, Yaz\'i aramak Ã¼zere gruptan ayrÄ±lÄ±r.', 4, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (15, 'O DÃ¼ÅŸÃ¼ÅŸ', 'https://www.themoviedb.org/t/p/original/3T05kmYiW4dGwqWDUkGuNWPG1eR.jpg', 'Ben, Yaz ve Sammy, TVD\'de bazÄ± cevaplarÄ± ararken eski bir dostlarÄ±nÄ± bulur. Darius ile Kenji, Brooklynn\'in telefonunda ÅŸoke edici bir ÅŸey gÃ¶rÃ¼r.', 8, 6, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (16, 'AÃ§Ä±k ArtÄ±rma', 'https://m.media-amazon.com/images/M/MV5BMzFhOTQyZTgtZWE4MC00M2ZhLThjZTYtZmE0ODUyOTYzZWYxXkEyXkFqcGc@._V1_QL75_UX500_CR0,0,500,281_.jpg', 'Vedat ve Evren, Ã¼nlÃ¼ bir ÅŸefin Ã§ok Ã¶zel yemeklerinin aÃ§Ä±k artÄ±rma ile satÄ±ldÄ±ÄŸÄ± bir etkinliÄŸe katÄ±lÄ±rlar. Fakat amaÃ§larÄ± yemeklerin tadÄ±na bakmak deÄŸil, geÃ§miÅŸten kalan yÃ¼klÃ¼ bir borcu tahsil etmektir.', 1, 10, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (17, 'HÄ±z TÃ¼mseÄŸi', 'https://www.themoviedb.org/t/p/original/yCsD3piEYNeYLkwEAhV1phYOglP.jpg', 'Bir arabanÄ±n bir rampadan uÃ§masÄ± gerekiyor. UÃ§arken tavanÄ±nda bir adam var ve aÅŸaÄŸÄ±da Ã§alÄ±ÅŸan yol iÅŸÃ§ilerinin Ã¼zerinden atlayacak. Filmin en can alÄ±cÄ± sahnesinde bilirkiÅŸi olarak Ã§aÄŸrÄ±lan isimler Vedat ve Evren.', 3, 10, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (18, 'Deli Gezdirme', 'https://m.media-amazon.com/images/M/MV5BMzBlNmI4NWItYTgyNy00ZTNlLTg0ZTQtZjAwMGI3ODNlMWRiXkEyXkFqcGc@._V1_QL75_UX500_CR0,0,500,281_.jpg', 'Gezdirilmesi gereken bir deli vardÄ±r ve olaylar geliÅŸir.', 2, 10, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (19, 'Audition', 'https://www.themoviedb.org/t/p/original/z9GzOTvsSCAauxL1hvZmrGhPtdr.jpg', 'Vedat ve Evren bu kez Ã§ekimlerine baÅŸlanacak bir filmin ismini deÄŸiÅŸtirmekle gÃ¶revlendirilir. YÃ¶netmeni ikna etmek iÃ§in karÅŸÄ±sÄ±na Ã§Ä±ktÄ±klarÄ±nda, ortalÄ±k tam bir film setine dÃ¶ner.', 4, 10, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (20, 'Apartman ToplantÄ±sÄ±', 'https://www.themoviedb.org/t/p/original/eB9iVzosoEauZWA28qN91HfvXo0.jpg', 'Vedat ve Evren, Sermet Beyâ€™in sevgilisinin erkek kardeÅŸinin sorununu Ã§Ã¶zmek iÃ§in bir apartmana girerler. Ancak kendilerini bir anda, birbiriyle hiÃ§ alakasÄ± olmayan sakinlerin, birbirinden garip dertlerinin konuÅŸulduÄŸu bir apartman toplantÄ±sÄ±nda bulurlar.', 7, 10, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (21, 'Kan KaybÄ±', 'https://www.themoviedb.org/t/p/original/iQBeGANb246E9BtJmCfeVBveWO4.jpg', 'Vedat ve Evren vurulmanÄ±n etkisiyle kendilerini bir kaldÄ±rÄ±mda bulurlar. KafalarÄ± bir gidip bir gelen ikili, acaba kan kaybetmeden yaralarÄ±nÄ± mÄ± iyileÅŸtirecekler, yoksa bÃ¶reklerine pudra ÅŸekeri mi serpiÅŸtirecekler?', 9, 10, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (22, 'SaksÄ±ya Dikkat Edin', 'https://www.themoviedb.org/t/p/original/naDPo31NbmWJqq4WKSDEoLpR4gQ.jpg', 'Bu bÃ¶lÃ¼mde Vedat ve Evren, Yasemin HanÄ±mâ€™Ä± falcÄ±ya gÃ¶tÃ¼rmekle gÃ¶revlendirilmiÅŸtir. GÃ¶zÃ¼nÃ¼n iÃ§ine iÃ§ine bakÄ±p her ÅŸeyi bilen falcÄ± karÅŸÄ±sÄ±nda, fala inanmayan Vedat ve Evren falsÄ±z kalabilecekler mi?', 5, 10, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (23, 'KaÃ§Ä±ÅŸ SÃ¼rÃ¼cÃ¼sÃ¼', 'https://www.themoviedb.org/t/p/original/osdMDwDc3yxf88fWZqBdyiJKw8x.jpg', 'Vedat, Evren ve Yasemin HanÄ±m bu kez kendilerini arabada bilmedikleri bir dÃ¼ÅŸmandan kaÃ§arken bulurlar. Acaba aksiyon filmlerinde gÃ¶rdÃ¼kleri gerÃ§ek hayatta iÅŸlerine yarayacak mÄ±, yoksa Vedatâ€™Ä±n iÃ§gÃ¼dÃ¼leri filmleri aratmayacak mÄ±?', 6, 10, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (34, '1', '', '', 1, 11, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (35, '1. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/hIKf9h9Eexpn3UY1L9R5ppfXuJZ.jpg', 'Adana\'dan bÃ¼yÃ¼k hayallerle Ä°stanbul\'a gelen Ã¼Ã§ arkadaÅŸ yeni bir mahallede temiz bir baÅŸlangÄ±Ã§ yapmak ister. Ancak bela yakalarÄ±nÄ± bÄ±rakmaz.', 1, 1, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (36, '2. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/mqQvLrN1PpuBOQ5bajn3hmth0fL.jpg', 'Ã–mer, Tufan ve Poyraz her ÅŸeye raÄŸmen hayatlarÄ±nÄ± yoluna sokmaya Ã§alÄ±ÅŸÄ±rken mahallede baÅŸ etmeleri gereken yeni bir tehlike doÄŸar.', 2, 1, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (37, '3. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/zVaYcbLiwM0Ph8wbqFYSUD0OqDb.jpg', 'AyÄ±k olun, aÄŸÄ±zlarÄ±nÄ±n tadÄ±nÄ± kaÃ§Ä±ranlar, elbet karÅŸÄ±lÄ±ÄŸÄ±nÄ± alacaklar.', 3, 1, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (38, '4. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/g8nnrHHSrkMC2GiMYgg0AnFnWOg.jpg', 'Mahalledeki tehlike gÃ¼n geÃ§tikÃ§e bÃ¼yÃ¼r. ÃœÃ§ arkadaÅŸ, kendini savunmak iÃ§in yeni yollar bulmak zorunda kalÄ±r.', 4, 1, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (39, '5. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/d842LavRQEXbxi6PzNCVC6kKDUv.jpg', 'YiÄŸit mahalleyi yangÄ±n yerine Ã§evirir, herkeste panik hakimdir. Mahallede klibin Ã§ekileceÄŸi gÃ¼n yaklaÅŸÄ±rken, Ã–mer\'in son bir planÄ± vardÄ±r.', 5, 1, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (40, '1', 'https://m.media-amazon.com/images/M/MV5BNTZkMmQwNWItM2NkMC00OTM3LTgzZWQtMDMwYzY5N2MyM2Y2XkEyXkFqcGc@._V1_QL75_UX1000_CR0,3,1000,563_.jpg', '', 1, 15, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (42, 'Emil Blonsky Ä°nsanlara KarÅŸÄ±', 'https://www.themoviedb.org/t/p/original/m8yN9B7UVnNv15G2F7i8WUgUNiO.jpg', 'She-Hulk, Abomination olarak da bilinen Emil Blonsky\'i temsil etmektedir.', 3, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (43, 'SÄ±Ã§ra ve ParÃ§ala', 'https://www.themoviedb.org/t/p/original/hCmeBsFBqb7pW01RlmyV32oBdAb.jpg', 'She-Hulk, Ã¶zel yapÄ±m kostÃ¼mÃ¼ndeki bir sorundan dolayÄ± yaralanan Leap-Frog\'u temsil eder.', 8, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (44, 'Asi, YeÅŸil ve Kotla Ã‡ok Åžekil', 'https://www.themoviedb.org/t/p/original/aAsQynnt7PLaEep4knZi4qDaqYR.jpg', 'She-Hulk, â€œShe-Hulkâ€ isminin marka hakkÄ± ihlali gerekÃ§esiyle kendisine dava aÃ§Ä±ldÄ±ÄŸÄ±nÄ± Ã¶ÄŸrenir.', 5, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (45, 'Sadece Jen', 'https://www.themoviedb.org/t/p/original/Au0lAIG4U9b5VxarSZgqsUboRtb.jpg', 'Jen nedime olunca, She-Hulk haline Ã¶zel sorunlar stresli bir duruma yaratÄ±r.', 6, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (46, 'Bu Kimin Dizisi?', 'https://www.themoviedb.org/t/p/original/lK7eyB70k8NJiQA4pfi68aEDFBv.jpg', 'Jen Walters kendini hukuki bir sÄ±kÄ±ntÄ± iÃ§inde bulur ve hayatÄ±nÄ± toplarlamaya Ã§alÄ±ÅŸÄ±r.', 9, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (47, 'SÃ¼perinsan Hukuku', 'https://www.themoviedb.org/t/p/original/iTZOuOLeNN54Gm8piWSnLmN265V.jpg', 'Jen, prestijli bir hukuk firmasÄ±nda iÅŸe alÄ±nÄ±r, ancak She-Hulk olarak Ã§alÄ±ÅŸmalÄ± ve karmaÅŸÄ±k bir mÃ¼vekkili temsil etmelidir.', 2, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (48, 'Bu GerÃ§ek Sihir DeÄŸil Mi?', 'https://www.themoviedb.org/t/p/original/l7fPzC3dYqcZDLccNpAA6G4ayvO.jpg', 'Wong, Mistik SanatlarÄ± izinsiz ÅŸekilde kullanmasÄ±ndan dolayÄ± bir sihirbaza dava aÃ§ar.', 4, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (49, 'Normal Derecede Ã–fkeli', 'https://www.themoviedb.org/t/p/original/AhvWtFjxuJexnYM6lCYTNeFCKYZ.jpg', 'Ã‡Ä±lgÄ±n bir kazada sÃ¼per gÃ¼Ã§ler kazanan Jen\'in hayatÄ± altÃ¼st olur.', 1, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (50, 'Ä°nziva', 'https://www.themoviedb.org/t/p/original/8SnKuRKeAjTjehmKk2xA4S2A3uz.jpg', 'Jen, Blonsky\'nin inziva alanÄ±nÄ± ziyaret eder, yeni arkadaÅŸlar edinir ve She-Hulk\'la baÄŸlantÄ± kurar.', 7, 18, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (51, '2', 'https://m.media-amazon.com/images/M/MV5BZGEyZmVmY2EtMzU5Ni00ZGU2LWFmNGItYzNkNmZkMjExZGUxXkEyXkFqcGc@._V1_QL75_UY281_CR1,0,500,281_.jpg', '', 2, 15, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (52, '3', 'https://m.media-amazon.com/images/M/MV5BZGFhNmM4NTUtMTI1Zi00Mjg2LTk0ZjAtNWY4ZmE4ZWRjMTcxXkEyXkFqcGc@._V1_QL75_UY281_CR2,0,500,281_.jpg', '', 3, 15, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (53, '4', 'https://m.media-amazon.com/images/M/MV5BZTgwMDY4YTUtODVkZi00YzQzLTgyNjAtODAxZTVjZDkyYWQ3XkEyXkFqcGdeQXVyNDg4MjkzNDk@._V1_QL75_UY281_CR1,0,500,281_.jpg', '', 4, 15, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (54, '5', 'https://m.media-amazon.com/images/M/MV5BYjg5ZDgwZmMtMzVhOS00MzQ4LWE2ZDYtMDMzOWY1NTUzMjczXkEyXkFqcGdeQXVyNDg4MjkzNDk@._V1_QL75_UX500_CR0,0,500,281_.jpg', '', 5, 15, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (55, '6', 'https://m.media-amazon.com/images/M/MV5BMWJkNDExOGMtZjk2OS00OWI5LTgzOWItZDZiMjczOWMzZWJkXkEyXkFqcGdeQXVyNDg4MjkzNDk@._V1_QL75_UX500_CR0,0,500,281_.jpg', '', 6, 15, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (56, 'BÃ¶lÃ¼m 1', 'https://www.themoviedb.org/t/p/original/84y60T8qT6xnLUW1M73Zy1c3Pne.jpg', 'Yeni seÃ§ilen BaÅŸkan verdiÄŸi sÃ¶zden dÃ¶nÃ¼nce Frank ve Claire sadakatlerini tÃ¼mÃ¼yle rafa kaldÄ±rmaya ve kurallarÄ± bir kenara bÄ±rakmaya karar verirler.', 1, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (57, 'BÃ¶lÃ¼m 2', 'https://www.themoviedb.org/t/p/original/ciUOYOPKco839FIqAygLHHMZVY3.jpg', 'Frank, Beyaz Saray\'Ä± zor duruma dÃ¼ÅŸÃ¼recek bir hikaye yayÄ±nlamasÄ± iÃ§in genÃ§ gazeteci Zoe Barnes\'Ä± kullanÄ±r. Claire iÅŸinde soÄŸuk kanlÄ± bir giriÅŸimde bulunur.', 2, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (58, 'BÃ¶lÃ¼m 7', 'https://www.themoviedb.org/t/p/original/vj7hlPqAKTHrQxCMmp74G04VPPY.jpg', 'Frank Ã¶nemli bir mÃ¼cadeleyi kazanÄ±r ancak bu onu duraklatmaz. Peter geÃ§miÅŸiyle yÃ¼zleÅŸmek zorundadÄ±r. Stamper bir sÄ±rrÄ± Ã¶rtbas eder.', 7, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (59, 'BÃ¶lÃ¼m 4', 'https://www.themoviedb.org/t/p/original/4GFLn4esPyjJJBve4JS78ZCzcG7.jpg', 'Frank Kongre liderliÄŸini sarsar. Peter Russo politika ve aile arasÄ±nda seÃ§im yapmak zorundadÄ±r.', 4, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (60, 'BÃ¶lÃ¼m 3', 'https://www.themoviedb.org/t/p/original/1KhWJwq9Ag61gQFviuZhThfJITi.jpg', 'Frank, seÃ§im bÃ¶lgesindeki bir kriz nedeniyle sendika gÃ¶rÃ¼ÅŸmelerini yarÄ±da bÄ±rakmak zorunda kalÄ±r. Zoe gazetecilikte yÃ¼kselmek iÃ§in pazarlÄ±klara giriÅŸir.', 3, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (61, 'BÃ¶lÃ¼m 10', 'https://www.themoviedb.org/t/p/original/eaN6dYqtkcJAvvZcMbR5T2w2hwj.jpg', 'Frank dÃ¶rt bir yandan ateÅŸ altÄ±ndadÄ±r. Claire kendisine meydan okur, Zoe yeni biriyle beraber olmaya baÅŸlar ve Peter bir ultimatomda bulunur.', 10, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (62, 'BÃ¶lÃ¼m 11', 'https://www.themoviedb.org/t/p/original/tVxl2dA9O8ajENIaHhwHo69fk5y.jpg', 'Claire eski sevgilisiyle yakÄ±nlaÅŸÄ±r. Peter kendi sorunlarÄ±yla boÄŸuÅŸmaktadÄ±r. Frank geri dÃ¶nÃ¼ÅŸÃ¼ olmayan noktayÄ± geÃ§er.', 11, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (63, 'BÃ¶lÃ¼m 5', 'https://www.themoviedb.org/t/p/original/33pCcjWAYRcgXWKhWk0wPXp5Mfe.jpg', 'Frank\'in EÄŸitim YasasÄ± iÃ§in verdiÄŸi mÃ¼cadele Claire\'in isteklerini tehlikeye sokar. Zoe iÅŸle eÄŸlenceyi birbirine karÄ±ÅŸtÄ±rÄ±r.', 5, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (64, 'BÃ¶lÃ¼m 8', 'https://www.themoviedb.org/t/p/original/aQjFqJtsyySgtOt5273N2GAQIaJ.jpg', 'Frank\'e mezun olduÄŸu okul tarafÄ±ndan onur Ã¶dÃ¼lÃ¼ verilir, bu arada Peter Philadelphia\'ya dÃ¶ner. Her iki adam da yarÄ±m kalan hesaplarÄ±yla uÄŸraÅŸÄ±r.', 8, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (65, 'BÃ¶lÃ¼m 13', 'https://www.themoviedb.org/t/p/original/81SJ7FlPo22oIU7MGASFx9tJ9O3.jpg', 'Frank planÄ±nÄ± sapmadan yÃ¼rÃ¼tmek iÃ§in Ã§abalar. Claire eski ve yeni arasÄ±nda yapacaÄŸÄ± seÃ§imde zorlanÄ±r. Zoe ciddi bir tehditte bulunur.', 13, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (66, 'BÃ¶lÃ¼m 6', 'https://www.themoviedb.org/t/p/original/oTvZpRnBvXjpvI69grcLzwb0LhT.jpg', 'Frank greve giden Ã¶ÄŸretmenlere sert tepki gÃ¶sterir. Claire Ã¶lÃ¼m dÃ¶ÅŸeÄŸinde yapÄ±lan bir itirafa ÅŸahit olur.', 6, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (67, 'BÃ¶lÃ¼m 9', 'https://www.themoviedb.org/t/p/original/zgZg8gzvDa0yqvagURKSA706FvX.jpg', 'Russo, BaÅŸkan YardÄ±mcÄ±sÄ± Matthews\'la kampanya iÃ§in yola Ã§Ä±kar. Frank ve Stamper Kongre\'de destek toplamaya Ã§alÄ±ÅŸÄ±r. Claire kendi Ã§Ä±karlarÄ±nÄ±n peÅŸindedir.', 9, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (68, 'BÃ¶lÃ¼m 12', 'https://www.themoviedb.org/t/p/original/nV48z5uXfJH2DIGim4eRSldd02C.jpg', 'Frank tahmin edilemeyecek dolambaÃ§lÄ± bir yol izlemek zorundadÄ±r. Zoe, Lucas ve Janine gerÃ§eÄŸe yaklaÅŸmaktadÄ±r.', 12, 19, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (69, 'Pilot BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/oWaKdUeMOlVZem3v9DWsdDGlTuY.jpg', 'Rick, Mortyâ€™yi â€˜mega-aÄŸaÃ§â€™ tohumlarÄ± bulmak iÃ§in baÅŸka bir boyuta gÃ¶tÃ¼rÃ¼r. Jerry ve Beth ise, Rick oÄŸullarÄ±na kÃ¶tÃ¼ Ã¶rnek oluyor diye tartÄ±ÅŸÄ±rlar.', 1, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (70, 'Rick\'miÅŸ Dakika', 'https://www.themoviedb.org/t/p/original/HaTpHoQw2DWFAtHgGKn4gLOEaX.jpg', 'TVâ€™den sÄ±kÄ±lan Rick, baÅŸka boyutlardan yayÄ±n alan bir kablo baÄŸlantÄ±sÄ± kurar. Herkes, Ã¶zel gÃ¶zlÃ¼kler takarak alternatif gerÃ§eklikteki hallerini izler.', 8, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (71, 'Meeseeks Hizmetinizde', 'https://www.themoviedb.org/t/p/original/9nh9ZpxOyCJMD73biS2h3CvHfm2.jpg', 'Morty, Rickâ€™in saÃ§malÄ±klarÄ±ndan bÄ±kmÄ±ÅŸtÄ±r. Bu yÃ¼zden sÃ¶zÃ¼m ona gÃ¼venli bir maceraya Ã§Ä±kmak ister. Jerry, golf yardÄ±mcÄ±larÄ± olarak tuhaf yaratÄ±klarÄ± baÅŸÄ±na toplar.', 5, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (72, 'AÅŸk Ä°ksiri', 'https://www.themoviedb.org/t/p/original/hY750JVvL7K9KQN9lcqPTqcUEkN.jpg', 'Mortyâ€™nin bir kÄ±zÄ± elde etmek iÃ§in kullandÄ±ÄŸÄ± aÅŸk iksiri, virÃ¼s olup tÃ¼m dÃ¼nyayÄ± ele geÃ§irir. Rick bu pisliÄŸi temizlemek zorundadÄ±r, ama tabii baÅŸka bir pislikle.', 6, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (73, 'Rick\'sli Ä°ÅŸ', 'https://www.themoviedb.org/t/p/original/mLJbMSLaB8CZmr07GJGH9TiG4PL.jpg', 'Jerry ve Beth, Titanicâ€™in batÄ±ÅŸÄ±nÄ±n canlandÄ±rÄ±lacaÄŸÄ± etkinliÄŸe katÄ±lmak Ã¼zere evden giderler. Rick ve Summerâ€™Ä±n evdeki Ã§Ä±lgÄ±n partileri kontrolden Ã§Ä±kar.', 11, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (74, 'Rick\'siz Bir Åžey Geliyor', 'https://www.themoviedb.org/t/p/original/daA9q3U3ibIcm5OGuklySeIsQWV.jpg', 'Summerâ€™Ä±n ÅŸeytanÄ±n dÃ¼kkÃ¢nÄ±nda Ã§alÄ±ÅŸmasÄ± Rickâ€™i tedirgin eder. Jerry ve Morty, gezegen olup olmadÄ±ÄŸÄ± tartÄ±ÅŸÄ±lan Plutoâ€™ya giderler.', 9, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (75, 'Sanal GerÃ§ekler', 'https://www.themoviedb.org/t/p/original/9hbDdbHeHIuquiwQ5zdux57nYTk.jpg', 'UzaylÄ±lar, Rick, Morty ve Jerryâ€™yi alternatif bir gerÃ§ekliÄŸe gÃ¶nderirler. Rick bir Ã§Ã¶zÃ¼m ararken, hiÃ§bir ÅŸeyin farkÄ±nda olmayan Jerry yeni reklam sloganÄ±yla meÅŸguldÃ¼r.', 4, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (76, 'Rick\'inci TÃ¼rden Rick\'leÅŸmeler', 'https://www.themoviedb.org/t/p/original/8gOouaPQhfB8cC01sYyFLYgTcRq.jpg', 'Rick tam kahvaltÄ±sÄ±nÄ±n tadÄ±nÄ± Ã§Ä±karÄ±rken bir grup alternatif Rick tarafÄ±ndan kaÃ§Ä±rÄ±lÄ±r ve bu Rickâ€™lere karÅŸÄ± yapÄ±lan suÃ§lamalar yÃ¼zÃ¼nden kendini mahkemede bulur.', 10, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (77, 'Gazorpazorp\'u BÃ¼yÃ¼tmek', 'https://www.themoviedb.org/t/p/original/j7qn7TIOSQOHZBgVi4NKnTpIcgM.jpg', 'Mortyâ€™nin seks robotundan bir Ã§ocuÄŸu olur. Rick ve Summer, robotun gezegenini ziyaret ederler, Ã§ocuksa burada sadece birkaÃ§ gÃ¼n iÃ§inde bÃ¼yÃ¼yerek bir yetiÅŸkine dÃ¶ner.', 7, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (78, 'Teknolojik KÃ¶pek', 'https://www.themoviedb.org/t/p/original/r3CzGadu9EEunFtuTqmXxMRkX5V.jpg', 'Rick, ailenin kÃ¶peÄŸi Snufflesâ€™Ä± akÄ±llÄ± yapacak bir alet icat eder. Ama sonuÃ§ pek iyi olmaz. Rick ve Morty, Mortyâ€™nin matematik Ã¶ÄŸretmeninin rÃ¼yalarÄ±nÄ± talan ederler.', 2, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (79, 'Anatomi ParkÄ±', 'https://www.themoviedb.org/t/p/original/3cp6QrExDBQUFGcOu43NBtaugNY.jpg', 'Morty kendini, evsiz bir adamÄ±n iÃ§inde yer alan tuhaf bir eÄŸlence parkÄ±nda bulur. Jerryâ€™nin anne ve babasÄ±, ortak sevgililerini aileye tanÄ±ÅŸtÄ±rÄ±rlar.', 3, 26, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (80, '1', '', '', 1, 33, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (81, 'KÃ¶pek', 'https://www.themoviedb.org/t/p/original/nSeWXNyYnP5ZKz5YinMXfxUXmb6.jpg', 'Vedat ve Evrenâ€™in bu seferki aÅŸÄ±rÄ± ciddi gÃ¶revi patronun sevgilisi iÃ§in kÃ¼Ã§Ã¼k bir kÃ¶pek kaÃ§Ä±rmak. KÃ¶pek insanÄ±n dostuysa kÃ¶pek kaÃ§Ä±rmak ahlaki midir? Daha da Ã¶nemlisi bÃ¶yle bir gÃ¶revde ahlaki davranmak gerekli midir?', 2, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (82, 'KaÃ§Ä±ÅŸ SÃ¼rÃ¼cÃ¼sÃ¼', 'https://www.themoviedb.org/t/p/original/osdMDwDc3yxf88fWZqBdyiJKw8x.jpg', 'Vedat, Evren ve Yasemin HanÄ±m bu kez kendilerini arabada bilmedikleri bir dÃ¼ÅŸmandan kaÃ§arken bulurlar. Acaba aksiyon filmlerinde gÃ¶rdÃ¼kleri gerÃ§ek hayatta iÅŸlerine yarayacak mÄ±, yoksa Vedatâ€™Ä±n iÃ§gÃ¼dÃ¼leri filmleri aratmayacak mÄ±?', 6, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (83, 'SaksÄ±ya Dikkat Edin', 'https://www.themoviedb.org/t/p/original/naDPo31NbmWJqq4WKSDEoLpR4gQ.jpg', 'Bu bÃ¶lÃ¼mde Vedat ve Evren, Yasemin HanÄ±mâ€™Ä± falcÄ±ya gÃ¶tÃ¼rmekle gÃ¶revlendirilmiÅŸtir. GÃ¶zÃ¼nÃ¼n iÃ§ine iÃ§ine bakÄ±p her ÅŸeyi bilen falcÄ± karÅŸÄ±sÄ±nda, fala inanmayan Vedat ve Evren falsÄ±z kalabilecekler mi?', 5, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (84, 'Audition', 'https://www.themoviedb.org/t/p/original/z9GzOTvsSCAauxL1hvZmrGhPtdr.jpg', 'Vedat ve Evren bu kez Ã§ekimlerine baÅŸlanacak bir filmin ismini deÄŸiÅŸtirmekle gÃ¶revlendirilir. YÃ¶netmeni ikna etmek iÃ§in karÅŸÄ±sÄ±na Ã§Ä±ktÄ±klarÄ±nda, ortalÄ±k tam bir film setine dÃ¶ner.', 4, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (85, 'KorkutmanÄ±n Dozu', 'https://www.themoviedb.org/t/p/original/miBsAdZL7UTJZoVsYS1rjTJsH3L.jpg', 'Vedat ve Evren, patrona borcunu Ã¶deyememiÅŸ bir alacaklÄ±yÄ± korkutmak Ã¼zere gÃ¶revlendirilir. Ancak korkutmak gÃ¶receli bir kavramdÄ±r. KorkutmanÄ±n dozu nedir? Ä°sim vermek mi gerekir yoksa anonim bir dayak yeterli midir?', 1, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (86, 'HesaplaÅŸma', 'https://www.themoviedb.org/t/p/original/pscnLAFERfXMxuqfL9QTAaUNk4q.jpg', 'Vedat ve Evren, Sermet Beyâ€™den hesap sormak Ã¼zere yola Ã§Ä±karlar. Her atÄ±ÅŸÄ± â€˜headshotâ€™ olan Vedat, geÃ§ kalmayÄ± hiÃ§ sevmeyen ama 33 sene geÃ§ kalmayÄ± baÅŸaran Sermet Bey, hayata bilgiyle tutunmaya Ã§alÄ±ÅŸan Evrenâ€¦ Acaba bu hesaplaÅŸmanÄ±n kazananÄ± kim olacak?', 10, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (87, 'Kan KaybÄ±', 'https://www.themoviedb.org/t/p/original/iQBeGANb246E9BtJmCfeVBveWO4.jpg', 'Vedat ve Evren vurulmanÄ±n etkisiyle kendilerini bir kaldÄ±rÄ±mda bulurlar. KafalarÄ± bir gidip bir gelen ikili, acaba kan kaybetmeden yaralarÄ±nÄ± mÄ± iyileÅŸtirecekler, yoksa bÃ¶reklerine pudra ÅŸekeri mi serpiÅŸtirecekler?', 9, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (88, 'Apartman ToplantÄ±sÄ±', 'https://www.themoviedb.org/t/p/original/eB9iVzosoEauZWA28qN91HfvXo0.jpg', 'Vedat ve Evren, Sermet Beyâ€™in sevgilisinin erkek kardeÅŸinin sorununu Ã§Ã¶zmek iÃ§in bir apartmana girerler. Ancak kendilerini bir anda, birbiriyle hiÃ§ alakasÄ± olmayan sakinlerin, birbirinden garip dertlerinin konuÅŸulduÄŸu bir apartman toplantÄ±sÄ±nda bulurlar.', 7, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (89, '8. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/3N2cbEb9FrFbtGyL1FujTCzPBCr.jpg', 'Vedat, Evren ve tÃ¼m ekip, patron Sermet Beyâ€™in talebi Ã¼zerine bir kaynaÅŸma yemeÄŸinde toplanÄ±rlar. Vedatâ€™Ä±n duygu yÃ¼klÃ¼ anlamsÄ±z konuÅŸmasÄ±, ekibin kaynaÅŸmasÄ± derken felaketi Ã§ekmek bu ekibin olmazsa olmazÄ±â€¦', 8, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (90, 'Akraba', 'https://www.themoviedb.org/t/p/original/yCsD3piEYNeYLkwEAhV1phYOglP.jpg', 'Vedat ve Evren bu kez, Vedatâ€™Ä±n yakÄ±n arkadaÅŸÄ± olan Kenanâ€™a yardÄ±m etmek Ã¼zere yola dÃ¼ÅŸerler. AÅŸkÄ± uÄŸruna baÅŸÄ± derde giren Kenanâ€™Ä± koruyacak ve onun sahipsiz olmadÄ±ÄŸÄ±nÄ± gÃ¶stereceklerdir. Fakat bu gÃ¶revde acaba onlara kim sahip Ã§Ä±kacaktÄ±r?', 3, 8, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (96, '1. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/ming8suHAIsAnGkPSEw20c22NOl.jpg', '', 1, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (97, '2. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/rjGTTGbuH6TLHh8fW5IfJm3fWcL.jpg', '', 2, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (98, '3. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/2DV5iopftsebx1xMID7W40etHgA.jpg', '', 3, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (99, '13. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/bIQIqFUnQqSrZDB4R8xmMRGxNgF.jpg', '', 13, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (100, '12. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/LZ0hjLtmxJf0VAmW2U9fXi8JYj.jpg', '', 12, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (101, '6. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/pzn0M0pTutBbD0WJSosSp2Jx3UH.jpg', '', 6, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (102, '4. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/2oWhj6uYdDIz133yHwYsFyrxIHF.jpg', '', 4, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (103, '5. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/Alkgr6RlI4MkGHyPHuUR29MoxEd.jpg', '', 5, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (104, '7. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/mSCaieZM7NLafoBsY8AK12bfdZY.jpg', '', 7, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (105, '8. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/urPjrVaBSB6v3OkVIy6oh85caRC.jpg', '', 8, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (106, '11. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/gHYpsjRnZUI8bPlRJZ2Z6lA21CJ.jpg', '', 11, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (107, '16. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/thiiRbb4tMmMpt7gACWJz91R5o9.jpg', '', 16, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (108, '14. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/6dA9AEfLgF9K9OEZQ4eR7c0kjDc.jpg', '', 14, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (109, '17. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/y0SORhC8kwHKGhwVpRItXlSfKa.jpg', '', 17, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (110, '19. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/5Z4f6hnJt30Dky4RnY6xYPgh6q8.jpg', '', 19, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (111, '9. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/o6ppj2rshJmadfxzsvtK0GabwUv.jpg', '', 9, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (112, '20. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/gTpPdj23d7akj90u2lRRcrzdehB.jpg', '', 20, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (113, '10. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/wxJVgAEEipnFwPytKKiMvxelMnp.jpg', '', 10, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (114, '15. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/vjtZTtZdF83wMjL6kmDDzHvWJkr.jpg', '', 15, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (115, '22. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/arWbs85HQS1gSdIogd7x7dnJd3V.jpg', '', 22, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (116, '21. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/q136hrtkrWsxYUdnScWRnZ1rJ5e.jpg', '', 21, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (117, '18. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/jZZs4UFZhajthdhEnh7gNxUhhyt.jpg', '', 18, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (118, '23. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/5cGuCi8m2p7iDoMvNrLL2earDzE.jpg', '', 23, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (119, '24. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/nhDvEmObzv6IDBTXD6picVzIOnu.jpg', '', 24, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (120, '25. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/oNa7aDtChIpDBDH5UzS2wR5fN3c.jpg', '', 25, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (121, '26. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/fgigUxZON9NsyU4SO4Z250KRu6N.jpg', '', 26, 40, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (122, '4. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/30EH2dkf9oX7vGQkE4SlOPoL0K4.jpg', '', 4, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (123, '3. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/5gcHchmrjRPhj8jd8UWRfhwUIoQ.jpg', '', 3, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (124, '8. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/2gp4eOvaliyz5CVgUpRRDPye3TW.jpg', '', 8, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (125, '7. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/ihNKISOvf26cpVipm6tIdcuYCDy.jpg', '', 7, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (126, '13. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/uw95pJoO0L4BhqLjlIrrMyC85eh.jpg', '', 13, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (127, '9. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/4wZuPGJ6iNorFxAfhsv3eyQJJLx.jpg', '', 9, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (128, '1. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/rssmCLOnCjTMKt5VYCWusJuYAYc.jpg', '', 1, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (129, '11. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/36gB5cLopnL6I2I4kp8FBye3j1.jpg', '', 11, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (130, '2. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/6LqL5GUsM990I5PKRGAtPhizNIW.jpg', '', 2, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (131, '12. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/mbRcYVy5P2QRhXc2bLTnygptstA.jpg', '', 12, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (132, '6. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/bEVNe7jf2UiljCaaXIcbW51ifkH.jpg', '', 6, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (133, '14. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/zi1trcvcwJMylS1E0VEkuy14Box.jpg', '', 14, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (134, '5. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/iuXcD4PPvDReGW5DcrZKrp94FK0.jpg', '', 5, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (135, '10. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/3plYzauDcTlsQWFU9DHIALMsMAd.jpg', '', 10, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (136, '15. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/f1pXemYUoVGGyQUhxnMDmH7R1bN.jpg', '', 15, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (137, '16. BÃ¶lÃ¼m', 'https://www.themoviedb.org/t/p/original/lhMopcLnaOGctIfpugd9ZLjZ6Hq.jpg', '', 16, 42, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (138, '1', '', '', 0, 16, 1, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (139, 'Sakatlar, Piçler ve Kırık Şeyler', 'https://www.themoviedb.org/t/p/original/jri960hz39eulThP66dd9emTxvs.jpg', 'Topraklarına dönerken Winterfell’e yolu düşen Tyrion,burada hoş karşılanmaz.Catelyn ise oğlu için adalet istemektedir.', 4, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (140, 'Kış Geliyor', 'https://www.themoviedb.org/t/p/original/9hGF3WUkBf7cSjMg0cdMDHJkByd.jpg', 'Duvarın ardında büyük gizemler yaşanıyor iken Kral Robert Baratheon,Winterfell’deki eski dostu Ned Stark’a önemli bir teklif yapmaya gelir.', 1, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (141, 'Altın Taç', 'https://www.themoviedb.org/t/p/original/AdhvrJxyYpINwYnGkBIf2krQKg.jpg', 'Bran küçük bir gezintiye çıkar.Kral’ın av gezisi esnasında Ned,aradığı soruya cevap bulacaktır.Doğuda,Khaleesi için büyük bir şölen verilir.', 6, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (142, 'Sivri Uç', 'https://www.themoviedb.org/t/p/original/9ZvT1IZPcC11eiCByOzqQvC3CCR.jpg', 'Lannister’lar ile Stark’lar arasındaki gerginlik artarken Winterfell,savaşa hazırlanmaktadır.Gece nöbetçilerini kuzeyde başka bir tehlike bekler.', 8, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (143, 'Ateş ve Kan', 'https://www.themoviedb.org/t/p/original/y1BXkhEqBQS3ewQeqqdHpjhTts0.jpg', '(SEZON FİNALİ) Ned Stark’ın idamı Yedi Krallıkta duyulmuş iken,kuzey haneleri savaş için birleşecektir.Denizin ötesinde,Daenerys büyük bir bedel öder.', 10, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (144, 'Baelor', 'https://www.themoviedb.org/t/p/original/fAmBhmw1pQc6fucrdmnRM5FOpXD.jpg', 'Daenerys,eşini kurtarabilmek için Dothraki’lerin onaylamadığı tehlikeli bir yola başvurur.Tahta geçen Joffrey,Ned Stark’ı yargılar.', 9, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (145, 'Kral Yolu', 'https://www.themoviedb.org/t/p/original/l0GJx3IR8YasbztTJi5uK0XqkEo.jpg', 'Yaşanan kazanın gizemi henüz çözülmemiş iken Ned Stark güneye doğru yola çıkar.Targaryen’lar hak ettikleri demir tahtı geri almak istemektedir.', 2, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (146, 'Kazan yada Öl', 'https://www.themoviedb.org/t/p/original/o6ldSDhIINGNKZR62mHf2m64dD.jpg', 'Kral’ın ağır yaralanmasının ardından kimin demir tahta oturacağı tartışılmaktadır.Riverlands’de yaşananlar Lannister’ları harekete geçirir.', 7, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (147, 'Kurt ve Aslan', 'https://www.themoviedb.org/t/p/original/u7e1qSWE6v8jfY9vGNrckX47DGN.jpg', 'Kuzeyde ve doğuda yaşanan gelişmeler Kral Toprakları’nda duyulunca,Yedi Krallık’ın kuzey ve güney haneleri arasında gerginlikler baş gösterir.', 5, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (148, 'Lord Snow', 'https://www.themoviedb.org/t/p/original/8HjOlb4slc1xusMgOtoNpxuTgSI.jpg', 'Kara Kale’ye varan Jon Snow için zorlu gece nöbetçiliği başlar.Doğuda ise Daenerys,Dothraki’ler tarafından saygı görmeye başlar.', 3, 52, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (149, 'Visitation Place', 'https://www.themoviedb.org/t/p/original/jTesVrxg1CkdKYHeQsYDOYDAW2R.jpg', 'Tulsa Arena\'da Dwight ve şirketi, yeni iş planlarını test ederken bir motorcu çetesi, onları bölgelerini savunmaya zorlar. Tyson, babasıyla kendi geleceği hakkında bir tartışma yaşar. Dwight beklenmedik bir telefon alır.', 4, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (150, 'Center of the Universe', 'https://www.themoviedb.org/t/p/original/2CpHeTMQQJjgIAWXE3VyPeUPmux.jpg', 'Dwight, Tyson ve Bodhi bazı işleri halletmek için bir seyahate çıkar ve grup, rotayı beklenmedik şekilde değiştirir. Stacy, Dwight\'ın geçmişini araştırır.', 2, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (151, 'Adobe Walls', 'https://www.themoviedb.org/t/p/original/eCvaXeQvzDjxYPC9Vxv4va7RLGD.jpg', 'Dwight ve Bodhi, kumarhane planını Jimmy\'ye sunar. Baskı artarken Dwight, Mitch ve Tyson takımlarını bir araya toplar. Stacy, Waltrip ile yüzleşir.', 8, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (152, 'Caprice', 'https://www.themoviedb.org/t/p/original/ntW59Upv7ihGxHgYLTQDNYu5y4b.jpg', 'Dwight, olası bir yeni iş fırsatıyla ilgilenir. Sonrasında sıradan bir işin tahrip edici ve beklenmedik sonuçları olur. Stacy, Tulsa\'ya gelme sebebini Dwight\'a açıklar.', 3, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (153, 'Happy Trails', 'https://www.themoviedb.org/t/p/original/5kme01g9nQhOwxaLs4corudfpoe.jpg', 'Dwight\'ın ekibi ve Waltrip arasındaki gerginlik geri dönülemez bir noktaya varır ve herkes elini taşın altına koyar. Başka bir yerde ise geçmişe yaşanmış bir olay, Dwight\'ın 25 yıl önce neden hapsi boyladığını açığa çıkarır.', 9, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (154, 'Stable', 'https://www.themoviedb.org/t/p/original/pvsWgF9Q8KEKq1AAFXqt3mx1YB3.jpg', 'Dwight, Tulsa\'ya dönmeden önce Tina\'yı ziyaret eder. Pete, Goodie\'yi Oklahoma\'ya göndermeyi kabul eder. Bu sırada Roxy, FBI\'ı uzaklaştırmaya çalışır. Dwight, Mitch\'e bir teklif sunar.', 6, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (155, 'Warr Acres', 'https://www.themoviedb.org/t/p/original/bodFvKO9iKvtdzWG2E4MnBRtpRU.jpg', 'Stacy, ciddi sonuçlar doğuran bir karar verir. Dwight ve Mitch kanıtlardan kurtulur, Bodhi ise yeni bir plan önerir. Tina geleceği üstüne kafa yorar.', 7, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (156, 'Go West, Old Man', 'https://www.themoviedb.org/t/p/original/dOe72mwnTFg6ec4gX8szoNgafEr.jpg', 'Mafya ailesinin New York\'ta ona iş olmadığını söylemesi üzerine şaşkına dönen Dwight, Oklahoma, Tulsa\'ya gönderilir. Yeni çevresini gözlemlemeye başlayan Dwight, burada vakit kaybetmeden arkadaşlar edinir.', 1, 53, 0, 0, 1, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (157, 'Token Joe', 'https://www.themoviedb.org/t/p/original/ef8FQKmaxMVyj19JubHl3mgOdIB.jpg', 'Dwight, talihsiz koşullar nedeniyle New York\'a döner. Kızı ve ailesiyle yeniden buluşması pek de beklendiği gibi gitmez. Tulsa\'da ise Tyson başını derde sokar. Armand, Roxy\'den bazı haberler alır.', 5, 53, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (158, 'Center of the Universe', 'https://www.themoviedb.org/t/p/original/2CpHeTMQQJjgIAWXE3VyPeUPmux.jpg', 'Dwight, Tyson ve Bodhi bazı işleri halletmek için bir seyahate çıkar ve grup, rotayı beklenmedik şekilde değiştirir. Stacy, Dwight\'ın geçmişini araştırır.', 2, 54, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (159, 'Caprice', 'https://www.themoviedb.org/t/p/original/ntW59Upv7ihGxHgYLTQDNYu5y4b.jpg', 'Dwight, olası bir yeni iş fırsatıyla ilgilenir. Sonrasında sıradan bir işin tahrip edici ve beklenmedik sonuçları olur. Stacy, Tulsa\'ya gelme sebebini Dwight\'a açıklar.', 3, 54, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (160, 'Token Joe', 'https://www.themoviedb.org/t/p/original/ef8FQKmaxMVyj19JubHl3mgOdIB.jpg', 'Dwight, talihsiz koşullar nedeniyle New York\'a döner. Kızı ve ailesiyle yeniden buluşması pek de beklendiği gibi gitmez. Tulsa\'da ise Tyson başını derde sokar. Armand, Roxy\'den bazı haberler alır.', 5, 54, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (161, 'Warr Acres', 'https://www.themoviedb.org/t/p/original/bodFvKO9iKvtdzWG2E4MnBRtpRU.jpg', 'Stacy, ciddi sonuçlar doğuran bir karar verir. Dwight ve Mitch kanıtlardan kurtulur, Bodhi ise yeni bir plan önerir. Tina geleceği üstüne kafa yorar.', 7, 54, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (162, 'Visitation Place', 'https://www.themoviedb.org/t/p/original/jTesVrxg1CkdKYHeQsYDOYDAW2R.jpg', 'Tulsa Arena\'da Dwight ve şirketi, yeni iş planlarını test ederken bir motorcu çetesi, onları bölgelerini savunmaya zorlar. Tyson, babasıyla kendi geleceği hakkında bir tartışma yaşar. Dwight beklenmedik bir telefon alır.', 4, 54, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (163, 'Go West, Old Man', 'https://www.themoviedb.org/t/p/original/dOe72mwnTFg6ec4gX8szoNgafEr.jpg', 'Mafya ailesinin New York\'ta ona iş olmadığını söylemesi üzerine şaşkına dönen Dwight, Oklahoma, Tulsa\'ya gönderilir. Yeni çevresini gözlemlemeye başlayan Dwight, burada vakit kaybetmeden arkadaşlar edinir.', 1, 54, 0, 0, 1, '', '', 0, '', '', '', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (164, 'Stable', 'https://www.themoviedb.org/t/p/original/pvsWgF9Q8KEKq1AAFXqt3mx1YB3.jpg', 'Dwight, Tulsa\'ya dönmeden önce Tina\'yı ziyaret eder. Pete, Goodie\'yi Oklahoma\'ya göndermeyi kabul eder. Bu sırada Roxy, FBI\'ı uzaklaştırmaya çalışır. Dwight, Mitch\'e bir teklif sunar.', 6, 54, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (165, 'Adobe Walls', 'https://www.themoviedb.org/t/p/original/eCvaXeQvzDjxYPC9Vxv4va7RLGD.jpg', 'Dwight ve Bodhi, kumarhane planını Jimmy\'ye sunar. Baskı artarken Dwight, Mitch ve Tyson takımlarını bir araya toplar. Stacy, Waltrip ile yüzleşir.', 8, 54, 0, 0, 0, '', '', 0, '', '', '0', '', '');
INSERT INTO `web_series_episoade` (`id`, `Episoade_Name`, `episoade_image`, `episoade_description`, `episoade_order`, `season_id`, `downloadable`, `type`, `status`, `source`, `url`, `skip_available`, `intro_start`, `intro_end`, `end_credits_marker`, `drm_uuid`, `drm_license_uri`) VALUES (166, 'Happy Trails', 'https://www.themoviedb.org/t/p/original/5kme01g9nQhOwxaLs4corudfpoe.jpg', 'Dwight\'ın ekibi ve Waltrip arasındaki gerginlik geri dönülemez bir noktaya varır ve herkes elini taşın altına koyar. Başka bir yerde ise geçmişe yaşanmış bir olay, Dwight\'ın 25 yıl önce neden hapsi boyladığını açığa çıkarır.', 9, 54, 0, 0, 0, '', '', 0, '', '', '0', '', '');


#
# TABLE STRUCTURE FOR: web_series_seasons
#

DROP TABLE IF EXISTS `web_series_seasons`;

CREATE TABLE `web_series_seasons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Session_Name` text NOT NULL,
  `season_order` int(11) NOT NULL,
  `web_series_id` int(11) NOT NULL,
  `status` int(11) NOT NULL COMMENT '0=Not Released, 1=Released',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (1, '2. Sezon', 2, 1, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (2, '1. Sezon', 1, 1, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (3, '4. Sezon', 4, 1, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (4, '3. Sezon', 3, 1, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (5, '1 Sezon ', 1, 2, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (6, 'Sezon 1', 1, 3, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (7, '2. Sezon', 2, 4, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (8, '1. Sezon', 1, 4, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (9, '3. Sezon', 3, 4, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (10, '4. Sezon', 4, 4, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (11, 'Sezon 1', 1, 5, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (13, 'Sezon 3', 3, 6, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (14, 'Sezon 4', 4, 6, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (15, 'Sezon 1', 1, 6, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (16, 'Sezon 5', 5, 6, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (17, 'Sezon 2', 2, 6, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (18, 'Sezon 1', 1, 7, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (19, 'Sezon 1', 1, 8, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (20, 'Sezon 4', 4, 8, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (21, 'Sezon 6', 6, 8, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (22, 'Sezon 3', 3, 8, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (23, 'Sezon 2', 2, 8, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (24, 'Sezon 5', 5, 8, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (25, 'Ã–zel YayÄ±n', 0, 9, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (26, 'Sezon 1', 1, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (27, 'Sezon 5', 5, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (28, 'Sezon 3', 3, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (29, 'Sezon 2', 2, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (30, 'Sezon 7', 7, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (31, 'Sezon 6', 6, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (32, 'Sezon 4', 4, 9, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (33, 'Season 1', 1, 10, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (34, 'Sezon 2', 2, 10, 0);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (37, 'Sezon 3', 3, 14, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (38, 'Sezon 4', 4, 14, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (39, 'Sezon 5', 5, 14, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (40, 'Sezon 1', 1, 14, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (41, 'Sezon 2', 2, 14, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (42, 'Sezon 1', 1, 15, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (43, '2. Sezon', 2, 16, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (44, '1.Sezon', 1, 16, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (45, '3. sezon', 3, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (46, '2. sezon', 2, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (47, '7.Sezon', 7, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (48, '4. sezon', 4, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (49, '8.Sezon', 8, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (50, '6. sezon', 6, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (51, '5. sezon', 5, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (52, '1. sezon', 1, 17, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (53, 'Sezon 1', 1, 18, 1);
INSERT INTO `web_series_seasons` (`id`, `Session_Name`, `season_order`, `web_series_id`, `status`) VALUES (54, 'Sezon 2', 2, 18, 1);


