<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class LicenseModel extends CI_Model {

    function __construct()
    {
        parent::__construct();
    }

    // Always returns success for license verification
    function verify($User_name, $License_Code) {
        return array(
            'status' => 'success',
            'data' => array(
                'username' => $User_name,
                'license' => $License_Code,
                'message' => 'License verification successful.'
            )
        );
    }

    // Simulates updating license details in the database
    function auth($User_name, $License_Code) {
        // Example token and type for demonstration
        $token = 'dummy_token';
        $token_type = 'Bearer';

        $this->db->set('license_user', $User_name);
        $this->db->set('license_code', $License_Code);
        $this->db->set('license_access_token', $token);
        $this->db->set('license_token_type', $token_type);
        $this->db->where('id', 1);
        $this->db->update('config');

        return array(
            'status' => 'success',
            'message' => 'License Code verified and updated successfully!'
        );
    }

    // Simulates license check without actual verification
    function licence() {
        // Simulated license data
        $license_data = array(
            'license_type' => 'Standard',
            'expires_at' => '2025-12-31'
        );

        return array(
            'status' => 'success',
            'data' => $license_data,
            'message' => 'License is valid.'
        );
    }
}