<?php
//change to own api's
class ContentApi extends CI_Controller {
    public function searchContentData() {
        $this->load->database();
        $result = $this->db->get("config");
        $config = $result->row();
        $server_ip = $_SERVER["SERVER_ADDR"] ?? $_SERVER["LOCAL_ADDR"] ?? gethostbyname(gethostname());
        $query = $this->input->get("query");
        $type = $this->input->get("type") ?? "movie";
        $language = $this->input->get("language") ?? "en-US";
        $url = "https://onebytesolution.com/api/dooo/dooo_tmdb_index?query=" . urlencode($query) . "&filter=search&type=" . urlencode($type) . "&language=" . urlencode($language);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: " . $config->license_token_type . " " . $config->license_access_token, "X-Server-IP: " . $server_ip));
        $response = curl_exec($ch);
        if (!curl_errno($ch)) {
            curl_close($ch);
            $this->output->set_content_type("application/json")->set_output($response);
        } else {
            $error = curl_error($ch);
            curl_close($ch);
            show_error("cURL Error: " . $error);
        }
    }

    public function findTmdbID() {
        $this->load->database();
        $result = $this->db->get("config");
        $config = $result->row();
        $server_ip = $_SERVER["SERVER_ADDR"] ?? $_SERVER["LOCAL_ADDR"] ?? gethostbyname(gethostname());
        $id = $this->input->get("id");
        if (!empty($id)) {
            $url = "https://onebytesolution.com/api/dooo/dooo_tmdb_index?filter=find&type=&id=" . urlencode($id);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: " . $config->license_token_type . " " . $config->license_access_token, "X-Server-IP: " . $server_ip));
            $response = curl_exec($ch);
            if (!curl_errno($ch)) {
                curl_close($ch);
                $this->output->set_content_type("application/json")->set_output($response);
            } else {
                $error = curl_error($ch);
                curl_close($ch);
                show_error("cURL Error: " . $error);
            }
        } else {
            show_404();
        }
    }

    public function fetchTmdbData() {
        $this->load->database();
        $result = $this->db->get("config");
        $config = $result->row();
        $server_ip = $_SERVER["SERVER_ADDR"] ?? $_SERVER["LOCAL_ADDR"] ?? gethostbyname(gethostname());
        $type = $this->input->get("type");
        $id = $this->input->get("id");
        $id_type = $this->input->get("id_type");
        $language = $this->input->get("language");
        $image_provider = $config->image_storage_provider;
        $api_key = $config->imgbb_api_key;
        if (!empty($id)) {
            $url = "https://onebytesolution.com/api/dooo/dooo_tmdb_index?filter=single&type=" . urlencode($type) . "&id=" . urlencode($id) . "&id_type=" . urlencode($id_type) . "&language=" . urlencode($language) . "&image_storage_provider=" . urlencode($image_provider) . "&key=" . urlencode($api_key);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: " . $config->license_token_type . " " . $config->license_access_token, "X-Server-IP: " . $server_ip));
            $response = curl_exec($ch);
            if (!curl_errno($ch)) {
                curl_close($ch);
                $this->output->set_content_type("application/json")->set_output($response);
            } else {
                $error = curl_error($ch);
                curl_close($ch);
                show_error("cURL Error: " . $error);
            }
        } else {
            show_404();
        }
    }

    public function fetchVideoData() {
        $this->load->database();
        $result = $this->db->get("config");
        $config = $result->row();
        $server_ip = $_SERVER["SERVER_ADDR"] ?? $_SERVER["LOCAL_ADDR"] ?? gethostbyname(gethostname());
        $id = $this->input->get("id");
        $type = $this->input->get("type");
        if (!(empty($id) || empty($type))) {
            $url = "https://onebytesolution.com/api/dooo/dooo_tmdb_video?id=" . urlencode($id) . "&type=" . urlencode($type);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: " . $config->license_token_type . " " . $config->license_access_token, "X-Server-IP: " . $server_ip));
            $response = curl_exec($ch);
            if (!curl_errno($ch)) {
                curl_close($ch);
                $this->output->set_content_type("application/json")->set_output($response);
            } else {
                $error = curl_error($ch);
                curl_close($ch);
                show_error("cURL Error: " . $error);
            }
        } else {
            show_404();
        }
    }

    public function fetchAllSeasonData() {
        $this->load->database();
        $result = $this->db->get("config");
        $config = $result->row();
        $server_ip = $_SERVER["SERVER_ADDR"] ?? $_SERVER["LOCAL_ADDR"] ?? gethostbyname(gethostname());
        $type = $this->input->get("type");
        $id = $this->input->get("id");
        $id_type = $this->input->get("id_type");
        $language = $this->input->get("language");
        $image_provider = $config->image_storage_provider;
        $api_key = $config->imgbb_api_key;
        if (!empty($id)) {
            $url = "https://onebytesolution.com/api/dooo/dooo_tmdb_index?filter=single&type=" . urlencode($type) . "&id=" . urlencode($id) . "&id_type=" . urlencode($id_type) . "&language=" . urlencode($language) . "&image_storage_provider=" . urlencode($image_provider) . "&key=" . urlencode($api_key);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: " . $config->license_token_type . " " . $config->license_access_token, "X-Server-IP: " . $server_ip));
            $response = curl_exec($ch);
            if (!curl_errno($ch)) {
                curl_close($ch);
                $this->output->set_content_type("application/json")->set_output($response);
            } else {
                $error = curl_error($ch);
                curl_close($ch);
                show_error("cURL Error: " . $error);
            }
        } else {
            show_404();
        }
    }

    public function fetchAllEpisodeData() {
        $this->load->database();
        $result = $this->db->get("config");
        $config = $result->row();
        $server_ip = $_SERVER["SERVER_ADDR"] ?? $_SERVER["LOCAL_ADDR"] ?? gethostbyname(gethostname());
        $type = $this->input->get("type");
        $id = $this->input->get("id");
        $season_no = $this->input->get("season_no");
        $language = $this->input->get("language");
        $image_provider = $config->image_storage_provider;
        $api_key = $config->imgbb_api_key;
        if (!(empty($id) || empty($season_no))) {
            $url = "https://onebytesolution.com/api/dooo/dooo_tmdb_index?filter=season&type=" . urlencode($type) . "&id=" . urlencode($id) . "&season_no=" . urlencode($season_no) . "&language=" . urlencode($language) . "&image_storage_provider=" . urlencode($image_provider) . "&key=" . urlencode($api_key);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Authorization: " . $config->license_token_type . " " . $config->license_access_token, "X-Server-IP: " . $server_ip));
            $response = curl_exec($ch);
            if (!curl_errno($ch)) {
                curl_close($ch);
                $this->output->set_content_type("application/json")->set_output($response);
            } else {
                $error = curl_error($ch);
                curl_close($ch);
                show_error("cURL Error: " . $error);
            }
        } else {
            show_404();
        }
    }
}